/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.ozone.recon.persistence.ContainerHistory;
import org.apache.ozone.recon.schema.generated.tables.pojos.UnhealthyContainers;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class UnhealthyContainerMetadata {
    @XmlElement(name="containerID")
    private long containerID;
    @XmlElement(name="containerState")
    private String containerState;
    @XmlElement(name="unhealthySince")
    private long unhealthySince;
    @XmlElement(name="expectedReplicaCount")
    private long expectedReplicaCount = 0L;
    @XmlElement(name="actualReplicaCount")
    private long actualReplicaCount = 0L;
    @XmlElement(name="replicaDeltaCount")
    private long replicaDeltaCount = 0L;
    @XmlElement(name="reason")
    private String reason;
    @XmlElement(name="keys")
    private long keys;
    @XmlElement(name="pipelineID")
    private UUID pipelineID;
    @XmlElement(name="replicas")
    private List<ContainerHistory> replicas;

    public UnhealthyContainerMetadata(UnhealthyContainers rec, List<ContainerHistory> replicas, UUID pipelineID, long keyCount) {
        this.containerID = rec.getContainerId();
        this.containerState = rec.getContainerState();
        this.unhealthySince = rec.getInStateSince();
        this.actualReplicaCount = rec.getActualReplicaCount().intValue();
        this.expectedReplicaCount = rec.getExpectedReplicaCount().intValue();
        this.replicaDeltaCount = rec.getReplicaDelta().intValue();
        this.reason = rec.getReason();
        this.replicas = replicas;
        this.pipelineID = pipelineID;
        this.keys = keyCount;
    }

    public UnhealthyContainerMetadata() {
    }

    public long getContainerID() {
        return this.containerID;
    }

    public long getKeys() {
        return this.keys;
    }

    public List<ContainerHistory> getReplicas() {
        return this.replicas;
    }

    public String getContainerState() {
        return this.containerState;
    }

    public long getExpectedReplicaCount() {
        return this.expectedReplicaCount;
    }

    public long getActualReplicaCount() {
        return this.actualReplicaCount;
    }

    public long getReplicaDeltaCount() {
        return this.replicaDeltaCount;
    }

    public String getReason() {
        return this.reason;
    }

    public long getUnhealthySince() {
        return this.unhealthySince;
    }

    public UUID getPipelineID() {
        return this.pipelineID;
    }
}

