/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import java.util.TimeZone;
import org.apache.hadoop.ozone.recon.ReconUtils;

public class ParamInfo {
    private String startPrefix;
    private long keySize;
    private String creationDate;
    private long creationDateEpoch = -1L;
    private String replicationType;
    private int limit;
    private String prevKey;
    private String lastKey;
    private boolean skipPrevKeyDone = false;
    private long currentCount;

    public ParamInfo(String replicationType, String creationDate, long keySize, String startPrefix, String prevKey, int limit, boolean skipPrevKeyDone, String lastKey) {
        this.replicationType = replicationType;
        this.creationDate = creationDate;
        this.keySize = keySize;
        this.startPrefix = startPrefix;
        this.prevKey = prevKey;
        this.limit = limit;
        this.skipPrevKeyDone = skipPrevKeyDone;
        this.lastKey = lastKey;
    }

    public String getStartPrefix() {
        return this.startPrefix;
    }

    public void setStartPrefix(String startPrefix) {
        this.startPrefix = startPrefix;
    }

    public long getKeySize() {
        return this.keySize;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public long getCreationDateEpoch() {
        if (this.creationDateEpoch == -1L) {
            this.creationDateEpoch = ReconUtils.convertToEpochMillis(this.getCreationDate(), "MM-dd-yyyy HH:mm:ss", TimeZone.getDefault());
        }
        return this.creationDateEpoch;
    }

    public String getReplicationType() {
        return this.replicationType;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public long getCurrentCount() {
        return this.currentCount;
    }

    public void setCurrentCount(long currentCount) {
        this.currentCount = currentCount;
    }

    public String getPrevKey() {
        return this.prevKey;
    }

    public void setPrevKey(String prevKey) {
        this.prevKey = prevKey;
    }

    public boolean isSkipPrevKeyDone() {
        return this.skipPrevKeyDone;
    }

    public void setSkipPrevKeyDone(boolean skipPrevKeyDone) {
        this.skipPrevKeyDone = skipPrevKeyDone;
    }

    public String getLastKey() {
        return this.lastKey;
    }

    public void setLastKey(String lastKey) {
        this.lastKey = lastKey;
    }
}

