/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.ContainerTokenGenerator;
import org.apache.hadoop.hdds.security.token.ContainerTokenIdentifier;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerTokenSecretManager
extends ShortLivedTokenSecretManager<ContainerTokenIdentifier>
implements ContainerTokenGenerator {
    public ContainerTokenSecretManager(long tokenLifetime, SecretKeySignerClient secretKeyClient) {
        super(tokenLifetime, secretKeyClient);
    }

    public ContainerTokenIdentifier createIdentifier(String user, ContainerID containerID) {
        return new ContainerTokenIdentifier(user, containerID, this.getTokenExpiryTime());
    }

    @Override
    public String generateEncodedToken(ContainerID containerID) {
        String user;
        try {
            user = UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to get current user", e);
        }
        try {
            return this.generateToken(user, containerID).encodeToUrlString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to encode token", e);
        }
    }

    @Override
    public Token<ContainerTokenIdentifier> generateToken(String user, ContainerID containerID) {
        return this.generateToken(this.createIdentifier(user, containerID));
    }
}

