/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.symmetric;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;

public class SecretKeyConfig {
    private final Path localSecretKeyFile;
    private final Duration rotateDuration;
    private final Duration expiryDuration;
    private final String algorithm;
    private final Duration rotationCheckDuration;

    public SecretKeyConfig(ConfigurationSource conf, String component) {
        String metadataDir = conf.get("hdds.metadata.dir", conf.get("ozone.metadata.dirs"));
        String keyDir = conf.get("hdds.key.dir.name", "keys");
        String fileName = conf.get("hdds.secret.key.file.name", "secret_keys.json");
        this.localSecretKeyFile = Paths.get(metadataDir, component, keyDir, fileName);
        this.rotateDuration = SecretKeyConfig.parseRotateDuration(conf);
        this.expiryDuration = SecretKeyConfig.parseExpiryDuration(conf);
        this.rotationCheckDuration = SecretKeyConfig.parseRotateCheckDuration(conf);
        this.algorithm = conf.get("hdds.secret.key.algorithm", "HmacSHA256");
    }

    public static Duration parseExpiryDuration(ConfigurationSource conf) {
        long expiryDurationInMs = conf.getTimeDuration("hdds.secret.key.expiry.duration", "7d", TimeUnit.MILLISECONDS);
        return Duration.ofMillis(expiryDurationInMs);
    }

    public static Duration parseRotateDuration(ConfigurationSource conf) {
        long rotateDurationInMs = conf.getTimeDuration("hdds.secret.key.rotate.duration", "1d", TimeUnit.MILLISECONDS);
        return Duration.ofMillis(rotateDurationInMs);
    }

    public static Duration parseRotateCheckDuration(ConfigurationSource conf) {
        long rotationCheckInMs = conf.getTimeDuration("hdds.secret.key.rotate.check.duration", "10m", TimeUnit.MILLISECONDS);
        return Duration.ofMillis(rotationCheckInMs);
    }

    public Path getLocalSecretKeyFile() {
        return this.localSecretKeyFile;
    }

    public Duration getRotateDuration() {
        return this.rotateDuration;
    }

    public Duration getExpiryDuration() {
        return this.expiryDuration;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Duration getRotationCheckDuration() {
        return this.rotationCheckDuration;
    }
}

