/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import com.google.protobuf.MessageLite;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.ClientVersion;

public class MoveDataNodePair {
    private static final Codec<MoveDataNodePair> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)HddsProtos.MoveDataNodePairProto.getDefaultInstance()), MoveDataNodePair::getFromProtobuf, pair -> pair.getProtobufMessage(ClientVersion.CURRENT_VERSION), MoveDataNodePair.class, DelegatedCodec.CopyType.SHALLOW);
    private final DatanodeDetails src;
    private final DatanodeDetails tgt;

    public static Codec<MoveDataNodePair> getCodec() {
        return CODEC;
    }

    public MoveDataNodePair(DatanodeDetails src, DatanodeDetails tgt) {
        this.src = src;
        this.tgt = tgt;
    }

    public DatanodeDetails getTgt() {
        return this.tgt;
    }

    public DatanodeDetails getSrc() {
        return this.src;
    }

    public HddsProtos.MoveDataNodePairProto getProtobufMessage(int clientVersion) {
        return HddsProtos.MoveDataNodePairProto.newBuilder().setSrc(this.src.toProto(clientVersion)).setTgt(this.tgt.toProto(clientVersion)).build();
    }

    public static MoveDataNodePair getFromProtobuf(HddsProtos.MoveDataNodePairProto mdnpp) {
        Objects.requireNonNull(mdnpp, "mdnpp == null");
        DatanodeDetails src = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)mdnpp.getSrc());
        DatanodeDetails tgt = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)mdnpp.getTgt());
        return new MoveDataNodePair(src, tgt);
    }
}

