/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.LongSupplier;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

public abstract class AbstractSpaceUsageSource
implements SpaceUsageSource {
    private final File file;
    private final String path;

    protected AbstractSpaceUsageSource(File file) {
        this.file = file;
        try {
            this.path = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static long time(LongSupplier supplier, Logger logger) {
        long start = Time.monotonicNow();
        long result = supplier.getAsLong();
        long end = Time.monotonicNow();
        long elapsed = end - start;
        logger.debug("Completed check in {} ms, result: {}", (Object)elapsed, (Object)result);
        return result;
    }

    protected String getPath() {
        return this.path;
    }

    protected File getFile() {
        return this.file;
    }

    public String toString() {
        return this.path;
    }

    public long getAvailable() {
        return this.file.getUsableSpace();
    }

    public long getCapacity() {
        return this.file.getTotalSpace();
    }
}

