/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.configurator.ProducerConfigurator;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.events.configurator.ProducerConfiguratorImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public class ProcessProducerImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessProducer<T, X> {
    private final AnnotatedMember<T> annotatedMember;
    private AbstractProducerBean<T, X, ?> bean;
    private ProducerConfiguratorImpl<X> configurator;
    private boolean producerSet;

    protected static <T, X> void fire(BeanManagerImpl beanManager, AbstractProducerBean<T, X, Member> bean) {
        if (beanManager.isBeanEnabled(bean)) {
            new ProcessProducerImpl<T, X>(beanManager, (AnnotatedMember)Reflections.cast(bean.getAnnotated()), (AbstractProducerBean)bean){}.fire();
        }
    }

    private ProcessProducerImpl(BeanManagerImpl beanManager, AnnotatedMember<T> annotatedMember, AbstractProducerBean<T, X, ?> bean) {
        super(beanManager, (Type)((Object)ProcessProducer.class), new Type[]{bean.getAnnotated().getDeclaringType().getBaseType(), bean.getAnnotated().getBaseType()});
        this.bean = bean;
        this.annotatedMember = annotatedMember;
    }

    @Override
    public AnnotatedMember<T> getAnnotatedMember() {
        this.checkWithinObserverNotification();
        return this.annotatedMember;
    }

    @Override
    public Producer<X> getProducer() {
        this.checkWithinObserverNotification();
        return this.bean.getProducer();
    }

    @Override
    public void setProducer(Producer<X> producer) {
        if (this.configurator != null) {
            throw BootstrapLogger.LOG.configuratorAndSetMethodBothCalled(ProcessProducer.class.getSimpleName(), this.getReceiver());
        }
        Preconditions.checkArgumentNotNull(producer, "producer");
        this.checkWithinObserverNotification();
        BootstrapLogger.LOG.setProducerCalled(this.getReceiver(), this.getProducer(), producer);
        this.bean.setProducer(producer);
        this.producerSet = true;
    }

    @Override
    public ProducerConfigurator<X> configureProducer() {
        if (this.producerSet) {
            throw BootstrapLogger.LOG.configuratorAndSetMethodBothCalled(ProcessProducer.class.getSimpleName(), this.getReceiver());
        }
        this.checkWithinObserverNotification();
        if (this.configurator == null) {
            this.configurator = new ProducerConfiguratorImpl(this.bean.getProducer());
        }
        BootstrapLogger.LOG.configureProducerCalled(this.getReceiver(), this.bean);
        return this.configurator;
    }

    @Override
    public void postNotify(Extension extension) {
        super.postNotify(extension);
        if (this.configurator != null) {
            this.bean.setProducer((Producer<X>)this.configurator.complete());
            this.configurator = null;
        }
        this.producerSet = false;
    }
}

