/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.apache.ozone.fs.http.HttpFSConstants;
import org.apache.ozone.fs.http.server.FSOperations;
import org.apache.ozone.fs.http.server.HttpFSParametersProvider;
import org.apache.ozone.fs.http.server.HttpFSServerWebApp;
import org.apache.ozone.fs.http.server.JsonUtil;
import org.apache.ozone.lib.service.FileSystemAccess;
import org.apache.ozone.lib.service.FileSystemAccessException;
import org.apache.ozone.lib.service.Groups;
import org.apache.ozone.lib.service.Instrumentation;
import org.apache.ozone.lib.servlet.FileSystemReleaseFilter;
import org.apache.ozone.lib.wsrs.InputStreamEntity;
import org.apache.ozone.lib.wsrs.Parameters;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Path(value="/v1")
@InterfaceAudience.Private
public class HttpFSServer {
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)"httpfsaudit");
    private static final Logger LOG = LoggerFactory.getLogger(HttpFSServer.class);
    private static final HttpFSParametersProvider PARAMETERS_PROVIDER = new HttpFSParametersProvider();
    private AccessMode accessMode = AccessMode.READWRITE;

    private Parameters getParams(HttpServletRequest request) {
        return PARAMETERS_PROVIDER.get(request);
    }

    public HttpFSServer() {
        Configuration conf = HttpFSServerWebApp.get().getConfig();
        String accessModeString = conf.get("httpfs.access.mode", "read-write").toLowerCase();
        this.accessMode = accessModeString.compareTo("write-only") == 0 ? AccessMode.WRITEONLY : (accessModeString.compareTo("read-only") == 0 ? AccessMode.READONLY : AccessMode.READWRITE);
    }

    private <T> T fsExecute(UserGroupInformation ugi, FileSystemAccess.FileSystemExecutor<T> executor) throws IOException, FileSystemAccessException {
        FileSystemAccess fsAccess = HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration();
        return fsAccess.execute(ugi.getShortUserName(), conf, executor);
    }

    private FileSystem createFileSystem(UserGroupInformation ugi) throws IOException, FileSystemAccessException {
        String hadoopUser = ugi.getShortUserName();
        FileSystemAccess fsAccess = HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration();
        FileSystem fs = fsAccess.createFileSystem(hadoopUser, conf);
        FileSystemReleaseFilter.setFileSystem(fs);
        return fs;
    }

    private void enforceRootPath(HttpFSConstants.Operation op, String path) {
        if (!path.equals("/")) {
            throw new UnsupportedOperationException(MessageFormat.format("Operation [{0}], invalid path [{1}], must be '/'", new Object[]{op, path}));
        }
    }

    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public Response getRoot(@Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        return this.get("", uriInfo, op, request);
    }

    private String makeAbsolute(String path) {
        return "/" + (path != null ? path : "");
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response get(@PathParam(value="path") String path, @Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException, UnsupportedOperationException {
        Response response;
        if (op.value() != HttpFSConstants.Operation.GETFILESTATUS && op.value() != HttpFSConstants.Operation.LISTSTATUS && this.accessMode == AccessMode.WRITEONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        Parameters params = this.getParams(request);
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSConstants.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        switch ((HttpFSConstants.Operation)((Object)op.value())) {
            case OPEN: {
                response = this.handleOpen(path, uriInfo, params, user);
                break;
            }
            case GETFILESTATUS: {
                response = this.handleGetFileStatus(path, user);
                break;
            }
            case LISTSTATUS: {
                response = this.handleListStatus(path, params, user);
                break;
            }
            case GETHOMEDIRECTORY: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support GETHOMEDIRECTORY");
            }
            case INSTRUMENTATION: {
                response = this.handleInstrumentation(path, op, user);
                break;
            }
            case GETCONTENTSUMMARY: {
                response = this.handleGetContentSummary(path, user);
                break;
            }
            case GETQUOTAUSAGE: {
                response = this.handleGetQuotaUsage(path, user);
                break;
            }
            case GETFILECHECKSUM: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support GETFILECHECKSUM");
            }
            case GETFILEBLOCKLOCATIONS: {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                break;
            }
            case GETACLSTATUS: {
                response = this.handleGetACLStatus(path, user);
                break;
            }
            case GETXATTRS: {
                response = this.handleGetXAttrs(path, params, user);
                break;
            }
            case LISTXATTRS: {
                response = this.handleListXAttrs(path, user);
                break;
            }
            case LISTSTATUS_BATCH: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support LISTSTATUS_BATCH");
            }
            case GETTRASHROOT: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support GETTRASHROOT");
            }
            case GETALLSTORAGEPOLICY: {
                response = this.handleGetAllStoragePolicy(path, user);
                break;
            }
            case GETSTORAGEPOLICY: {
                response = this.handleGetStoragePolicy(path, user);
                break;
            }
            case GETSNAPSHOTDIFF: {
                response = this.handleGetSnapshotDiff(path, params, user);
                break;
            }
            case GETSNAPSHOTTABLEDIRECTORYLIST: {
                response = this.handleGetSnaphotTableDirectoryList(user);
                break;
            }
            case GETSERVERDEFAULTS: {
                response = this.handleGetServerDefaults(user);
                break;
            }
            case CHECKACCESS: {
                response = this.handleCheckAccess(path, params, user);
                break;
            }
            case GETECPOLICY: {
                response = this.handleGetECPolicy(path, user);
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP GET operation [{0}]", op.value()));
            }
        }
        return response;
    }

    private Response handleGetECPolicy(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSGetErasureCodingPolicy command = new FSOperations.FSGetErasureCodingPolicy(path);
        String js = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)path);
        Response response = Response.ok((Object)js).type("application/json").build();
        return response;
    }

    private Response handleCheckAccess(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String mode = (String)params.get("fsaction", HttpFSParametersProvider.FsActionParam.class);
        HttpFSParametersProvider.FsActionParam fsparam = new HttpFSParametersProvider.FsActionParam(mode);
        FSOperations.FSAccess command = new FSOperations.FSAccess(path, FsAction.getFsAction((String)((String)fsparam.value())));
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)"/");
        Response response = Response.ok().build();
        return response;
    }

    private Response handleGetServerDefaults(UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSGetServerDefaults command = new FSOperations.FSGetServerDefaults();
        String js = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)"/");
        Response response = Response.ok((Object)js).type("application/json").build();
        return response;
    }

    private Response handleGetSnaphotTableDirectoryList(UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSGetSnapshottableDirListing command = new FSOperations.FSGetSnapshottableDirListing();
        String js = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)"/");
        Response response = Response.ok((Object)js).type("application/json").build();
        return response;
    }

    private Response handleGetSnapshotDiff(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String oldSnapshotName = (String)params.get("oldsnapshotname", HttpFSParametersProvider.OldSnapshotNameParam.class);
        String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
        FSOperations.FSGetSnapshotDiff command = new FSOperations.FSGetSnapshotDiff(path, oldSnapshotName, snapshotName);
        String js = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)path);
        Response response = Response.ok((Object)js).type("application/json").build();
        return response;
    }

    private Response handleGetStoragePolicy(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSGetStoragePolicy command = new FSOperations.FSGetStoragePolicy(path);
        JSONObject json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleGetAllStoragePolicy(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSGetAllStoragePolicies command = new FSOperations.FSGetAllStoragePolicies();
        JSONObject json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleListXAttrs(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSListXAttrs command = new FSOperations.FSListXAttrs(path);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("XAttr names for [{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleGetXAttrs(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        List<String> xattrNames = params.getValues("xattr.name", HttpFSParametersProvider.XAttrNameParam.class);
        XAttrCodec encoding = (XAttrCodec)params.get("encoding", HttpFSParametersProvider.XAttrEncodingParam.class);
        FSOperations.FSGetXAttrs command = new FSOperations.FSGetXAttrs(path, xattrNames, encoding);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("XAttrs for [{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleGetACLStatus(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSAclStatus command = new FSOperations.FSAclStatus(path);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("ACL status for [{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleGetQuotaUsage(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSQuotaUsage command = new FSOperations.FSQuotaUsage(path);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("Quota Usage for [{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleGetContentSummary(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSContentSummary command = new FSOperations.FSContentSummary(path);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("Content summary for [{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleInstrumentation(String path, HttpFSParametersProvider.OperationParam op, UserGroupInformation user) throws IOException {
        this.enforceRootPath((HttpFSConstants.Operation)((Object)op.value()), path);
        Groups groups = HttpFSServerWebApp.get().get(Groups.class);
        List<String> userGroups = groups.getGroups(user.getShortUserName());
        if (!userGroups.contains(HttpFSServerWebApp.get().getAdminGroup())) {
            throw new AccessControlException("User not in HttpFSServer admin group");
        }
        Instrumentation instrumentation = HttpFSServerWebApp.get().get(Instrumentation.class);
        Map<String, Map<String, ?>> snapshot = instrumentation.getSnapshot();
        Response response = Response.ok(snapshot).build();
        return response;
    }

    private Response handleListStatus(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String filter = (String)params.get("filter", HttpFSParametersProvider.FilterParam.class);
        FSOperations.FSListStatus command = new FSOperations.FSListStatus(path, filter);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] filter [{}]", (Object)path, (Object)(filter != null ? filter : "-"));
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleGetFileStatus(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSFileStatus command = new FSOperations.FSFileStatus(path);
        Map json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)path);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleOpen(String path, UriInfo uriInfo, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        Response response;
        Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
        if (noRedirect.booleanValue()) {
            URI redirectURL = this.createOpenRedirectionURL(uriInfo);
            String js = JsonUtil.toJsonString("Location", (Object)redirectURL);
            response = Response.ok((Object)js).type("application/json").build();
        } else {
            final FSOperations.FSOpen command = new FSOperations.FSOpen(path);
            final FileSystem fs = this.createFileSystem(user);
            InputStream is = null;
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user.getShortUserName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            try {
                is = (InputStream)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws Exception {
                        return command.execute(fs);
                    }
                });
            }
            catch (InterruptedException ie) {
                LOG.warn("Open interrupted.", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            Long offset = (Long)params.get("offset", HttpFSParametersProvider.OffsetParam.class);
            Long len = (Long)params.get("length", HttpFSParametersProvider.LenParam.class);
            AUDIT_LOG.info("[{}] offset [{}] len [{}]", new Object[]{path, offset, len});
            InputStreamEntity entity = new InputStreamEntity(is, offset, len);
            response = Response.ok((Object)entity).type("application/octet-stream").build();
        }
        return response;
    }

    private URI createOpenRedirectionURL(UriInfo uriInfo) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder.replaceQueryParam("noredirect", (Object[])null);
        return uriBuilder.build((Object[])null);
    }

    @DELETE
    @Path(value="{path:.*}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response delete(@PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        Response response;
        if (this.accessMode == AccessMode.READONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        Parameters params = this.getParams(request);
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSConstants.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        switch ((HttpFSConstants.Operation)((Object)op.value())) {
            case DELETE: {
                response = this.handleDelete(path, params, user);
                break;
            }
            case DELETESNAPSHOT: {
                response = this.handleDeleteSnapshot(path, params, user);
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP DELETE operation [{0}]", op.value()));
            }
        }
        return response;
    }

    private Response handleDeleteSnapshot(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
        FSOperations.FSDeleteSnapshot command = new FSOperations.FSDeleteSnapshot(path, snapshotName);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] deleted snapshot [{}]", (Object)path, (Object)snapshotName);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleDelete(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        Boolean recursive = (Boolean)params.get("recursive", HttpFSParametersProvider.RecursiveParam.class);
        AUDIT_LOG.info("[{}] recursive [{}]", (Object)path, (Object)recursive);
        FSOperations.FSDelete command = new FSOperations.FSDelete(path, recursive);
        JSONObject json = this.fsExecute(user, command);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    @POST
    @Produces(value={"application/json; charset=utf-8"})
    public Response postRoot(InputStream is, @Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        return this.post(is, uriInfo, "/", op, request);
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response post(InputStream is, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        Response response;
        if (this.accessMode == AccessMode.READONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        Parameters params = this.getParams(request);
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSConstants.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        switch ((HttpFSConstants.Operation)((Object)op.value())) {
            case APPEND: {
                response = this.handleAppend(is, uriInfo, path, params, user);
                break;
            }
            case CONCAT: {
                response = this.handleConcat(path, params, user);
                break;
            }
            case TRUNCATE: {
                response = this.handleTruncate(path, params, user);
                break;
            }
            case UNSETSTORAGEPOLICY: {
                response = this.handleUnsetStoragePolicy(path, user);
                break;
            }
            case UNSETECPOLICY: {
                response = this.handleUnsetECPolicy(path, user);
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP POST operation [{0}]", op.value()));
            }
        }
        return response;
    }

    private Response handleUnsetECPolicy(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSUnSetErasureCodingPolicy command = new FSOperations.FSUnSetErasureCodingPolicy(path);
        this.fsExecute(user, command);
        AUDIT_LOG.info("Unset ec policy [{}]", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleUnsetStoragePolicy(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSUnsetStoragePolicy command = new FSOperations.FSUnsetStoragePolicy(path);
        this.fsExecute(user, command);
        AUDIT_LOG.info("Unset storage policy [{}]", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleTruncate(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        Long newLength = (Long)params.get("newlength", HttpFSParametersProvider.NewLengthParam.class);
        FSOperations.FSTruncate command = new FSOperations.FSTruncate(path, newLength);
        JSONObject json = this.fsExecute(user, command);
        AUDIT_LOG.info("Truncate [{}] to length [{}]", (Object)path, (Object)newLength);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleConcat(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String sources = (String)params.get("sources", HttpFSParametersProvider.SourcesParam.class);
        FSOperations.FSConcat command = new FSOperations.FSConcat(path, sources.split(","));
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}]", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleAppend(InputStream is, UriInfo uriInfo, String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        Response response;
        Boolean hasData = (Boolean)params.get("data", HttpFSParametersProvider.DataParam.class);
        URI redirectURL = this.createUploadRedirectionURL(uriInfo, HttpFSConstants.Operation.APPEND);
        Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
        if (noRedirect.booleanValue()) {
            String js = JsonUtil.toJsonString("Location", (Object)redirectURL);
            response = Response.ok((Object)js).type("application/json").build();
        } else if (hasData.booleanValue()) {
            FSOperations.FSAppend command = new FSOperations.FSAppend(is, path);
            this.fsExecute(user, command);
            AUDIT_LOG.info("[{}]", (Object)path);
            response = Response.ok().type("application/json").build();
        } else {
            response = Response.temporaryRedirect((URI)redirectURL).build();
        }
        return response;
    }

    protected URI createUploadRedirectionURL(UriInfo uriInfo, Enum<?> uploadOperation) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder = uriBuilder.replaceQueryParam("op", new Object[]{uploadOperation}).queryParam("data", new Object[]{Boolean.TRUE}).replaceQueryParam("noredirect", (Object[])null);
        return uriBuilder.build(null);
    }

    @PUT
    @Produces(value={"application/json; charset=utf-8"})
    public Response putRoot(InputStream is, @Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        return this.put(is, uriInfo, "/", op, request);
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response put(InputStream is, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        Response response;
        if (this.accessMode == AccessMode.READONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        Parameters params = this.getParams(request);
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSConstants.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        switch ((HttpFSConstants.Operation)((Object)op.value())) {
            case CREATE: {
                response = this.handleCreate(is, uriInfo, path, params, user);
                break;
            }
            case ALLOWSNAPSHOT: {
                response = this.handleAllowSnapshot(path, user);
                break;
            }
            case DISALLOWSNAPSHOT: {
                response = this.handleDisallowSnapshot(path, user);
                break;
            }
            case CREATESNAPSHOT: {
                response = this.handleCreateSnapshot(path, params, user);
                break;
            }
            case SETXATTR: {
                response = this.handleSetXAttr(path, params, user);
                break;
            }
            case RENAMESNAPSHOT: {
                response = this.handleRenameSnapshot(path, params, user);
                break;
            }
            case REMOVEXATTR: {
                response = this.handleRemoveXAttr(path, params, user);
                break;
            }
            case MKDIRS: {
                response = this.handleMkdirs(path, params, user);
                break;
            }
            case RENAME: {
                response = this.handleRename(path, params, user);
                break;
            }
            case SETOWNER: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support SETOWNER");
            }
            case SETPERMISSION: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support SETPERMISSION");
            }
            case SETREPLICATION: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support SETREPLICATION");
            }
            case SETTIMES: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support SETTIMES");
            }
            case SETACL: {
                response = this.handleSetACL(path, params, user);
                break;
            }
            case REMOVEACL: {
                response = this.handleRemoveACL(path, user);
                break;
            }
            case MODIFYACLENTRIES: {
                response = this.handleModifyACLEntries(path, params, user);
                break;
            }
            case REMOVEACLENTRIES: {
                response = this.handleRemoveACLEntries(path, params, user);
                break;
            }
            case REMOVEDEFAULTACL: {
                response = this.handleRemoveDefaultACL(path, user);
                break;
            }
            case SETSTORAGEPOLICY: {
                response = this.handleSetStoragePolicy(path, params, user);
                break;
            }
            case SETECPOLICY: {
                response = this.handleSetECPolicy(path, params, user);
                break;
            }
            case SATISFYSTORAGEPOLICY: {
                throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support SATISFYSTORAGEPOLICY");
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP PUT operation [{0}]", op.value()));
            }
        }
        return response;
    }

    private Response handleSetECPolicy(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String policyName = (String)params.get("ecpolicy", HttpFSParametersProvider.ECPolicyParam.class);
        FSOperations.FSSetErasureCodingPolicy command = new FSOperations.FSSetErasureCodingPolicy(path, policyName);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] to policy [{}]", (Object)path, (Object)policyName);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleSetStoragePolicy(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String policyName = (String)params.get("storagepolicy", HttpFSParametersProvider.PolicyNameParam.class);
        FSOperations.FSSetStoragePolicy command = new FSOperations.FSSetStoragePolicy(path, policyName);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] to policy [{}]", (Object)path, (Object)policyName);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleRemoveDefaultACL(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSRemoveDefaultAcl command = new FSOperations.FSRemoveDefaultAcl(path);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] remove default acl", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleRemoveACLEntries(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String aclSpec = (String)params.get("aclspec", HttpFSParametersProvider.AclPermissionParam.class);
        FSOperations.FSRemoveAclEntries command = new FSOperations.FSRemoveAclEntries(path, aclSpec);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] remove acl entry [{}]", (Object)path, (Object)aclSpec);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleModifyACLEntries(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String aclSpec = (String)params.get("aclspec", HttpFSParametersProvider.AclPermissionParam.class);
        FSOperations.FSModifyAclEntries command = new FSOperations.FSModifyAclEntries(path, aclSpec);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] modify acl entry with [{}]", (Object)path, (Object)aclSpec);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleRemoveACL(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSRemoveAcl command = new FSOperations.FSRemoveAcl(path);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] removed acl", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleSetACL(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String aclSpec = (String)params.get("aclspec", HttpFSParametersProvider.AclPermissionParam.class);
        FSOperations.FSSetAcl command = new FSOperations.FSSetAcl(path, aclSpec);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] to acl [{}]", (Object)path, (Object)aclSpec);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleRename(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String toPath = (String)params.get("destination", HttpFSParametersProvider.DestinationParam.class);
        FSOperations.FSRename command = new FSOperations.FSRename(path, toPath);
        JSONObject json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)toPath);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleMkdirs(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
        Short unmaskedPermission = (Short)params.get("unmaskedpermission", HttpFSParametersProvider.UnmaskedPermissionParam.class);
        FSOperations.FSMkdirs command = new FSOperations.FSMkdirs(path, permission, unmaskedPermission);
        JSONObject json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] permission [{}] unmaskedpermission [{}]", new Object[]{path, permission, unmaskedPermission});
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleRemoveXAttr(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String xattrName = (String)params.get("xattr.name", HttpFSParametersProvider.XAttrNameParam.class);
        FSOperations.FSRemoveXAttr command = new FSOperations.FSRemoveXAttr(path, xattrName);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] removed xAttr [{}]", (Object)path, (Object)xattrName);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleRenameSnapshot(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String oldSnapshotName = (String)params.get("oldsnapshotname", HttpFSParametersProvider.OldSnapshotNameParam.class);
        String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
        FSOperations.FSRenameSnapshot command = new FSOperations.FSRenameSnapshot(path, oldSnapshotName, snapshotName);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] renamed snapshot [{}] to [{}]", new Object[]{path, oldSnapshotName, snapshotName});
        Response response = Response.ok().build();
        return response;
    }

    private Response handleSetXAttr(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String xattrName = (String)params.get("xattr.name", HttpFSParametersProvider.XAttrNameParam.class);
        String xattrValue = (String)params.get("xattr.value", HttpFSParametersProvider.XAttrValueParam.class);
        EnumSet flag = (EnumSet)params.get("flag", HttpFSParametersProvider.XAttrSetFlagParam.class);
        FSOperations.FSSetXAttr command = new FSOperations.FSSetXAttr(path, xattrName, xattrValue, flag);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] to xAttr [{}]", (Object)path, (Object)xattrName);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleCreateSnapshot(String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
        FSOperations.FSCreateSnapshot command = new FSOperations.FSCreateSnapshot(path, snapshotName);
        String json = this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] snapshot created as [{}]", (Object)path, (Object)snapshotName);
        Response response = Response.ok((Object)json).type("application/json").build();
        return response;
    }

    private Response handleDisallowSnapshot(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSDisallowSnapshot command = new FSOperations.FSDisallowSnapshot(path);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] disallowed snapshot", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleAllowSnapshot(String path, UserGroupInformation user) throws IOException, FileSystemAccessException {
        FSOperations.FSAllowSnapshot command = new FSOperations.FSAllowSnapshot(path);
        this.fsExecute(user, command);
        AUDIT_LOG.info("[{}] allowed snapshot", (Object)path);
        Response response = Response.ok().build();
        return response;
    }

    private Response handleCreate(InputStream is, UriInfo uriInfo, String path, Parameters params, UserGroupInformation user) throws IOException, FileSystemAccessException {
        Response response;
        Boolean hasData = (Boolean)params.get("data", HttpFSParametersProvider.DataParam.class);
        URI redirectURL = this.createUploadRedirectionURL(uriInfo, HttpFSConstants.Operation.CREATE);
        Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
        if (noRedirect.booleanValue()) {
            String js = JsonUtil.toJsonString("Location", (Object)redirectURL);
            response = Response.ok((Object)js).type("application/json").build();
        } else if (hasData.booleanValue()) {
            Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
            Short unmaskedPermission = (Short)params.get("unmaskedpermission", HttpFSParametersProvider.UnmaskedPermissionParam.class);
            Boolean override = (Boolean)params.get("overwrite", HttpFSParametersProvider.OverwriteParam.class);
            Short replication = (Short)params.get("replication", HttpFSParametersProvider.ReplicationParam.class);
            Long blockSize = (Long)params.get("blocksize", HttpFSParametersProvider.BlockSizeParam.class);
            FSOperations.FSCreate command = new FSOperations.FSCreate(is, path, permission, override, replication, blockSize, unmaskedPermission);
            this.fsExecute(user, command);
            AUDIT_LOG.info("[{}] permission [{}] override [{}] replication [{}] blockSize [{}] unmaskedpermission [{}]", new Object[]{path, permission, override, replication, blockSize, unmaskedPermission});
            String js = JsonUtil.toJsonString("Location", (Object)uriInfo.getAbsolutePath());
            response = Response.created((URI)uriInfo.getAbsolutePath()).type("application/json").entity((Object)js).build();
        } else {
            response = Response.temporaryRedirect((URI)redirectURL).build();
        }
        return response;
    }

    static enum AccessMode {
        READWRITE,
        WRITEONLY,
        READONLY;

    }
}

