/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.remote.vault;

import com.bettercloud.vault.SslConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.hadoop.ozone.s3.remote.vault.VaultS3SecretStore;
import org.apache.hadoop.ozone.s3.remote.vault.auth.Auth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultS3SecretStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(VaultS3SecretStoreBuilder.class);
    private String address;
    private String nameSpace;
    private String secretPath;
    private int engineVersion = 1;
    private String keyStoreType;
    private String keyStore;
    private String keyStorePassword;
    private String trustStoreType;
    private String trustStore;
    private String trustStorePassword;
    private Auth auth;

    public VaultS3SecretStoreBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public VaultS3SecretStoreBuilder setEngineVersion(int engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public VaultS3SecretStoreBuilder setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public VaultS3SecretStoreBuilder setKeyStore(String keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public VaultS3SecretStoreBuilder setKeyStorePassword(String ksPassword) {
        this.keyStorePassword = ksPassword;
        return this;
    }

    public VaultS3SecretStoreBuilder setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public VaultS3SecretStoreBuilder setTrustStore(String trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public VaultS3SecretStoreBuilder setTrustStorePassword(String tsPassword) {
        this.trustStorePassword = tsPassword;
        return this;
    }

    public VaultS3SecretStoreBuilder setAuth(Auth auth) {
        this.auth = auth;
        return this;
    }

    public VaultS3SecretStoreBuilder setSecretPath(String secretPath) {
        this.secretPath = secretPath;
        return this;
    }

    public VaultS3SecretStoreBuilder setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public VaultS3SecretStore build() throws IOException {
        SslConfig sslConfig = this.loadKeyStore(null);
        sslConfig = this.loadTrustStore(sslConfig);
        return new VaultS3SecretStore(this.address, this.nameSpace, this.secretPath, this.engineVersion, this.auth, sslConfig);
    }

    private SslConfig loadKeyStore(SslConfig sslConfig) {
        if (sslConfig == null) {
            sslConfig = new SslConfig();
        }
        if (this.keyStoreType != null) {
            try {
                KeyStore store = VaultS3SecretStoreBuilder.loadStore(this.keyStoreType, this.keyStore, this.keyStorePassword);
                return sslConfig.keyStore(store, this.keyStorePassword);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOG.error("Failed to load keystore for S3 remote secret store", (Throwable)e);
            }
        }
        return null;
    }

    private SslConfig loadTrustStore(SslConfig sslConfig) {
        if (sslConfig == null) {
            sslConfig = new SslConfig();
        }
        if (this.trustStoreType != null) {
            try {
                KeyStore store = VaultS3SecretStoreBuilder.loadStore(this.trustStoreType, this.trustStore, this.trustStorePassword);
                return sslConfig.trustStore(store);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOG.error("Failed to load keystore for S3 remote secret store", (Throwable)e);
            }
        }
        return null;
    }

    private static KeyStore loadStore(String storeType, String storePath, String password) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        char[] pass = password == null ? null : password.toCharArray();
        KeyStore ks = KeyStore.getInstance(storeType);
        if (storePath != null) {
            try (InputStream is = Files.newInputStream(Paths.get(storePath, new String[0]), new OpenOption[0]);){
                ks.load(is, pass);
            }
        }
        return ks;
    }
}

