/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.remote.vault;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.LogicalResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.om.S3Batcher;
import org.apache.hadoop.ozone.om.S3SecretStore;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.s3.remote.vault.VaultS3SecretStoreBuilder;
import org.apache.hadoop.ozone.s3.remote.vault.auth.Auth;
import org.apache.hadoop.ozone.s3.remote.vault.auth.AuthType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultS3SecretStore
implements S3SecretStore {
    private static final Logger LOG = LoggerFactory.getLogger(VaultS3SecretStore.class);
    private final VaultConfig config;
    private Vault vault;
    private final String secretPath;
    private final Auth auth;

    public VaultS3SecretStore(String vaultAddress, String nameSpace, String secretPath, int engineVersion, Auth auth, SslConfig sslConfig) throws IOException {
        try {
            this.config = new VaultConfig().address(vaultAddress).engineVersion(Integer.valueOf(engineVersion)).nameSpace(nameSpace).sslConfig(sslConfig).build();
            this.auth = auth;
            this.secretPath = secretPath.endsWith("/") ? secretPath.substring(0, secretPath.length() - 1) : secretPath;
        }
        catch (VaultException e) {
            throw new IOException("Failed to initialize remote secret store", e);
        }
        try {
            this.auth();
        }
        catch (VaultException e) {
            LOG.error("Failed to authenticate with remote secret store", (Throwable)e);
        }
    }

    private void auth() throws VaultException {
        this.vault = this.auth.auth(this.config);
    }

    public void storeSecret(String kerberosId, S3SecretValue secret) throws IOException {
        try {
            this.callWithReAuth(() -> this.vault.logical().write(this.secretPath + '/' + kerberosId, Collections.singletonMap(kerberosId, secret.getAwsSecret())));
        }
        catch (VaultException e) {
            LOG.error("Failed to store secret", (Throwable)e);
            throw new IOException("Failed to store secret", e);
        }
    }

    public S3SecretValue getSecret(String kerberosID) throws IOException {
        try {
            Map data = this.callWithReAuth(() -> this.vault.logical().read(this.secretPath + '/' + kerberosID)).getData();
            if (data == null) {
                return null;
            }
            String s3Secret = (String)data.get(kerberosID);
            if (s3Secret == null) {
                return null;
            }
            return S3SecretValue.of((String)kerberosID, (String)s3Secret);
        }
        catch (VaultException e) {
            LOG.error("Failed to read secret", (Throwable)e);
            throw new IOException("Failed to read secret", e);
        }
    }

    public void revokeSecret(String kerberosId) throws IOException {
        try {
            this.callWithReAuth(() -> this.vault.logical().delete(this.secretPath + '/' + kerberosId));
        }
        catch (VaultException e) {
            LOG.error("Failed to delete secret", (Throwable)e);
            throw new IOException("Failed to revoke secret", e);
        }
    }

    private LogicalResponse callWithReAuth(RestCall action) throws VaultException {
        LogicalResponse response = action.call();
        int status = response.getRestResponse().getStatus();
        if (VaultS3SecretStore.isAuthFailed(status)) {
            this.auth();
            response = action.call();
            status = response.getRestResponse().getStatus();
            if (VaultS3SecretStore.isAuthFailed(status)) {
                throw new VaultException("Failed to re-authenticate", status);
            }
        }
        return response;
    }

    private static boolean isAuthFailed(int status) {
        return status == 403 || status == 401 || status == 400;
    }

    public S3Batcher batcher() {
        return null;
    }

    public static VaultS3SecretStore fromConf(Configuration conf) throws IOException {
        String keyStoreType;
        VaultS3SecretStoreBuilder builder = VaultS3SecretStore.builder().setAuth(AuthType.fromConf(conf)).setAddress(conf.get("ozone.secret.s3.store.remote.vault.address")).setNameSpace(conf.get("ozone.secret.s3.store.remote.vault.namespace")).setSecretPath(conf.get("ozone.secret.s3.store.remote.vault.secretpath")).setEngineVersion(conf.getInt("ozone.secret.s3.store.remote.vault.enginever", 1));
        String trustStoreType = conf.get("ozone.secret.s3.store.remote.vault.trust.store.type");
        if (trustStoreType != null) {
            builder.setTrustStoreType(trustStoreType).setTrustStore(conf.get("ozone.secret.s3.store.remote.vault.trust.store.path")).setTrustStorePassword(conf.get("ozone.secret.s3.store.remote.vault.trust.store.password"));
        }
        if ((keyStoreType = conf.get("ozone.secret.s3.store.remote.vault.key.store.type")) != null) {
            builder.setKeyStoreType(keyStoreType).setKeyStore(conf.get("ozone.secret.s3.store.remote.vault.key.store.path")).setKeyStorePassword(conf.get("ozone.secret.s3.store.remote.vault.key.store.password"));
        }
        return builder.build();
    }

    public static VaultS3SecretStoreBuilder builder() {
        return new VaultS3SecretStoreBuilder();
    }

    private static interface RestCall {
        public LogicalResponse call() throws VaultException;
    }
}

