/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPool {
    public static final Logger LOG = LoggerFactory.getLogger(BufferPool.class);
    private static final BufferPool EMPTY = new BufferPool(0, 0);
    private final int bufferSize;
    private final int capacity;
    private final Function<ByteBuffer, ByteString> byteStringConversion;
    private final LinkedList<ChunkBuffer> allocated = new LinkedList();
    private final LinkedList<ChunkBuffer> released = new LinkedList();
    private ChunkBuffer currentBuffer = null;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();

    public static BufferPool empty() {
        return EMPTY;
    }

    public BufferPool(int bufferSize, int capacity) {
        this(bufferSize, capacity, ByteStringConversion.createByteBufferConversion((boolean)false));
    }

    public BufferPool(int bufferSize, int capacity, Function<ByteBuffer, ByteString> byteStringConversion) {
        this.capacity = capacity;
        this.bufferSize = bufferSize;
        this.byteStringConversion = byteStringConversion;
    }

    public Function<ByteBuffer, ByteString> byteStringConversion() {
        return this.byteStringConversion;
    }

    ChunkBuffer getCurrentBuffer() {
        return this.doInLock(() -> this.currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkBuffer allocateBuffer(int increment) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Preconditions.assertTrue((this.allocated.size() + this.released.size() <= this.capacity ? 1 : 0) != 0, () -> "Total created buffer must not exceed capacity.");
            while (this.allocated.size() == this.capacity) {
                LOG.debug("Allocation needs to wait the pool is at capacity (allocated = capacity = {}).", (Object)this.capacity);
                this.notFull.await();
            }
            ChunkBuffer buffer = this.released.isEmpty() ? ChunkBuffer.allocate((int)this.bufferSize, (int)increment) : this.released.removeFirst();
            this.allocated.add(buffer);
            this.currentBuffer = buffer;
            LOG.debug("Allocated new buffer {}, number of used buffers {}, capacity {}.", new Object[]{buffer, this.allocated.size(), this.capacity});
            ChunkBuffer chunkBuffer = buffer;
            return chunkBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    void releaseBuffer(ChunkBuffer buffer) {
        LOG.debug("Releasing buffer {}", (Object)buffer);
        this.lock.lock();
        try {
            Preconditions.assertTrue((boolean)BufferPool.removeByIdentity(this.allocated, buffer), (Object)"Releasing unknown buffer");
            buffer.clear();
            this.released.add(buffer);
            if (buffer == this.currentBuffer) {
                this.currentBuffer = null;
            }
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static <T> boolean removeByIdentity(List<T> list, T toRemove) {
        int i = 0;
        for (T item : list) {
            if (item == toRemove) break;
            ++i;
        }
        if (i < list.size()) {
            list.remove(i);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public void waitUntilAvailable() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.allocated.size() == this.capacity) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearBufferPool() {
        this.lock.lock();
        try {
            this.allocated.forEach(ChunkBuffer::close);
            this.released.forEach(ChunkBuffer::close);
            this.allocated.clear();
            this.released.clear();
            this.currentBuffer = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long computeBufferData() {
        return this.doInLock(() -> {
            long totalBufferSize = 0L;
            for (ChunkBuffer buf : this.allocated) {
                totalBufferSize += (long)buf.position();
            }
            return totalBufferSize;
        });
    }

    public int getSize() {
        return this.doInLock(() -> this.allocated.size() + this.released.size());
    }

    public List<ChunkBuffer> getAllocatedBuffers() {
        return this.doInLock(() -> new ArrayList<ChunkBuffer>(this.allocated));
    }

    public int getNumberOfUsedBuffers() {
        return this.doInLock(this.allocated::size);
    }

    private <T> T doInLock(Supplier<T> supplier) {
        this.lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isAtCapacity() {
        return this.getNumberOfUsedBuffers() == this.capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

