/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.compaction.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.rocksdb.LiveFileMetaData;

public final class CompactionFileInfo {
    private final String fileName;
    private final String startKey;
    private final String endKey;
    private final String columnFamily;

    @VisibleForTesting
    public CompactionFileInfo(String fileName, String startRange, String endRange, String columnFamily) {
        this.fileName = fileName;
        this.startKey = startRange;
        this.endKey = endRange;
        this.columnFamily = columnFamily;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public HddsProtos.CompactionFileInfoProto getProtobuf() {
        HddsProtos.CompactionFileInfoProto.Builder builder = HddsProtos.CompactionFileInfoProto.newBuilder().setFileName(this.fileName);
        if (this.startKey != null) {
            builder = builder.setStartKey(this.startKey);
        }
        if (this.endKey != null) {
            builder = builder.setEndKey(this.endKey);
        }
        if (this.columnFamily != null) {
            builder = builder.setColumnFamily(this.columnFamily);
        }
        return builder.build();
    }

    public static CompactionFileInfo getFromProtobuf(HddsProtos.CompactionFileInfoProto proto) {
        Builder builder = new Builder(proto.getFileName());
        if (proto.hasStartKey()) {
            builder.setStartRange(proto.getStartKey());
        }
        if (proto.hasEndKey()) {
            builder.setEndRange(proto.getEndKey());
        }
        if (proto.hasColumnFamily()) {
            builder.setColumnFamily(proto.getColumnFamily());
        }
        return builder.build();
    }

    public String toString() {
        return String.format("fileName: '%s', startKey: '%s', endKey: '%s', columnFamily: '%s'", this.fileName, this.startKey, this.endKey, this.columnFamily);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompactionFileInfo)) {
            return false;
        }
        CompactionFileInfo that = (CompactionFileInfo)o;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.startKey, that.startKey) && Objects.equals(this.endKey, that.endKey) && Objects.equals(this.columnFamily, that.columnFamily);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.startKey, this.endKey, this.columnFamily);
    }

    public static class Builder {
        private final String fileName;
        private String startRange;
        private String endRange;
        private String columnFamily;

        public Builder(String fileName) {
            Preconditions.checkNotNull((Object)fileName, (Object)"FileName is required parameter.");
            this.fileName = fileName;
        }

        public Builder setStartRange(String startRange) {
            this.startRange = startRange;
            return this;
        }

        public Builder setEndRange(String endRange) {
            this.endRange = endRange;
            return this;
        }

        public Builder setColumnFamily(String columnFamily) {
            this.columnFamily = columnFamily;
            return this;
        }

        public Builder setValues(LiveFileMetaData fileMetaData) {
            if (fileMetaData != null) {
                String columnFamilyName = StringUtils.bytes2String((byte[])fileMetaData.columnFamilyName());
                String startRangeValue = StringUtils.bytes2String((byte[])fileMetaData.smallestKey());
                String endRangeValue = StringUtils.bytes2String((byte[])fileMetaData.largestKey());
                this.setColumnFamily(columnFamilyName).setStartRange(startRangeValue).setEndRange(endRangeValue);
            }
            return this;
        }

        public CompactionFileInfo build() {
            if (!(this.startRange == null && this.endRange == null && this.columnFamily == null || this.startRange != null && this.endRange != null && this.columnFamily != null)) {
                throw new IllegalArgumentException(String.format("Either all of startRange, endRange and columnFamily should be non-null or null. startRange: '%s', endRange: '%s', columnFamily: '%s'.", this.startRange, this.endRange, this.columnFamily));
            }
            return new CompactionFileInfo(this.fileName, this.startRange, this.endRange, this.columnFamily);
        }
    }
}

