/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="fso-tree", description={"Identify and repair a disconnected FSO tree by marking unreferenced entries for deletion. OM should be stopped while this tool is run."})
public class FSORepairTool
extends RepairTool {
    public static final Logger LOG = LoggerFactory.getLogger(FSORepairTool.class);
    private static final String REACHABLE_TABLE = "reachable";
    @CommandLine.Option(names={"--db"}, required=true, description={"Path to OM RocksDB"})
    private String omDBPath;
    @CommandLine.Option(names={"-v", "--volume"}, description={"Filter by volume name. Add '/' before the volume name."})
    private String volumeFilter;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Filter by bucket name"})
    private String bucketFilter;
    @CommandLine.Option(names={"--verbose"}, description={"Verbose output. Show all intermediate steps."})
    private boolean verbose;

    @Override
    @Nonnull
    protected RepairTool.Component serviceToBeOffline() {
        return RepairTool.Component.OM;
    }

    @Override
    public void execute() throws Exception {
        try {
            Impl repairTool = new Impl();
            repairTool.run();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("FSO repair failed: " + ex.getMessage());
        }
        if (this.verbose) {
            this.info("FSO repair finished.", new Object[0]);
        }
    }

    protected static DBStore getStoreFromPath(String dbPath) throws IOException {
        File omDBFile = new File(dbPath);
        if (!omDBFile.exists() || !omDBFile.isDirectory()) {
            throw new IOException(String.format("Specified OM DB instance %s does not exist or is not a RocksDB directory.", dbPath));
        }
        return OmMetadataManagerImpl.loadDB((OzoneConfiguration)new OzoneConfiguration(), (File)new File(dbPath).getParentFile(), (int)-1);
    }

    private static String buildReachableKey(OmVolumeArgs volume, OmBucketInfo bucket, WithObjectID object) {
        return "/" + volume.getObjectID() + "/" + bucket.getObjectID() + "/" + object.getObjectID();
    }

    private static String buildReachableParentKey(String fileOrDirKey) {
        String[] keyParts = fileOrDirKey.split("/");
        Preconditions.assertTrue((keyParts.length >= 4 ? 1 : 0) != 0);
        String volumeID = keyParts[1];
        String bucketID = keyParts[2];
        String parentID = keyParts[3];
        return "/" + volumeID + "/" + bucketID + "/" + parentID;
    }

    public static class ReportStatistics {
        private long dirs;
        private long files;
        private long bytes;

        public ReportStatistics() {
        }

        public ReportStatistics(long dirs, long files, long bytes) {
            this.dirs = dirs;
            this.files = files;
            this.bytes = bytes;
        }

        public void add(ReportStatistics other) {
            this.dirs += other.dirs;
            this.files += other.files;
            this.bytes += other.bytes;
        }

        public long getDirs() {
            return this.dirs;
        }

        public long getFiles() {
            return this.files;
        }

        public long getBytes() {
            return this.bytes;
        }

        public String toString() {
            return "\n\tDirectories: " + this.dirs + "\n\tFiles: " + this.files + "\n\tBytes: " + this.bytes;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ReportStatistics stats = (ReportStatistics)other;
            return this.bytes == stats.bytes && this.files == stats.files && this.dirs == stats.dirs;
        }

        public int hashCode() {
            return Objects.hash(this.bytes, this.files, this.dirs);
        }

        public void addDir() {
            ++this.dirs;
        }

        public void addFile(long size) {
            ++this.files;
            this.bytes += size;
        }
    }

    public static class Report {
        private final ReportStatistics reachable;
        private final ReportStatistics unreachable;
        private final ReportStatistics unreferenced;

        public Report(Report ... reports) {
            this.reachable = new ReportStatistics();
            this.unreachable = new ReportStatistics();
            this.unreferenced = new ReportStatistics();
            for (Report report : reports) {
                this.reachable.add(report.reachable);
                this.unreachable.add(report.unreachable);
                this.unreferenced.add(report.unreferenced);
            }
        }

        private Report(Builder builder) {
            this.reachable = builder.reachable;
            this.unreachable = builder.unreachable;
            this.unreferenced = builder.unreferenced;
        }

        public ReportStatistics getReachable() {
            return this.reachable;
        }

        public ReportStatistics getUnreachable() {
            return this.unreachable;
        }

        public ReportStatistics getUnreferenced() {
            return this.unreferenced;
        }

        public String toString() {
            return "Reachable:" + this.reachable + "\nUnreachable:" + this.unreachable + "\nUnreferenced:" + this.unreferenced;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Report report = (Report)other;
            System.out.println("Comparing reports\nExpect:\n" + this + "\nActual:\n" + report);
            return this.reachable.equals(report.reachable) && this.unreachable.equals(report.unreachable) && this.unreferenced.equals(report.unreferenced);
        }

        public int hashCode() {
            return Objects.hash(this.reachable, this.unreachable, this.unreferenced);
        }

        public static final class Builder {
            private ReportStatistics reachable = new ReportStatistics();
            private ReportStatistics unreachable = new ReportStatistics();
            private ReportStatistics unreferenced = new ReportStatistics();

            public Builder setReachable(ReportStatistics reachable) {
                this.reachable = reachable;
                return this;
            }

            public Builder setUnreachable(ReportStatistics unreachable) {
                this.unreachable = unreachable;
                return this;
            }

            public Builder setUnreferenced(ReportStatistics unreferenced) {
                this.unreferenced = unreferenced;
                return this;
            }

            public Report build() {
                return new Report(this);
            }
        }
    }

    private class Impl {
        private final DBStore store;
        private final Table<String, OmVolumeArgs> volumeTable;
        private final Table<String, OmBucketInfo> bucketTable;
        private final Table<String, OmDirectoryInfo> directoryTable;
        private final Table<String, OmKeyInfo> fileTable;
        private final Table<String, OmKeyInfo> deletedDirectoryTable;
        private final Table<String, RepeatedOmKeyInfo> deletedTable;
        private final Table<String, SnapshotInfo> snapshotInfoTable;
        private DBStore reachableDB;
        private final ReportStatistics reachableStats = new ReportStatistics(0L, 0L, 0L);
        private final ReportStatistics unreachableStats = new ReportStatistics(0L, 0L, 0L);
        private final ReportStatistics unreferencedStats = new ReportStatistics(0L, 0L, 0L);

        Impl() throws IOException {
            this.store = FSORepairTool.getStoreFromPath(FSORepairTool.this.omDBPath);
            this.volumeTable = this.store.getTable("volumeTable", String.class, OmVolumeArgs.class);
            this.bucketTable = this.store.getTable("bucketTable", String.class, OmBucketInfo.class);
            this.directoryTable = this.store.getTable("directoryTable", String.class, OmDirectoryInfo.class);
            this.fileTable = this.store.getTable("fileTable", String.class, OmKeyInfo.class);
            this.deletedDirectoryTable = this.store.getTable("deletedDirectoryTable", String.class, OmKeyInfo.class);
            this.deletedTable = this.store.getTable("deletedTable", String.class, RepeatedOmKeyInfo.class);
            this.snapshotInfoTable = this.store.getTable("snapshotInfoTable", String.class, SnapshotInfo.class);
        }

        public Report run() throws Exception {
            try {
                OmVolumeArgs volumeArgs;
                if (FSORepairTool.this.bucketFilter != null && FSORepairTool.this.volumeFilter == null) {
                    FSORepairTool.this.error("--bucket flag cannot be used without specifying --volume.", new Object[0]);
                    Report report = null;
                    return report;
                }
                if (FSORepairTool.this.volumeFilter != null && (volumeArgs = (OmVolumeArgs)this.volumeTable.getIfExist((Object)FSORepairTool.this.volumeFilter)) == null) {
                    FSORepairTool.this.error("Volume '" + FSORepairTool.this.volumeFilter + "' does not exist.", new Object[0]);
                    Report report = null;
                    return report;
                }
                try (TableIterator volumeIterator = this.volumeTable.iterator();){
                    try {
                        this.openReachableDB();
                    }
                    catch (IOException e) {
                        FSORepairTool.this.error("Failed to open reachable database: " + e.getMessage(), new Object[0]);
                        throw e;
                    }
                    block31: while (true) {
                        if (volumeIterator.hasNext()) {
                            Throwable throwable;
                            Table.KeyValue volumeEntry = (Table.KeyValue)volumeIterator.next();
                            String volumeKey = (String)volumeEntry.getKey();
                            if (FSORepairTool.this.volumeFilter != null && !FSORepairTool.this.volumeFilter.equals(volumeKey)) continue;
                            FSORepairTool.this.info("Processing volume: " + volumeKey, new Object[0]);
                            if (FSORepairTool.this.bucketFilter != null) {
                                OmBucketInfo bucketInfo = (OmBucketInfo)this.bucketTable.getIfExist((Object)(volumeKey + "/" + FSORepairTool.this.bucketFilter));
                                if (bucketInfo == null) {
                                    FSORepairTool.this.error("Bucket '" + FSORepairTool.this.bucketFilter + "' does not exist in volume '" + volumeKey + "'.", new Object[0]);
                                    throwable = null;
                                    return throwable;
                                }
                                if (bucketInfo.getBucketLayout() != BucketLayout.FILE_SYSTEM_OPTIMIZED) {
                                    FSORepairTool.this.info("Skipping non-FSO bucket " + FSORepairTool.this.bucketFilter, new Object[0]);
                                    continue;
                                }
                                this.processBucket((OmVolumeArgs)volumeEntry.getValue(), bucketInfo);
                                continue;
                            }
                            TableIterator bucketIterator = this.bucketTable.iterator();
                            throwable = null;
                            try {
                                bucketIterator.seek((Object)volumeKey);
                                while (true) {
                                    if (!bucketIterator.hasNext()) continue block31;
                                    Table.KeyValue bucketEntry = (Table.KeyValue)bucketIterator.next();
                                    String bucketKey = (String)bucketEntry.getKey();
                                    OmBucketInfo bucketInfo = (OmBucketInfo)bucketEntry.getValue();
                                    if (bucketInfo.getBucketLayout() != BucketLayout.FILE_SYSTEM_OPTIMIZED) {
                                        FSORepairTool.this.info("Skipping non-FSO bucket " + bucketKey, new Object[0]);
                                        continue;
                                    }
                                    if (!bucketKey.startsWith(volumeKey)) continue block31;
                                    this.processBucket((OmVolumeArgs)volumeEntry.getValue(), bucketInfo);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (bucketIterator == null) continue;
                                if (throwable != null) {
                                    try {
                                        bucketIterator.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                bucketIterator.close();
                                continue;
                            }
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                FSORepairTool.this.error("An error occurred while processing" + e.getMessage(), new Object[0]);
                throw e;
            }
            finally {
                this.closeReachableDB();
                this.store.close();
            }
            return this.buildReportAndLog();
        }

        private boolean checkIfSnapshotExistsForBucket(String volumeName, String bucketName) throws IOException {
            if (this.snapshotInfoTable == null) {
                return false;
            }
            try (TableIterator iterator = this.snapshotInfoTable.iterator();){
                while (iterator.hasNext()) {
                    SnapshotInfo snapshotInfo = (SnapshotInfo)((Table.KeyValue)iterator.next()).getValue();
                    String snapshotPath = (volumeName + "/" + bucketName).replaceFirst("^/", "");
                    if (!snapshotInfo.getSnapshotPath().equals(snapshotPath)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        private void processBucket(OmVolumeArgs volume, OmBucketInfo bucketInfo) throws IOException {
            if (this.checkIfSnapshotExistsForBucket(volume.getVolume(), bucketInfo.getBucketName())) {
                FSORepairTool.this.info("Skipping repair for bucket '" + volume.getVolume() + "/" + bucketInfo.getBucketName() + "' due to snapshot presence.", new Object[0]);
                return;
            }
            FSORepairTool.this.info("Processing bucket: " + volume.getVolume() + "/" + bucketInfo.getBucketName(), new Object[0]);
            this.markReachableObjectsInBucket(volume, bucketInfo);
            this.handleUnreachableAndUnreferencedObjects(volume, bucketInfo);
        }

        private Report buildReportAndLog() {
            Report report = new Report.Builder().setReachable(this.reachableStats).setUnreachable(this.unreachableStats).setUnreferenced(this.unreferencedStats).build();
            FSORepairTool.this.info("\n" + report, new Object[0]);
            return report;
        }

        private void markReachableObjectsInBucket(OmVolumeArgs volume, OmBucketInfo bucket) throws IOException {
            Stack<String> dirKeyStack = new Stack<String>();
            this.addReachableEntry(volume, bucket, (WithObjectID)bucket);
            Collection<String> childDirs = this.getChildDirectoriesAndMarkAsReachable(volume, bucket, (WithObjectID)bucket);
            dirKeyStack.addAll(childDirs);
            while (!dirKeyStack.isEmpty()) {
                String currentDirKey = (String)dirKeyStack.pop();
                OmDirectoryInfo currentDir = (OmDirectoryInfo)this.directoryTable.get((Object)currentDirKey);
                if (currentDir == null) {
                    FSORepairTool.this.info("Directory key" + currentDirKey + "to be processed was not found in the directory table.", new Object[0]);
                    continue;
                }
                childDirs = this.getChildDirectoriesAndMarkAsReachable(volume, bucket, (WithObjectID)currentDir);
                dirKeyStack.addAll(childDirs);
            }
        }

        private boolean isDirectoryInDeletedDirTable(String dirKey) throws IOException {
            return this.deletedDirectoryTable.isExist((Object)dirKey);
        }

        private boolean isFileKeyInDeletedTable(String fileKey) throws IOException {
            return this.deletedTable.isExist((Object)fileKey);
        }

        private void handleUnreachableAndUnreferencedObjects(OmVolumeArgs volume, OmBucketInfo bucket) throws IOException {
            String bucketPrefix = "/" + volume.getObjectID() + "/" + bucket.getObjectID();
            try (TableIterator dirIterator = this.directoryTable.iterator();){
                dirIterator.seek((Object)bucketPrefix);
                while (dirIterator.hasNext()) {
                    Table.KeyValue dirEntry = (Table.KeyValue)dirIterator.next();
                    String dirKey = (String)dirEntry.getKey();
                    if (!dirKey.startsWith(bucketPrefix)) {
                        break;
                    }
                    if (this.isReachable(dirKey)) continue;
                    if (!this.isDirectoryInDeletedDirTable(dirKey)) {
                        this.unreferencedStats.addDir();
                        FSORepairTool.this.info("Deleting unreferenced directory " + dirKey, new Object[0]);
                        if (FSORepairTool.this.isDryRun()) continue;
                        OmDirectoryInfo dirInfo = (OmDirectoryInfo)dirEntry.getValue();
                        this.markDirectoryForDeletion(volume.getVolume(), bucket.getBucketName(), dirKey, dirInfo);
                        continue;
                    }
                    this.unreachableStats.addDir();
                }
            }
            var5_5 = null;
            try (TableIterator fileIterator = this.fileTable.iterator();){
                fileIterator.seek((Object)bucketPrefix);
                while (fileIterator.hasNext()) {
                    Table.KeyValue fileEntry = (Table.KeyValue)fileIterator.next();
                    String fileKey = (String)fileEntry.getKey();
                    if (!fileKey.startsWith(bucketPrefix)) {
                        break;
                    }
                    OmKeyInfo fileInfo = (OmKeyInfo)fileEntry.getValue();
                    if (!this.isReachable(fileKey)) {
                        if (!this.isFileKeyInDeletedTable(fileKey)) {
                            this.unreferencedStats.addFile(fileInfo.getDataSize());
                            FSORepairTool.this.info("Deleting unreferenced file " + fileKey, new Object[0]);
                            if (FSORepairTool.this.isDryRun()) continue;
                            this.markFileForDeletion(fileKey, fileInfo);
                            continue;
                        }
                        this.unreachableStats.addFile(fileInfo.getDataSize());
                        continue;
                    }
                    this.reachableStats.addFile(fileInfo.getDataSize());
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }

        protected void markFileForDeletion(String fileKey, OmKeyInfo fileInfo) throws IOException {
            try (BatchOperation batch = this.store.initBatchOperation();){
                this.fileTable.deleteWithBatch(batch, (Object)fileKey);
                RepeatedOmKeyInfo originalRepeatedKeyInfo = (RepeatedOmKeyInfo)this.deletedTable.get((Object)fileKey);
                RepeatedOmKeyInfo updatedRepeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)fileInfo, (long)fileInfo.getUpdateID());
                this.deletedTable.putWithBatch(batch, (Object)fileKey, (Object)updatedRepeatedOmKeyInfo);
                if (FSORepairTool.this.verbose) {
                    FSORepairTool.this.info("Added entry " + fileKey + " to open key table: " + updatedRepeatedOmKeyInfo, new Object[0]);
                }
                this.store.commitBatchOperation(batch);
            }
        }

        protected void markDirectoryForDeletion(String volumeName, String bucketName, String dirKeyName, OmDirectoryInfo dirInfo) throws IOException {
            try (BatchOperation batch = this.store.initBatchOperation();){
                this.directoryTable.deleteWithBatch(batch, (Object)dirKeyName);
                String deleteDirKeyName = dirKeyName + "/" + dirInfo.getObjectID();
                OmKeyInfo dirAsKeyInfo = OMFileRequest.getOmKeyInfo((String)volumeName, (String)bucketName, (OmDirectoryInfo)dirInfo, (String)dirInfo.getName());
                this.deletedDirectoryTable.putWithBatch(batch, (Object)deleteDirKeyName, (Object)dirAsKeyInfo);
                this.store.commitBatchOperation(batch);
            }
        }

        private Collection<String> getChildDirectoriesAndMarkAsReachable(OmVolumeArgs volume, OmBucketInfo bucket, WithObjectID currentDir) throws IOException {
            ArrayList<String> childDirs = new ArrayList<String>();
            try (TableIterator dirIterator = this.directoryTable.iterator();){
                String dirPrefix = FSORepairTool.buildReachableKey(volume, bucket, currentDir);
                dirIterator.seek((Object)dirPrefix);
                while (dirIterator.hasNext()) {
                    Table.KeyValue childDirEntry = (Table.KeyValue)dirIterator.next();
                    String childDirKey = (String)childDirEntry.getKey();
                    if (!childDirKey.startsWith(dirPrefix)) {
                        break;
                    }
                    this.addReachableEntry(volume, bucket, (WithObjectID)childDirEntry.getValue());
                    childDirs.add(childDirKey);
                    this.reachableStats.addDir();
                }
            }
            return childDirs;
        }

        private void addReachableEntry(OmVolumeArgs volume, OmBucketInfo bucket, WithObjectID object) throws IOException {
            String reachableKey = FSORepairTool.buildReachableKey(volume, bucket, object);
            this.reachableDB.getTable(FSORepairTool.REACHABLE_TABLE, String.class, byte[].class).put((Object)reachableKey, (Object)new byte[0]);
        }

        protected boolean isReachable(String fileOrDirKey) throws IOException {
            String reachableParentKey = FSORepairTool.buildReachableParentKey(fileOrDirKey);
            return this.reachableDB.getTable(FSORepairTool.REACHABLE_TABLE, String.class, byte[].class).get((Object)reachableParentKey) != null;
        }

        private void openReachableDB() throws IOException {
            File reachableDBFile = new File(new File(FSORepairTool.this.omDBPath).getParentFile(), "reachable.db");
            FSORepairTool.this.info("Creating database of reachable directories at " + reachableDBFile, new Object[0]);
            if (reachableDBFile.exists()) {
                FileUtils.deleteDirectory((File)reachableDBFile);
            }
            OzoneConfiguration conf = new OzoneConfiguration();
            this.reachableDB = DBStoreBuilder.newBuilder((ConfigurationSource)conf).setName("reachable.db").setPath(reachableDBFile.getParentFile().toPath()).addTable(FSORepairTool.REACHABLE_TABLE).build();
        }

        private void closeReachableDB() throws IOException {
            File reachableDBFile;
            if (this.reachableDB != null) {
                this.reachableDB.close();
            }
            if ((reachableDBFile = new File(new File(FSORepairTool.this.omDBPath).getParentFile(), "reachable.db")).exists()) {
                FileUtils.deleteDirectory((File)reachableDBFile);
            }
        }
    }
}

