/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon.containergenerator;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.DatanodeVersionFile;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.impl.BlockManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerFactory;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.ozone.freon.containergenerator.BaseGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="cgdn", description={"Offline container metadata generator for Ozone Datanodes."}, optionListHeading="\nExecute this command with different parameters for each datanodes. For example if you have 10 datanodes, use 'ozone freon cgdn --index=1 --datanodes=10', 'ozone freon cgdn --index=2 --datanodes=10', 'ozone freon cgdn --index=3 --datanodes=10', ...\n\n", versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class GeneratorDatanode
extends BaseGenerator {
    @CommandLine.Option(names={"--datanodes"}, description={"Number of datanodes (to generate only a subset of the required containers)."}, defaultValue="3")
    private int datanodes;
    @CommandLine.Option(names={"--index"}, description={"Index of the datanode. For example datanode #3 should have only every 3rd container in a 10 node cluster. First datanode is 1 not 0.)."}, defaultValue="1")
    private int datanodeIndex;
    @CommandLine.Option(names={"--zero"}, description={"Use zero bytes instead of random data."}, defaultValue="false")
    private boolean zero;
    @CommandLine.Option(names={"--overlap"}, description={"Number of overlapping pipelines between 1 and 3. This number provides a lightweight simulation of multi-raft placement. Set to 3 to have more sources ((overlap + 1) % 3 = 4) for replication in case of node failures."}, defaultValue="1")
    private int overlap;
    private ChunkManager chunkManager;
    private BlockManagerImpl blockManager;
    private RoundRobinVolumeChoosingPolicy volumeChoosingPolicy;
    private MutableVolumeSet volumeSet;
    private Checksum checksum;
    private ConfigurationSource config;
    private Timer timer;
    private int logCounter;
    private String datanodeId;
    private String scmId;

    @Override
    public Void call() throws Exception {
        this.init();
        this.config = this.createOzoneConfiguration();
        this.blockManager = new BlockManagerImpl(this.config);
        this.chunkManager = ChunkManagerFactory.createChunkManager((ConfigurationSource)this.config, (BlockManager)this.blockManager, null);
        Collection storageDirs = HddsServerUtil.getDatanodeStorageDirs((ConfigurationSource)this.config);
        String firstStorageDir = StorageLocation.parse((String)((String)storageDirs.iterator().next())).getUri().getPath();
        Path hddsDir = Paths.get(firstStorageDir, "hdds");
        if (!Files.exists(hddsDir, new LinkOption[0])) {
            throw new NoSuchFileException(hddsDir + " doesn't exist. Please start a real cluster to initialize the VERSION descriptors, and re-start this generator after the files are created (but after cluster is stopped).");
        }
        this.scmId = this.getScmIdFromStoragePath(hddsDir);
        File versionFile = new File(firstStorageDir, "hdds/VERSION");
        Properties props = DatanodeVersionFile.readFrom((File)versionFile);
        if (props.isEmpty()) {
            throw new InconsistentStorageStateException("Version file " + versionFile + " is missing");
        }
        String clusterId = StorageVolumeUtil.getProperty((Properties)props, (String)"clusterID", (File)versionFile);
        this.datanodeId = StorageVolumeUtil.getProperty((Properties)props, (String)"datanodeUuid", (File)versionFile);
        this.volumeSet = new MutableVolumeSet(this.datanodeId, clusterId, this.config, null, StorageVolume.VolumeType.DATA_VOLUME, null);
        this.volumeChoosingPolicy = new RoundRobinVolumeChoosingPolicy();
        OzoneClientConfig ozoneClientConfig = (OzoneClientConfig)this.config.getObject(OzoneClientConfig.class);
        this.checksum = new Checksum(ozoneClientConfig.getChecksumType(), ozoneClientConfig.getBytesPerChecksum());
        this.timer = this.getMetrics().timer("datanode-generator");
        this.runTests(this::generateData);
        return null;
    }

    private String getScmIdFromStoragePath(Path hddsDir) throws IOException {
        try (Stream<Path> stream = Files.list(hddsDir);){
            Optional<Path> scmSpecificDir = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst();
            if (!scmSpecificDir.isPresent()) {
                throw new NoSuchFileException("SCM specific datanode directory doesn't exist " + hddsDir);
            }
            Path scmDirName = scmSpecificDir.get().getFileName();
            if (scmDirName == null) {
                throw new IllegalArgumentException("SCM specific datanode directory doesn't exist");
            }
            String string = scmDirName.toString();
            return string;
        }
    }

    @VisibleForTesting
    public static Set<Integer> getPlacement(long containerId, int maxDatanodes, int overlap) {
        int parallelPipelines = maxDatanodes / 3;
        int startOffset = (int)(containerId % (long)parallelPipelines * 3L);
        int pipelineLevel = (int)(containerId / (long)parallelPipelines);
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = startOffset += pipelineLevel % overlap; i < startOffset + 3; ++i) {
            result.add(i % maxDatanodes + 1);
        }
        return result;
    }

    public void generateData(long index) throws Exception {
        this.timer.time(() -> {
            long containerId = index;
            Set<Integer> selectedDatanodes = GeneratorDatanode.getPlacement(containerId, this.datanodes, this.overlap);
            if (!selectedDatanodes.contains(this.datanodeIndex)) {
                return null;
            }
            SplittableRandom random = new SplittableRandom(containerId);
            int keyPerContainer = this.getKeysPerContainer(this.config);
            KeyValueContainer container = this.createContainer(containerId);
            int chunkSize = 0x400000;
            for (long localId = 0L; localId < (long)keyPerContainer; ++localId) {
                int currentChunkSize;
                BlockID blockId = new BlockID(containerId, localId);
                BlockData blockData = new BlockData(blockId);
                int chunkIndex = 0;
                for (int writtenBytes = 0; writtenBytes < this.getKeySize(); writtenBytes += currentChunkSize) {
                    currentChunkSize = Math.min(this.getKeySize() - writtenBytes, chunkSize);
                    String chunkName = "chunk" + chunkIndex++;
                    byte[] data = new byte[currentChunkSize];
                    if (!this.zero) {
                        this.generatedRandomData(random, data);
                    }
                    ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                    ContainerProtos.ChecksumData checksumData = this.checksum.computeChecksum(byteBuffer).getProtoBufMessage();
                    ChunkInfo chunkInfo = new ChunkInfo(chunkName, (long)writtenBytes, (long)currentChunkSize);
                    this.writeChunk(container, blockId, chunkInfo, byteBuffer);
                    blockData.addChunk(ContainerProtos.ChunkInfo.newBuilder().setChunkName(chunkInfo.getChunkName()).setLen(chunkInfo.getLen()).setOffset(chunkInfo.getOffset()).setChecksumData(checksumData).build());
                }
                this.blockManager.persistPutBlock(container, blockData, true);
            }
            container.close();
            return null;
        });
    }

    private void generatedRandomData(SplittableRandom random, byte[] data) {
        int bit = 0;
        int writtenBytes = 0;
        long currentNumber = 0L;
        while (writtenBytes < data.length) {
            if (bit == 0) {
                currentNumber = random.nextLong();
                bit = 3;
            } else {
                --bit;
            }
            data[writtenBytes++] = (byte)currentNumber;
            currentNumber >>= 8;
        }
    }

    private KeyValueContainer createContainer(long containerId) throws IOException {
        ContainerLayoutVersion layoutVersion = ContainerLayoutVersion.getConfiguredVersion((ConfigurationSource)this.config);
        KeyValueContainerData keyValueContainerData = new KeyValueContainerData(containerId, layoutVersion, this.getContainerSize(this.config), this.getPrefix(), this.datanodeId);
        KeyValueContainer keyValueContainer = new KeyValueContainer(keyValueContainerData, this.config);
        try {
            keyValueContainer.create((VolumeSet)this.volumeSet, (VolumeChoosingPolicy)this.volumeChoosingPolicy, this.scmId);
        }
        catch (StorageContainerException ex) {
            throw new RuntimeException(ex);
        }
        return keyValueContainer;
    }

    private void writeChunk(KeyValueContainer container, BlockID blockId, ChunkInfo chunkInfo, ByteBuffer data) throws IOException {
        DispatcherContext context = DispatcherContext.newBuilder((DispatcherContext.Op)DispatcherContext.Op.WRITE_STATE_MACHINE_DATA).setStage(DispatcherContext.WriteChunkStage.WRITE_DATA).setTerm(1L).setLogIndex((long)this.logCounter).build();
        this.chunkManager.writeChunk((Container)container, blockId, chunkInfo, data, context);
        context = DispatcherContext.newBuilder((DispatcherContext.Op)DispatcherContext.Op.APPLY_TRANSACTION).setStage(DispatcherContext.WriteChunkStage.COMMIT_DATA).setTerm(1L).setLogIndex((long)this.logCounter).build();
        this.chunkManager.writeChunk((Container)container, blockId, chunkInfo, data, context);
        ++this.logCounter;
        this.chunkManager.finishWriteChunks(container, new BlockData(blockId));
    }
}

