/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.ozone.freon.FreonReplicationOptions;
import org.apache.hadoop.ozone.freon.FreonSubcommand;
import org.apache.hadoop.ozone.freon.ProgressBar;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="randomkeys", aliases={"rk"}, description={"Generate volumes/buckets and put generated keys."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public final class RandomKeyGenerator
implements Callable<Void>,
FreonSubcommand {
    @CommandLine.ParentCommand
    private Freon freon;
    private static final String DURATION_FORMAT = "HH:mm:ss,SSS";
    private static final int QUANTILES = 10;
    private static final int CHECK_INTERVAL_MILLIS = 100;
    private byte[] keyValueBuffer = null;
    private static final String DIGEST_ALGORITHM = "MD5";
    private MessageDigest commonInitialMD = null;
    private static final Logger LOG = LoggerFactory.getLogger(RandomKeyGenerator.class);
    private volatile boolean completed = false;
    private volatile Throwable exception;
    @CommandLine.Option(names={"--num-of-threads", "--numOfThreads"}, description={"number of threads to be launched for the run. Full name --numOfThreads will be removed in later versions."}, defaultValue="10")
    private int numOfThreads = 10;
    @CommandLine.Option(names={"--num-of-volumes", "--numOfVolumes"}, description={"specifies number of Volumes to be created in offline mode. Full name --numOfVolumes will be removed in later versions."}, defaultValue="10")
    private int numOfVolumes = 10;
    @CommandLine.Option(names={"--num-of-buckets", "--numOfBuckets"}, description={"specifies number of Buckets to be created per Volume. Full name --numOfBuckets will be removed in later versions."}, defaultValue="1000")
    private int numOfBuckets = 1000;
    @CommandLine.Option(names={"--num-of-keys", "--numOfKeys"}, description={"specifies number of Keys to be created per Bucket. Full name --numOfKeys will be removed in later versions."}, defaultValue="500000")
    private int numOfKeys = 500000;
    @CommandLine.Option(names={"--key-size", "--keySize"}, description={"Specifies the size of Key in bytes to be created. Full name --keySize will be removed in later versions. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="10KB", converter={StorageSizeConverter.class})
    private StorageSize keySize;
    @CommandLine.Option(names={"--validate-writes", "--validateWrites"}, description={"Specifies whether to validate keys after writing. Full name --validateWrites will be removed in later versions."})
    private boolean validateWrites = false;
    @CommandLine.Option(names={"--num-of-validate-threads", "--numOfValidateThreads"}, description={"number of threads to be launched for validating keys.Full name --numOfValidateThreads will be removed in later versions."}, defaultValue="1")
    private int numOfValidateThreads = 1;
    @CommandLine.Option(names={"--buffer-size", "--bufferSize"}, description={"Specifies the buffer size while writing. Full name --bufferSize will be removed in later versions."}, defaultValue="4096")
    private int bufferSize = 4096;
    @CommandLine.Option(names={"--json"}, description={"directory where json is created."})
    private String jsonDir;
    @CommandLine.Mixin
    private FreonReplicationOptions replication;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    @CommandLine.Option(names={"--clean-objects"}, description={"Specifies whether to clean the random generated volumes, buckets and keys."})
    private boolean cleanObjects = false;
    private ReplicationConfig replicationConfig;
    private int threadPoolSize;
    private OzoneClient ozoneClient;
    private ObjectStore objectStore;
    private ExecutorService executor;
    private long startTime;
    private long jobStartTime;
    private AtomicLong volumeCreationTime;
    private AtomicLong bucketCreationTime;
    private AtomicLong keyCreationTime;
    private AtomicLong keyWriteTime;
    private AtomicLong totalBytesWritten;
    private int totalBucketCount;
    private long totalKeyCount;
    private AtomicInteger volumeCounter;
    private AtomicInteger bucketCounter;
    private AtomicLong keyCounter;
    private Map<Integer, OzoneVolume> volumes;
    private Map<Integer, OzoneBucket> buckets;
    private AtomicInteger numberOfVolumesCreated;
    private AtomicInteger numberOfBucketsCreated;
    private AtomicLong numberOfKeysAdded;
    private AtomicInteger cleanedBucketCounter;
    private AtomicInteger numberOfBucketsCleaned;
    private AtomicInteger numberOfVolumesCleaned;
    private AtomicLong totalWritesValidated;
    private AtomicLong writeValidationSuccessCount;
    private AtomicLong writeValidationFailureCount;
    private BlockingQueue<KeyValidate> validationQueue;
    private ArrayList<Histogram> histograms = new ArrayList();
    private OzoneConfiguration ozoneConfiguration;
    private ProgressBar progressbar;

    public RandomKeyGenerator() {
    }

    @VisibleForTesting
    RandomKeyGenerator(OzoneConfiguration ozoneConfiguration) {
        this.ozoneConfiguration = ozoneConfiguration;
    }

    public void init(OzoneConfiguration configuration) throws IOException {
        this.startTime = System.nanoTime();
        this.jobStartTime = System.currentTimeMillis();
        this.volumeCreationTime = new AtomicLong();
        this.bucketCreationTime = new AtomicLong();
        this.keyCreationTime = new AtomicLong();
        this.keyWriteTime = new AtomicLong();
        this.totalBytesWritten = new AtomicLong();
        this.numberOfVolumesCreated = new AtomicInteger();
        this.numberOfBucketsCreated = new AtomicInteger();
        this.numberOfKeysAdded = new AtomicLong();
        this.volumeCounter = new AtomicInteger();
        this.bucketCounter = new AtomicInteger();
        this.keyCounter = new AtomicLong();
        this.volumes = new ConcurrentHashMap<Integer, OzoneVolume>();
        this.buckets = new ConcurrentHashMap<Integer, OzoneBucket>();
        this.cleanedBucketCounter = new AtomicInteger();
        this.numberOfBucketsCleaned = new AtomicInteger();
        this.numberOfVolumesCleaned = new AtomicInteger();
        this.ozoneClient = this.omServiceID != null ? OzoneClientFactory.getRpcClient((String)this.omServiceID, (ConfigurationSource)configuration) : OzoneClientFactory.getRpcClient((ConfigurationSource)configuration);
        this.objectStore = this.ozoneClient.getObjectStore();
        for (FreonOps ops : FreonOps.values()) {
            this.histograms.add(ops.ordinal(), new Histogram((Reservoir)new UniformReservoir()));
        }
        if (this.freon != null) {
            this.freon.startHttpServer();
        }
    }

    @Override
    public Void call() throws Exception {
        if (this.ozoneConfiguration == null) {
            this.ozoneConfiguration = this.freon.getOzoneConf();
        }
        if (!this.ozoneConfiguration.getBoolean("hdds.container.chunk.persistdata", true)) {
            LOG.info("Override validateWrites to false, because hdds.container.chunk.persistdata is set to false.");
            this.validateWrites = false;
        }
        this.init(this.ozoneConfiguration);
        this.replicationConfig = this.replication.fromParamsOrConfig((ConfigurationSource)this.ozoneConfiguration);
        this.keyValueBuffer = StringUtils.string2Bytes((String)RandomStringUtils.randomAscii((int)this.bufferSize));
        if (this.validateWrites) {
            this.commonInitialMD = DigestUtils.getDigest((String)DIGEST_ALGORITHM);
            for (long nrRemaining = this.keySize.toBytes(); nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                int curSize = (int)Math.min((long)this.bufferSize, nrRemaining);
                this.commonInitialMD.update(this.keyValueBuffer, 0, curSize);
            }
        }
        this.totalBucketCount = this.numOfVolumes * this.numOfBuckets;
        this.totalKeyCount = this.totalBucketCount * this.numOfKeys;
        LOG.info("Number of Threads: {}", (Object)this.numOfThreads);
        this.threadPoolSize = this.numOfThreads;
        this.executor = Executors.newFixedThreadPool(this.threadPoolSize);
        this.addShutdownHook();
        LOG.info("Number of Volumes: {}.", (Object)this.numOfVolumes);
        LOG.info("Number of Buckets per Volume: {}.", (Object)this.numOfBuckets);
        LOG.info("Number of Keys per Bucket: {}.", (Object)this.numOfKeys);
        LOG.info("Key size: {} bytes", (Object)this.keySize.toBytes());
        LOG.info("Buffer size: {} bytes", (Object)this.bufferSize);
        LOG.info("validateWrites : {}", (Object)this.validateWrites);
        LOG.info("Number of Validate Threads: {}", (Object)this.numOfValidateThreads);
        LOG.info("cleanObjects : {}", (Object)this.cleanObjects);
        for (int i = 0; i < this.numOfThreads; ++i) {
            this.executor.execute(new ObjectCreator());
        }
        ExecutorService validateExecutor = null;
        if (this.validateWrites) {
            this.totalWritesValidated = new AtomicLong();
            this.writeValidationSuccessCount = new AtomicLong();
            this.writeValidationFailureCount = new AtomicLong();
            this.validationQueue = new LinkedBlockingQueue<KeyValidate>();
            validateExecutor = Executors.newFixedThreadPool(this.numOfValidateThreads);
            for (int i = 0; i < this.numOfValidateThreads; ++i) {
                validateExecutor.execute(new Validator());
            }
            LOG.info("Data validation is enabled.");
        }
        LongSupplier currentValue = this.numberOfKeysAdded::get;
        this.progressbar = new ProgressBar(System.out, this.totalKeyCount, currentValue);
        LOG.info("Starting progress bar Thread.");
        this.progressbar.start();
        while (this.numberOfKeysAdded.get() != this.totalKeyCount && this.exception == null) {
            Thread.sleep(100L);
        }
        this.executor.shutdown();
        this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        this.completed = true;
        if (this.exception != null) {
            this.progressbar.terminate();
        } else {
            this.progressbar.shutdown();
        }
        if (validateExecutor != null) {
            while (!this.validationQueue.isEmpty()) {
                Thread.sleep(100L);
            }
            validateExecutor.shutdown();
            validateExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        if (this.cleanObjects && this.exception == null) {
            this.doCleanObjects();
        }
        this.ozoneClient.close();
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
        return null;
    }

    private void addShutdownHook() {
        ShutdownHookManager.get().addShutdownHook(() -> {
            this.printStats(System.out);
            if (this.freon != null) {
                this.freon.stopHttpServer();
            }
        }, 10);
    }

    private void doCleanObjects() throws InterruptedException {
        this.executor = Executors.newFixedThreadPool(this.threadPoolSize);
        for (int i = 0; i < this.numOfThreads; ++i) {
            this.executor.execute(new BucketCleaner());
        }
        LongSupplier currentValue = this.numberOfBucketsCleaned::get;
        this.progressbar = new ProgressBar(System.out, this.totalBucketCount, currentValue);
        LOG.info("Starting clean progress bar Thread.");
        this.progressbar.start();
        try {
            while (this.numberOfBucketsCleaned.get() != this.totalBucketCount && this.exception == null) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to wait until all Buckets are cleaned", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        for (int v = 0; v < this.numOfVolumes; ++v) {
            this.cleanVolume(v);
        }
        if (this.exception != null) {
            this.progressbar.terminate();
        } else {
            this.progressbar.shutdown();
        }
    }

    void printStats(PrintStream out) {
        long endTime = System.nanoTime() - this.startTime;
        String execTime = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(endTime), (String)DURATION_FORMAT);
        long volumeTime = TimeUnit.NANOSECONDS.toMillis(this.volumeCreationTime.get()) / (long)this.threadPoolSize;
        String prettyAverageVolumeTime = DurationFormatUtils.formatDuration((long)volumeTime, (String)DURATION_FORMAT);
        long bucketTime = TimeUnit.NANOSECONDS.toMillis(this.bucketCreationTime.get()) / (long)this.threadPoolSize;
        String prettyAverageBucketTime = DurationFormatUtils.formatDuration((long)bucketTime, (String)DURATION_FORMAT);
        long averageKeyCreationTime = TimeUnit.NANOSECONDS.toMillis(this.keyCreationTime.get()) / (long)this.threadPoolSize;
        String prettyAverageKeyCreationTime = DurationFormatUtils.formatDuration((long)averageKeyCreationTime, (String)DURATION_FORMAT);
        long averageKeyWriteTime = TimeUnit.NANOSECONDS.toMillis(this.keyWriteTime.get()) / (long)this.threadPoolSize;
        String prettyAverageKeyWriteTime = DurationFormatUtils.formatDuration((long)averageKeyWriteTime, (String)DURATION_FORMAT);
        out.println();
        out.println("***************************************************");
        out.println("Status: " + (this.exception != null ? "Failed" : "Success"));
        out.println("Git Base Revision: " + VersionInfo.getRevision());
        out.println("Number of Volumes created: " + this.numberOfVolumesCreated);
        out.println("Number of Buckets created: " + this.numberOfBucketsCreated);
        out.println("Number of Keys added: " + this.numberOfKeysAdded);
        if (this.replicationConfig != null) {
            out.println("Replication: " + this.replicationConfig);
        }
        out.println("Average Time spent in volume creation: " + prettyAverageVolumeTime);
        out.println("Average Time spent in bucket creation: " + prettyAverageBucketTime);
        out.println("Average Time spent in key creation: " + prettyAverageKeyCreationTime);
        out.println("Average Time spent in key write: " + prettyAverageKeyWriteTime);
        out.println("Total bytes written: " + this.totalBytesWritten);
        if (this.validateWrites) {
            out.println("Total number of writes validated: " + this.totalWritesValidated);
            out.println("Writes validated: " + 100.0 * (double)this.totalWritesValidated.get() / (double)this.numberOfKeysAdded.get() + " %");
            out.println("Successful validation: " + this.writeValidationSuccessCount);
            out.println("Unsuccessful validation: " + this.writeValidationFailureCount);
        }
        out.println("Total Execution time: " + execTime);
        out.println("***************************************************");
        if (this.jsonDir != null) {
            String[][] quantileTime = new String[FreonOps.values().length][11];
            String[] deviations = new String[FreonOps.values().length];
            String[] means = new String[FreonOps.values().length];
            for (FreonOps ops : FreonOps.values()) {
                Snapshot snapshot = this.histograms.get(ops.ordinal()).getSnapshot();
                for (int i = 0; i <= 10; ++i) {
                    quantileTime[ops.ordinal()][i] = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)snapshot.getValue(0.1 * (double)i)), (String)DURATION_FORMAT);
                }
                deviations[ops.ordinal()] = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)snapshot.getStdDev()), (String)DURATION_FORMAT);
                means[ops.ordinal()] = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)snapshot.getMean()), (String)DURATION_FORMAT);
            }
            FreonJobInfo jobInfo = new FreonJobInfo().setExecTime(execTime).setGitBaseRevision(VersionInfo.getRevision()).setMeanVolumeCreateTime(means[FreonOps.VOLUME_CREATE.ordinal()]).setDeviationVolumeCreateTime(deviations[FreonOps.VOLUME_CREATE.ordinal()]).setTenQuantileVolumeCreateTime(quantileTime[FreonOps.VOLUME_CREATE.ordinal()]).setMeanBucketCreateTime(means[FreonOps.BUCKET_CREATE.ordinal()]).setDeviationBucketCreateTime(deviations[FreonOps.BUCKET_CREATE.ordinal()]).setTenQuantileBucketCreateTime(quantileTime[FreonOps.BUCKET_CREATE.ordinal()]).setMeanKeyCreateTime(means[FreonOps.KEY_CREATE.ordinal()]).setDeviationKeyCreateTime(deviations[FreonOps.KEY_CREATE.ordinal()]).setTenQuantileKeyCreateTime(quantileTime[FreonOps.KEY_CREATE.ordinal()]).setMeanKeyWriteTime(means[FreonOps.KEY_WRITE.ordinal()]).setDeviationKeyWriteTime(deviations[FreonOps.KEY_WRITE.ordinal()]).setTenQuantileKeyWriteTime(quantileTime[FreonOps.KEY_WRITE.ordinal()]);
            String jsonName = new SimpleDateFormat("yyyyMMddHHmmss").format(Time.now()) + ".json";
            String jsonPath = this.jsonDir + "/" + jsonName;
            try (OutputStream os = Files.newOutputStream(Paths.get(jsonPath, new String[0]), new OpenOption[0]);){
                ObjectMapper mapper = new ObjectMapper();
                mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                writer.writeValue(os, (Object)jobInfo);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                out.println("Json File could not be created for the path: " + jsonPath);
                out.println(e);
            }
            catch (IOException e) {
                out.println("Json object could not be created");
                out.println(e);
            }
        }
    }

    @VisibleForTesting
    int getNumberOfVolumesCreated() {
        return this.numberOfVolumesCreated.get();
    }

    @VisibleForTesting
    int getNumberOfBucketsCreated() {
        return this.numberOfBucketsCreated.get();
    }

    @VisibleForTesting
    long getNumberOfKeysAdded() {
        return this.numberOfKeysAdded.get();
    }

    @VisibleForTesting
    int getNumberOfVolumesCleaned() {
        return this.numberOfVolumesCleaned.get();
    }

    @VisibleForTesting
    int getNumberOfBucketsCleaned() {
        return this.numberOfBucketsCleaned.get();
    }

    @VisibleForTesting
    boolean getValidateWrites() {
        return this.validateWrites;
    }

    @VisibleForTesting
    long getTotalKeysValidated() {
        return this.totalWritesValidated.get();
    }

    @VisibleForTesting
    long getSuccessfulValidationCount() {
        return this.writeValidationSuccessCount.get();
    }

    @VisibleForTesting
    long getUnsuccessfulValidationCount() {
        return this.validateWrites ? this.writeValidationFailureCount.get() : 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createVolume(int volumeNumber) {
        String volumeName = "vol-" + volumeNumber + "-" + RandomStringUtils.randomNumeric((int)5);
        LOG.trace("Creating volume: {}", (Object)volumeName);
        try (AutoCloseable scope = TracingUtil.createActivatedSpan((String)"createVolume");){
            long start = System.nanoTime();
            this.objectStore.createVolume(volumeName);
            long volumeCreationDuration = System.nanoTime() - start;
            this.volumeCreationTime.getAndAdd(volumeCreationDuration);
            this.histograms.get(FreonOps.VOLUME_CREATE.ordinal()).update(volumeCreationDuration);
            this.numberOfVolumesCreated.getAndIncrement();
            OzoneVolume volume = this.objectStore.getVolume(volumeName);
            this.volumes.put(volumeNumber, volume);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.exception = e;
            LOG.error("Could not create volume", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createBucket(int globalBucketNumber) {
        int volumeNumber = globalBucketNumber % this.numOfVolumes;
        int bucketNumber = globalBucketNumber / this.numOfVolumes;
        OzoneVolume volume = this.getVolume(volumeNumber);
        if (volume == null) {
            LOG.error("Could not find volume {}", (Object)volumeNumber);
            return false;
        }
        String bucketName = "bucket-" + bucketNumber + "-" + RandomStringUtils.randomNumeric((int)5);
        LOG.trace("Creating bucket: {} in volume: {}", (Object)bucketName, (Object)volume.getName());
        try (AutoCloseable scope = TracingUtil.createActivatedSpan((String)"createBucket");){
            long start = System.nanoTime();
            volume.createBucket(bucketName);
            long bucketCreationDuration = System.nanoTime() - start;
            this.histograms.get(FreonOps.BUCKET_CREATE.ordinal()).update(bucketCreationDuration);
            this.bucketCreationTime.getAndAdd(bucketCreationDuration);
            this.numberOfBucketsCreated.getAndIncrement();
            OzoneBucket bucket = volume.getBucket(bucketName);
            this.buckets.put(globalBucketNumber, bucket);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.exception = e;
            LOG.error("Could not create bucket ", e);
            return false;
        }
    }

    private boolean createKey(long globalKeyNumber) {
        int globalBucketNumber = (int)(globalKeyNumber % (long)this.totalBucketCount);
        long keyNumber = globalKeyNumber / (long)this.totalBucketCount;
        OzoneBucket bucket = this.getBucket(globalBucketNumber);
        if (bucket == null) {
            LOG.error("Could not find bucket {}", (Object)globalBucketNumber);
            return false;
        }
        String bucketName = bucket.getName();
        String volumeName = bucket.getVolumeName();
        String keyName = "key-" + keyNumber + "-" + RandomStringUtils.randomNumeric((int)5);
        LOG.trace("Adding key: {} in bucket: {} of volume: {}", new Object[]{keyName, bucketName, volumeName});
        try {
            MessageDigest tmpMD;
            boolean validate;
            try (AutoCloseable scope = TracingUtil.createActivatedSpan((String)"createKey");){
                long keyCreateStart = System.nanoTime();
                try (OzoneOutputStream os = bucket.createKey(keyName, this.keySize.toBytes(), this.replicationConfig, new HashMap());){
                    long keyCreationDuration = System.nanoTime() - keyCreateStart;
                    this.histograms.get(FreonOps.KEY_CREATE.ordinal()).update(keyCreationDuration);
                    this.keyCreationTime.getAndAdd(keyCreationDuration);
                    try (AutoCloseable writeScope = TracingUtil.createActivatedSpan((String)"writeKeyData");){
                        long keyWriteStart = System.nanoTime();
                        for (long nrRemaining = this.keySize.toBytes(); nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                            int curSize = (int)Math.min((long)this.bufferSize, nrRemaining);
                            os.write(this.keyValueBuffer, 0, curSize);
                        }
                        long keyWriteDuration = System.nanoTime() - keyWriteStart;
                        this.histograms.get(FreonOps.KEY_WRITE.ordinal()).update(keyWriteDuration);
                        this.keyWriteTime.getAndAdd(keyWriteDuration);
                        this.totalBytesWritten.getAndAdd(this.keySize.toBytes());
                        this.numberOfKeysAdded.getAndIncrement();
                    }
                }
            }
            if (this.validateWrites && (validate = this.validationQueue.offer(new KeyValidate(bucket, keyName, (tmpMD = (MessageDigest)this.commonInitialMD.clone()).digest())))) {
                LOG.trace("Key {} is queued for validation.", (Object)keyName);
            }
            return true;
        }
        catch (Throwable e) {
            this.exception = e;
            LOG.error("Exception while adding key: {} in bucket: {} of volume: {}.", new Object[]{keyName, bucketName, volumeName, e});
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cleanVolume(int volumeNumber) {
        OzoneVolume volume = this.getVolume(volumeNumber);
        String volumeName = volume.getName();
        LOG.trace("Cleaning volume: {}", (Object)volumeName);
        try (AutoCloseable scope = TracingUtil.createActivatedSpan((String)"cleanVolume");){
            this.objectStore.deleteVolume(volumeName);
            this.numberOfVolumesCleaned.getAndIncrement();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.exception = e;
            LOG.error("Could not clean volume", e);
            return false;
        }
    }

    private boolean cleanBucket(int globalBucketNumber) {
        int volumeNumber = globalBucketNumber % this.numOfVolumes;
        OzoneVolume volume = this.getVolume(volumeNumber);
        OzoneBucket bucket = this.getBucket(globalBucketNumber);
        String bucketName = bucket.getName();
        if (volume == null) {
            LOG.error("Could not find volume {}", (Object)volumeNumber);
            return false;
        }
        LOG.trace("Cleaning bucket: {} in volume: {}", (Object)bucketName, (Object)volume.getName());
        ArrayList keys = new ArrayList();
        try {
            bucket.listKeys(null).forEachRemaining(x -> keys.add(x.getName()));
            bucket.deleteKeys(keys);
            volume.deleteBucket(bucketName);
            this.numberOfBucketsCleaned.getAndIncrement();
            return true;
        }
        catch (Throwable e) {
            this.exception = e;
            LOG.error("Could not clean bucket ", e);
            return false;
        }
    }

    private OzoneVolume getVolume(Integer volumeNumber) {
        return this.waitUntilAddedToMap(this.volumes, volumeNumber);
    }

    private OzoneBucket getBucket(Integer bucketNumber) {
        return this.waitUntilAddedToMap(this.buckets, bucketNumber);
    }

    private <T> T waitUntilAddedToMap(Map<Integer, T> map, Integer i) {
        while (this.exception == null && !map.containsKey(i)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return map.get(i);
    }

    @VisibleForTesting
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    private class Validator
    implements Runnable {
        private Validator() {
        }

        @Override
        public void run() {
            DigestUtils dig = new DigestUtils(RandomKeyGenerator.DIGEST_ALGORITHM);
            while (!RandomKeyGenerator.this.completed || !RandomKeyGenerator.this.validationQueue.isEmpty()) {
                try {
                    KeyValidate kv = (KeyValidate)RandomKeyGenerator.this.validationQueue.poll(5L, TimeUnit.SECONDS);
                    if (kv == null) continue;
                    OzoneInputStream is = kv.bucket.readKey(kv.keyName);
                    dig.getMessageDigest().reset();
                    byte[] curDigest = dig.digest((InputStream)is);
                    RandomKeyGenerator.this.totalWritesValidated.getAndIncrement();
                    if (MessageDigest.isEqual(kv.digest, curDigest)) {
                        RandomKeyGenerator.this.writeValidationSuccessCount.getAndIncrement();
                    } else {
                        RandomKeyGenerator.this.writeValidationFailureCount.getAndIncrement();
                        LOG.warn("Data validation error for key {}/{}/{}", new Object[]{kv.bucket.getVolumeName(), kv.bucket, kv.keyName});
                        LOG.warn("Expected checksum: {}, Actual checksum: {}", (Object)kv.digest, (Object)curDigest);
                    }
                    is.close();
                    continue;
                }
                catch (IOException ex) {
                    LOG.error("Exception while validating write.", (Throwable)ex);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    private final class FreonJobInfo {
        private String status;
        private String gitBaseRevision;
        private String jobStartTime;
        private int numOfVolumes;
        private int numOfBuckets;
        private int numOfKeys;
        private int numOfThreads;
        private String dataWritten;
        private String execTime;
        private String replication;
        private String replicationType;
        private long keySize;
        private int bufferSize;
        private String totalThroughputPerSecond;
        private String meanVolumeCreateTime;
        private String deviationVolumeCreateTime;
        private String[] tenQuantileVolumeCreateTime;
        private String meanBucketCreateTime;
        private String deviationBucketCreateTime;
        private String[] tenQuantileBucketCreateTime;
        private String meanKeyCreateTime;
        private String deviationKeyCreateTime;
        private String[] tenQuantileKeyCreateTime;
        private String meanKeyWriteTime;
        private String deviationKeyWriteTime;
        private String[] tenQuantileKeyWriteTime;

        private FreonJobInfo() {
            this.status = RandomKeyGenerator.this.exception != null ? "Failed" : "Success";
            this.numOfVolumes = RandomKeyGenerator.this.numOfVolumes;
            this.numOfBuckets = RandomKeyGenerator.this.numOfBuckets;
            this.numOfKeys = RandomKeyGenerator.this.numOfKeys;
            this.numOfThreads = RandomKeyGenerator.this.numOfThreads;
            this.keySize = RandomKeyGenerator.this.keySize.toBytes();
            this.bufferSize = RandomKeyGenerator.this.bufferSize;
            this.jobStartTime = Time.formatTime((long)RandomKeyGenerator.this.jobStartTime);
            this.replicationType = RandomKeyGenerator.this.replicationConfig.getReplicationType().name();
            this.replication = RandomKeyGenerator.this.replicationConfig.getReplication();
            long totalBytes = (long)this.numOfVolumes * (long)this.numOfBuckets * (long)this.numOfKeys * this.keySize;
            this.dataWritten = this.getInStorageUnits(Double.valueOf(totalBytes));
            this.totalThroughputPerSecond = this.getInStorageUnits((double)totalBytes * 1.0 / (double)TimeUnit.NANOSECONDS.toSeconds(RandomKeyGenerator.this.keyWriteTime.get() / (long)RandomKeyGenerator.this.threadPoolSize));
        }

        private String getInStorageUnits(Double value) {
            OzoneConsts.Units unit;
            double size;
            if ((long)(value / 1.099511627776E12) != 0L) {
                size = value / 1.099511627776E12;
                unit = OzoneConsts.Units.TB;
            } else if ((long)(value / 1.073741824E9) != 0L) {
                size = value / 1.073741824E9;
                unit = OzoneConsts.Units.GB;
            } else if ((long)(value / 1048576.0) != 0L) {
                size = value / 1048576.0;
                unit = OzoneConsts.Units.MB;
            } else if ((long)(value / 1024.0) != 0L) {
                size = value / 1024.0;
                unit = OzoneConsts.Units.KB;
            } else {
                size = value;
                unit = OzoneConsts.Units.B;
            }
            return size + " " + unit;
        }

        public FreonJobInfo setGitBaseRevision(String gitBaseRevisionVal) {
            this.gitBaseRevision = gitBaseRevisionVal;
            return this;
        }

        public FreonJobInfo setExecTime(String execTimeVal) {
            this.execTime = execTimeVal;
            return this;
        }

        public FreonJobInfo setMeanKeyWriteTime(String deviationKeyWriteTimeVal) {
            this.meanKeyWriteTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationKeyWriteTime(String deviationKeyWriteTimeVal) {
            this.deviationKeyWriteTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileKeyWriteTime(String[] tenQuantileKeyWriteTimeVal) {
            this.tenQuantileKeyWriteTime = tenQuantileKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setMeanKeyCreateTime(String deviationKeyWriteTimeVal) {
            this.meanKeyCreateTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationKeyCreateTime(String deviationKeyCreateTimeVal) {
            this.deviationKeyCreateTime = deviationKeyCreateTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileKeyCreateTime(String[] tenQuantileKeyCreateTimeVal) {
            this.tenQuantileKeyCreateTime = tenQuantileKeyCreateTimeVal;
            return this;
        }

        public FreonJobInfo setMeanBucketCreateTime(String deviationKeyWriteTimeVal) {
            this.meanBucketCreateTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationBucketCreateTime(String deviationBucketCreateTimeVal) {
            this.deviationBucketCreateTime = deviationBucketCreateTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileBucketCreateTime(String[] tenQuantileBucketCreateTimeVal) {
            this.tenQuantileBucketCreateTime = tenQuantileBucketCreateTimeVal;
            return this;
        }

        public FreonJobInfo setMeanVolumeCreateTime(String deviationKeyWriteTimeVal) {
            this.meanVolumeCreateTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationVolumeCreateTime(String deviationVolumeCreateTimeVal) {
            this.deviationVolumeCreateTime = deviationVolumeCreateTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileVolumeCreateTime(String[] tenQuantileVolumeCreateTimeVal) {
            this.tenQuantileVolumeCreateTime = tenQuantileVolumeCreateTimeVal;
            return this;
        }

        public String getJobStartTime() {
            return this.jobStartTime;
        }

        public int getNumOfVolumes() {
            return this.numOfVolumes;
        }

        public int getNumOfBuckets() {
            return this.numOfBuckets;
        }

        public int getNumOfKeys() {
            return this.numOfKeys;
        }

        public int getNumOfThreads() {
            return this.numOfThreads;
        }

        public String getExecTime() {
            return this.execTime;
        }

        public String getReplication() {
            return this.replication;
        }

        public String getReplicationType() {
            return this.replicationType;
        }

        public String getStatus() {
            return this.status;
        }

        public long getKeySize() {
            return this.keySize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public String getGitBaseRevision() {
            return this.gitBaseRevision;
        }

        public String getDataWritten() {
            return this.dataWritten;
        }

        public String getTotalThroughputPerSecond() {
            return this.totalThroughputPerSecond;
        }

        public String getMeanVolumeCreateTime() {
            return this.meanVolumeCreateTime;
        }

        public String getDeviationVolumeCreateTime() {
            return this.deviationVolumeCreateTime;
        }

        public String[] getTenQuantileVolumeCreateTime() {
            return this.tenQuantileVolumeCreateTime;
        }

        public String getMeanBucketCreateTime() {
            return this.meanBucketCreateTime;
        }

        public String getDeviationBucketCreateTime() {
            return this.deviationBucketCreateTime;
        }

        public String[] getTenQuantileBucketCreateTime() {
            return this.tenQuantileBucketCreateTime;
        }

        public String getMeanKeyCreateTime() {
            return this.meanKeyCreateTime;
        }

        public String getDeviationKeyCreateTime() {
            return this.deviationKeyCreateTime;
        }

        public String[] getTenQuantileKeyCreateTime() {
            return this.tenQuantileKeyCreateTime;
        }

        public String getMeanKeyWriteTime() {
            return this.meanKeyWriteTime;
        }

        public String getDeviationKeyWriteTime() {
            return this.deviationKeyWriteTime;
        }

        public String[] getTenQuantileKeyWriteTime() {
            return this.tenQuantileKeyWriteTime;
        }
    }

    private class BucketCleaner
    implements Runnable {
        private BucketCleaner() {
        }

        @Override
        public void run() {
            int b;
            while ((b = RandomKeyGenerator.this.cleanedBucketCounter.getAndIncrement()) < RandomKeyGenerator.this.totalBucketCount) {
                if (RandomKeyGenerator.this.cleanBucket(b)) continue;
                return;
            }
        }
    }

    private class ObjectCreator
    implements Runnable {
        private ObjectCreator() {
        }

        @Override
        public void run() {
            long k;
            int b;
            int v;
            while ((v = RandomKeyGenerator.this.volumeCounter.getAndIncrement()) < RandomKeyGenerator.this.numOfVolumes) {
                if (RandomKeyGenerator.this.createVolume(v)) continue;
                return;
            }
            while ((b = RandomKeyGenerator.this.bucketCounter.getAndIncrement()) < RandomKeyGenerator.this.totalBucketCount) {
                if (RandomKeyGenerator.this.createBucket(b)) continue;
                return;
            }
            while ((k = RandomKeyGenerator.this.keyCounter.getAndIncrement()) < RandomKeyGenerator.this.totalKeyCount) {
                if (RandomKeyGenerator.this.createKey(k)) continue;
                return;
            }
        }
    }

    private static class KeyValidate {
        private OzoneBucket bucket;
        private String keyName;
        private byte[] digest;

        KeyValidate(OzoneBucket bucket, String keyName, byte[] digest) {
            this.bucket = bucket;
            this.keyName = keyName;
            this.digest = digest;
        }
    }

    static enum FreonOps {
        VOLUME_CREATE,
        BUCKET_CREATE,
        KEY_CREATE,
        KEY_WRITE;

    }
}

