/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.freon.AbstractOmBucketReadWriteOps;
import org.apache.hadoop.ozone.freon.FreonReplicationOptions;
import picocli.CommandLine;

@CommandLine.Command(name="obrwk", aliases={"om-bucket-read-write-key-ops"}, description={"Creates keys, performs respective read/write operations to measure lock performance."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmBucketReadWriteKeyOps
extends AbstractOmBucketReadWriteOps {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-k", "--key-count-for-read"}, description={"Number of keys to be created for read operations."}, defaultValue="100")
    private int keyCountForRead;
    @CommandLine.Option(names={"-w", "--key-count-for-write"}, description={"Number of keys to be created for write operations."}, defaultValue="10")
    private int keyCountForWrite;
    @CommandLine.Option(names={"-o", "--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    @CommandLine.Mixin
    private FreonReplicationOptions replication;
    private Map<String, String> metadata;
    private ReplicationConfig replicationConfig;
    private OzoneBucket bucket;

    @Override
    protected void display() {
        this.print("volumeName: " + this.volumeName);
        this.print("bucketName: " + this.bucketName);
        this.print("keyCountForRead: " + this.keyCountForRead);
        this.print("keyCountForWrite: " + this.keyCountForWrite);
        this.print("omServiceID: " + this.omServiceID);
    }

    @Override
    protected void initialize(OzoneConfiguration ozoneConfiguration) throws Exception {
        this.replicationConfig = this.replication.fromParamsOrConfig((ConfigurationSource)ozoneConfiguration);
        this.metadata = new HashMap<String, String>();
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, ozoneConfiguration);){
            this.ensureVolumeAndBucketExist(rpcClient, this.volumeName, this.bucketName);
            this.bucket = rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName);
            this.runTests(this::mainMethod);
        }
    }

    private void mainMethod(long counter) throws Exception {
        int readResult = this.readOperations(this.keyCountForRead);
        int writeResult = this.writeOperations(this.keyCountForWrite);
        this.print("Total Keys Read: " + readResult);
        this.print("Total Keys Written: " + writeResult * this.keyCountForWrite);
    }

    @Override
    protected String createPath(String path) {
        return "".concat("/").concat(path);
    }

    @Override
    protected int getReadCount(int readCount, String readPath) throws IOException {
        List ozoneFileStatusList = this.bucket.listStatus("/" + readPath + "/", true, "/", (long)this.keyCountForRead);
        return readCount += ozoneFileStatusList.size();
    }

    @Override
    protected OutputStream create(String keyName) throws IOException {
        return this.bucket.createKey(keyName, this.getSizeInBytes(), this.replicationConfig, this.metadata);
    }
}

