/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.AbstractOmBucketReadWriteOps;
import picocli.CommandLine;

@CommandLine.Command(name="obrwf", aliases={"om-bucket-read-write-file-ops"}, description={"Creates files, performs respective read/write operations to measure lock performance."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmBucketReadWriteFileOps
extends AbstractOmBucketReadWriteOps {
    @CommandLine.Option(names={"-P", "--root-path"}, description={"Root path"}, defaultValue="o3fs://bucket1.vol1/dir1/dir2")
    private String rootPath;
    @CommandLine.Option(names={"-r", "--file-count-for-read"}, description={"Number of files to be written in the read directory."}, defaultValue="100")
    private int fileCountForRead;
    @CommandLine.Option(names={"-w", "--file-count-for-write"}, description={"Number of files to be written in the write directory."}, defaultValue="10")
    private int fileCountForWrite;
    private FileSystem fileSystem;

    @Override
    protected void display() {
        this.print("rootPath: " + this.rootPath);
        this.print("fileCountForRead: " + this.fileCountForRead);
        this.print("fileCountForWrite: " + this.fileCountForWrite);
    }

    @Override
    protected void initialize(OzoneConfiguration ozoneConfiguration) throws IOException {
        this.fileSystem = FileSystem.get((URI)URI.create(this.rootPath), (Configuration)ozoneConfiguration);
        this.runTests(this::mainMethod);
    }

    private void mainMethod(long counter) throws Exception {
        int readResult = this.readOperations(this.fileCountForRead);
        int writeResult = this.writeOperations(this.fileCountForWrite);
        this.print("Total Files Read: " + readResult);
        this.print("Total Files Written: " + writeResult * this.fileCountForWrite);
    }

    @Override
    protected String createPath(String path) throws IOException {
        String fullPath = this.rootPath.concat("/").concat(path);
        this.fileSystem.mkdirs(new Path(fullPath));
        return fullPath;
    }

    @Override
    protected int getReadCount(int readCount, String readPath) throws IOException {
        FileStatus[] status = this.fileSystem.listStatus(new Path(this.createPath(readPath)));
        return readCount += status.length;
    }

    @Override
    protected OutputStream create(String fileName) throws IOException {
        Path file = new Path(fileName);
        return this.fileSystem.create(file);
    }
}

