/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.ExtensibleParentCommand;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.http.HttpServer2;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.freon.FreonHttpServer;
import org.apache.hadoop.ozone.freon.FreonSubcommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone freon", description={"Load generator and tester tool for ozone"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class Freon
extends GenericCli
implements ExtensibleParentCommand {
    public static final Logger LOG = LoggerFactory.getLogger(Freon.class);
    @CommandLine.Option(names={"--server"}, description={"Enable internal http server to provide metric and profile endpoint"})
    private boolean httpServer = false;
    private final boolean interactive = System.console() != null;
    private FreonHttpServer freonHttpServer;
    private OzoneConfiguration conf;

    public int execute(String[] argv) {
        this.conf = this.getOzoneConf();
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.conf, (String)"ozone-freon");
        TracingUtil.initTracing((String)"freon", (ConfigurationSource)this.conf);
        return super.execute(argv);
    }

    public Class<?> subcommandType() {
        return FreonSubcommand.class;
    }

    public void stopHttpServer() {
        if (this.freonHttpServer != null) {
            try {
                this.freonHttpServer.stop();
            }
            catch (Exception e) {
                LOG.error("Freon http server can't be stopped", (Throwable)e);
            }
        }
    }

    public void startHttpServer() {
        if (this.httpServer) {
            try {
                HttpServer2.setHttpBaseDir((OzoneConfiguration)this.conf);
                this.freonHttpServer = new FreonHttpServer((MutableConfigurationSource)this.conf);
                this.freonHttpServer.start();
            }
            catch (IOException e) {
                LOG.error("Freon http server can't be started", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        new Freon().run(args);
    }

    public boolean isInteractive() {
        return this.interactive;
    }
}

