/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ScmOption;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaInfo;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.debug.replicas.ReplicaVerifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;

public class FindMissingPadding
implements ReplicaVerifier {
    private OzoneClient ozoneClient;
    private ScmOption scmOption;
    private Logger log;
    private PrintWriter printWriter;
    private OzoneConfiguration ozoneConfiguration;
    private final Map<Long, Map<Long, Set<OzoneKey>>> candidateKeys = new HashMap<Long, Map<Long, Set<OzoneKey>>>();
    private final Set<OzoneKey> affectedKeys = new HashSet<OzoneKey>();

    public FindMissingPadding(OzoneClient ozoneClient, ScmOption scmOption, Logger log, PrintWriter printWriter, OzoneConfiguration ozoneConfiguration) {
        this.ozoneClient = ozoneClient;
        this.scmOption = scmOption;
        this.log = log;
        this.printWriter = printWriter;
        this.ozoneConfiguration = ozoneConfiguration;
    }

    protected void execute() throws IOException {
        this.checkContainers();
        this.handleAffectedKeys();
    }

    @Override
    public void verifyKey(OzoneKeyDetails keyDetails) {
        this.checkECKey(keyDetails);
    }

    private void checkECKey(OzoneKeyDetails keyDetails) {
        if (!FindMissingPadding.isEC((OzoneKey)keyDetails)) {
            this.log.trace("Key {}/{}/{} is not EC", new Object[]{keyDetails.getVolumeName(), keyDetails.getBucketName(), keyDetails.getName()});
            return;
        }
        List locations = keyDetails.getOzoneKeyLocations();
        if (!locations.isEmpty()) {
            ECReplicationConfig ecConfig = (ECReplicationConfig)keyDetails.getReplicationConfig();
            long sizeThreshold = (long)(ecConfig.getData() - 1) * (long)ecConfig.getEcChunkSize();
            for (OzoneKeyLocation loc : locations) {
                long size = loc.getLength();
                if (size > sizeThreshold) continue;
                this.candidateKeys.computeIfAbsent(loc.getContainerID(), k -> new HashMap()).computeIfAbsent(loc.getLocalID(), k -> new HashSet()).add(keyDetails);
            }
        } else {
            this.log.trace("Key {}/{}/{} has no locations", new Object[]{keyDetails.getVolumeName(), keyDetails.getBucketName(), keyDetails.getName()});
        }
    }

    private static boolean isEC(OzoneKey key) {
        return key.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkContainers() throws IOException {
        if (this.candidateKeys.isEmpty()) {
            return;
        }
        SecurityConfig securityConfig = new SecurityConfig((ConfigurationSource)this.ozoneConfiguration);
        boolean tokenEnabled = securityConfig.isSecurityEnabled() && securityConfig.isContainerTokenEnabled();
        StorageContainerLocationProtocol scmContainerClient = HAUtils.getScmContainerClient((ConfigurationSource)this.ozoneConfiguration);
        RpcClient rpcClient = (RpcClient)this.ozoneClient.getProxy();
        XceiverClientFactory xceiverClientManager = rpcClient.getXceiverClientManager();
        Pipeline.Builder pipelineBuilder = Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE));
        try (ScmClient scmClient = this.scmOption.createScmClient();){
            for (Map.Entry<Long, Map<Long, Set<OzoneKey>>> entry : this.candidateKeys.entrySet()) {
                long containerID = entry.getKey();
                Map<Long, Set<OzoneKey>> blockToKeysMap = entry.getValue();
                ContainerInfo container = scmClient.getContainer(containerID);
                if (container.getState() != HddsProtos.LifeCycleState.CLOSED) {
                    this.log.trace("Skip container {} as it is not CLOSED, rather {}", (Object)containerID, (Object)container.getState());
                    continue;
                }
                Token token = tokenEnabled ? scmContainerClient.getContainerToken(ContainerID.valueOf((long)containerID)) : null;
                List containerReplicas = scmClient.getContainerReplicas(containerID);
                this.log.debug("Container {} replicas: {}", (Object)containerID, (Object)containerReplicas.stream().sorted(Comparator.comparing(ContainerReplicaInfo::getReplicaIndex).thenComparing(ContainerReplicaInfo::getState).thenComparing(r -> r.getDatanodeDetails().getUuidString())).map(r -> "index=" + r.getReplicaIndex() + " keys=" + r.getKeyCount() + " state=" + r.getState() + " dn=" + r.getDatanodeDetails()).collect(Collectors.joining(", ")));
                for (ContainerReplicaInfo replica : containerReplicas) {
                    if (!HddsProtos.LifeCycleState.CLOSED.name().equals(replica.getState())) {
                        this.log.trace("Ignore container {} replica {} at {} in {} state", new Object[]{replica.getContainerID(), replica.getReplicaIndex(), replica.getDatanodeDetails(), replica.getState()});
                        continue;
                    }
                    HashSet<Long> missingBlocks = new HashSet<Long>(blockToKeysMap.keySet());
                    Pipeline pipeline = pipelineBuilder.setNodes(Collections.singletonList(replica.getDatanodeDetails())).build();
                    XceiverClientSpi datanodeClient = xceiverClientManager.acquireClientForReadData(pipeline);
                    try {
                        ContainerProtos.ListBlockResponseProto listBlockResponse = ContainerProtocolCalls.listBlock((XceiverClientSpi)datanodeClient, (long)containerID, null, (int)Integer.MAX_VALUE, (Token)token);
                        for (ContainerProtos.BlockData blockData : listBlockResponse.getBlockDataList()) {
                            missingBlocks.remove(blockData.getBlockID().getLocalID());
                        }
                        if (missingBlocks.isEmpty()) {
                            this.log.debug("All {} blocks in container {} found on replica {} at {}", new Object[]{blockToKeysMap.keySet().size(), containerID, replica.getReplicaIndex(), replica.getDatanodeDetails()});
                            continue;
                        }
                        this.log.info("Found {} blocks missing from container {} on replica {} at {}", new Object[]{missingBlocks.size(), containerID, replica.getReplicaIndex(), replica.getDatanodeDetails()});
                        missingBlocks.forEach(b -> this.affectedKeys.addAll(blockToKeysMap.getOrDefault(b, Collections.emptySet())));
                    }
                    finally {
                        xceiverClientManager.releaseClientForReadData(datanodeClient, false);
                    }
                }
            }
        }
    }

    private void handleAffectedKeys() {
        if (!this.affectedKeys.isEmpty()) {
            this.printWriter.println(StringUtils.join((CharSequence)"\t", Arrays.asList("Key", "Size", "Replication")));
            for (OzoneKey key : this.affectedKeys) {
                this.printWriter.println(StringUtils.join((CharSequence)"\t", Arrays.asList(key.getVolumeName() + "/" + key.getBucketName() + "/" + key.getName(), key.getDataSize(), key.getReplicationConfig().getReplication())));
            }
        }
    }
}

