/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.debug.replicas.ReplicaVerifier;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.slf4j.Logger;

public class Checksums
implements ReplicaVerifier {
    private static final String JSON_PROPERTY_FILE_NAME = "filename";
    private static final String JSON_PROPERTY_FILE_SIZE = "datasize";
    private static final String JSON_PROPERTY_FILE_BLOCKS = "blocks";
    private static final String JSON_PROPERTY_BLOCK_INDEX = "blockIndex";
    private static final String JSON_PROPERTY_BLOCK_CONTAINERID = "containerId";
    private static final String JSON_PROPERTY_BLOCK_LOCALID = "localId";
    private static final String JSON_PROPERTY_BLOCK_LENGTH = "length";
    private static final String JSON_PROPERTY_BLOCK_OFFSET = "offset";
    private static final String JSON_PROPERTY_BLOCK_REPLICAS = "replicas";
    private static final String JSON_PROPERTY_REPLICA_HOSTNAME = "hostname";
    private static final String JSON_PROPERTY_REPLICA_UUID = "uuid";
    private static final String JSON_PROPERTY_REPLICA_EXCEPTION = "exception";
    private String outputDir;
    private RpcClient rpcClient = null;
    private OzoneClient client;
    private Logger log;
    private OzoneConfiguration ozoneConfiguration;

    public Checksums(OzoneClient client, String outputDir, Logger log, OzoneConfiguration conf) {
        this.client = client;
        this.outputDir = outputDir;
        this.log = log;
        this.ozoneConfiguration = conf;
    }

    private void downloadReplicasAndCreateManifest(String keyName, Map<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> replicas, Map<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> replicasWithoutChecksum, File dir, ArrayNode blocks) throws IOException {
        int blockIndex = 0;
        for (Map.Entry<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> block : replicas.entrySet()) {
            ObjectNode blockJson = JsonUtils.createObjectNode(null);
            ArrayNode replicasJson = JsonUtils.createArrayNode();
            OmKeyLocationInfo locationInfo = block.getKey();
            blockJson.put(JSON_PROPERTY_BLOCK_INDEX, ++blockIndex);
            blockJson.put(JSON_PROPERTY_BLOCK_CONTAINERID, locationInfo.getContainerID());
            blockJson.put(JSON_PROPERTY_BLOCK_LOCALID, locationInfo.getLocalID());
            blockJson.put(JSON_PROPERTY_BLOCK_LENGTH, locationInfo.getLength());
            blockJson.put(JSON_PROPERTY_BLOCK_OFFSET, locationInfo.getOffset());
            BlockID blockID = locationInfo.getBlockID();
            Map<DatanodeDetails, OzoneInputStream> blockReplicasWithoutChecksum = this.replicasOf(blockID, replicasWithoutChecksum);
            for (Map.Entry<DatanodeDetails, OzoneInputStream> replica : block.getValue().entrySet()) {
                ObjectNode replicaJson;
                block28: {
                    DatanodeDetails datanode = replica.getKey();
                    replicaJson = JsonUtils.createObjectNode(null);
                    replicaJson.put(JSON_PROPERTY_REPLICA_HOSTNAME, datanode.getHostName());
                    replicaJson.put(JSON_PROPERTY_REPLICA_UUID, datanode.getUuidString());
                    String fileName = keyName + "_block" + blockIndex + "_" + datanode.getHostName();
                    Path path = new File(dir, fileName).toPath();
                    try (InputStream is = (InputStream)replica.getValue();){
                        Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        Throwable cause = e.getCause();
                        replicaJson.put(JSON_PROPERTY_REPLICA_EXCEPTION, e.getMessage());
                        if (!(cause instanceof OzoneChecksumException)) break block28;
                        try (InputStream is2 = this.getReplica(blockReplicasWithoutChecksum, datanode);){
                            Files.copy(is2, path, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                replicasJson.add((JsonNode)replicaJson);
            }
            blockJson.set(JSON_PROPERTY_BLOCK_REPLICAS, (JsonNode)replicasJson);
            blocks.add((JsonNode)blockJson);
            IOUtils.close((Logger)this.log, blockReplicasWithoutChecksum.values());
        }
    }

    private Map<DatanodeDetails, OzoneInputStream> replicasOf(BlockID blockID, Map<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> replicas) {
        for (Map.Entry<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> block : replicas.entrySet()) {
            if (!block.getKey().getBlockID().equals((Object)blockID)) continue;
            return block.getValue();
        }
        return Collections.emptyMap();
    }

    private InputStream getReplica(Map<DatanodeDetails, OzoneInputStream> replicas, DatanodeDetails datanode) {
        InputStream input = (InputStream)replicas.remove(datanode);
        return input != null ? input : new ByteArrayInputStream(new byte[0]);
    }

    @Nonnull
    private File createDirectory(String volumeName, String bucketName, String keyName) throws IOException {
        String fileSuffix = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String directoryName = volumeName + "_" + bucketName + "_" + keyName + "_" + fileSuffix;
        System.out.println("Creating directory : " + directoryName);
        File dir = new File(this.outputDir, directoryName);
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                System.out.println("Successfully created!");
            } else {
                throw new IOException(String.format("Failed to create directory %s.", dir));
            }
        }
        return dir;
    }

    @Override
    public void verifyKey(OzoneKeyDetails keyDetails) {
        String volumeName = keyDetails.getVolumeName();
        String bucketName = keyDetails.getBucketName();
        String keyName = keyDetails.getName();
        System.out.println("Processing key : " + volumeName + "/" + bucketName + "/" + keyName);
        boolean isChecksumVerifyEnabled = this.ozoneConfiguration.getBoolean("ozone.client.verify.checksum", true);
        RpcClient newClient = null;
        try {
            RpcClient noChecksumClient;
            RpcClient checksumClient;
            OzoneConfiguration configuration = new OzoneConfiguration((Configuration)this.ozoneConfiguration);
            configuration.setBoolean("ozone.client.verify.checksum", !isChecksumVerifyEnabled);
            newClient = this.getClient(isChecksumVerifyEnabled);
            if (isChecksumVerifyEnabled) {
                checksumClient = this.client.getObjectStore().getClientProxy();
                noChecksumClient = newClient;
            } else {
                checksumClient = newClient;
                noChecksumClient = this.client.getObjectStore().getClientProxy();
            }
            String sanitizedKeyName = keyName.replace("/", "_");
            File dir = this.createDirectory(volumeName, bucketName, sanitizedKeyName);
            OzoneKeyDetails keyInfoDetails = checksumClient.getKeyDetails(volumeName, bucketName, keyName);
            Map replicas = checksumClient.getKeysEveryReplicas(volumeName, bucketName, keyName);
            Map replicasWithoutChecksum = noChecksumClient.getKeysEveryReplicas(volumeName, bucketName, keyName);
            ObjectNode result = JsonUtils.createObjectNode(null);
            result.put(JSON_PROPERTY_FILE_NAME, volumeName + "/" + bucketName + "/" + keyName);
            result.put(JSON_PROPERTY_FILE_SIZE, keyInfoDetails.getDataSize());
            ArrayNode blocks = JsonUtils.createArrayNode();
            this.downloadReplicasAndCreateManifest(sanitizedKeyName, replicas, replicasWithoutChecksum, dir, blocks);
            result.set(JSON_PROPERTY_FILE_BLOCKS, (JsonNode)blocks);
            String prettyJson = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)result);
            String manifestFileName = sanitizedKeyName + "_manifest";
            File manifestFile = new File(dir, manifestFileName);
            Files.write(manifestFile.toPath(), prettyJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RpcClient getClient(boolean isChecksumVerifyEnabled) throws IOException {
        if (this.rpcClient != null) {
            return this.rpcClient;
        }
        OzoneConfiguration configuration = new OzoneConfiguration((Configuration)this.ozoneConfiguration);
        configuration.setBoolean("ozone.client.verify.checksum", !isChecksumVerifyEnabled);
        this.rpcClient = new RpcClient((ConfigurationSource)configuration, null);
        return this.rpcClient;
    }
}

