/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocol.OMConfiguration;
import org.apache.hadoop.ozone.om.protocolPB.OMAdminProtocolClientSideImpl;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="decommission", customSynopsis={"ozone admin om decommission -id=<om-service-id> -nodeid=<decommission-om-node-id> -hostname=<decommission-om-node-address> [options]"}, description={"Decommission an OzoneManager. Ensure that the node being decommissioned is shutdown first.\nNote - Add the node to be decommissioned to ozone.om.decommissioned.nodesconfig in ozone-site.xml of all OzoneManagers before proceeding with decommission.\nNote - DECOMMISSIONING AN OM MIGHT RENDER THE CLUSTER TO LOSE HIGH AVAILABILITY.\nNote - When there are only two OzoneManagers, do not stop the OzoneManager before decommissioning as both OzoneManagers are required to reach quorum.\nIt is recommended to add another OzoneManager(s) before decommissioning one to maintain HA."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DecommissionOMSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"OM Service ID"}, required=true)
    private String omServiceId;
    @CommandLine.Option(names={"-nodeid", "--nodeid"}, description={"NodeID of the OM to be decommissioned."}, required=true)
    private String decommNodeId;
    @CommandLine.Option(names={"-hostname", "--node-host-address"}, description={"Host name/address of the OM to be decommissioned."}, required=true)
    private String hostname;
    private InetAddress hostInetAddress;
    @CommandLine.Option(names={"--force"}, description={"This option will skip checking whether OM configs have been updated with the decommissioned node added to ozone.om.decommissioned.nodes config in ozone-site.xml."})
    private boolean force;
    private OzoneConfiguration ozoneConf;
    private UserGroupInformation user;

    @Override
    public Void call() throws IOException {
        this.ozoneConf = this.parent.getParent().getOzoneConf();
        this.user = this.parent.getParent().getUser();
        this.verifyNodeIdAndHostAddress();
        if (!this.force) {
            this.verifyConfigUpdatedOnAllOMs();
        }
        try (OMAdminProtocolClientSideImpl omAdminProtocolClient = OMAdminProtocolClientSideImpl.createProxyForOMHA((OzoneConfiguration)this.ozoneConf, (UserGroupInformation)this.user, (String)this.omServiceId);){
            OMNodeDetails decommNodeDetails = new OMNodeDetails.Builder().setOMNodeId(this.decommNodeId).setHostAddress(this.hostInetAddress.getHostAddress()).build();
            omAdminProtocolClient.decommission(decommNodeDetails);
            System.out.println("Successfully decommissioned OM " + this.decommNodeId);
        }
        catch (IOException e) {
            System.out.println("Failed to decommission OM " + this.decommNodeId);
            throw e;
        }
        return null;
    }

    private void verifyNodeIdAndHostAddress() throws IOException {
        String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.omServiceId, this.decommNodeId});
        String rpcAddrStr = OmUtils.getOmRpcAddress((ConfigurationSource)this.ozoneConf, (String)rpcAddrKey);
        if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
            throw new IOException("There is no OM corresponding to " + this.decommNodeId + "in the configuration.");
        }
        this.hostInetAddress = InetAddress.getByName(this.hostname);
        InetAddress rpcAddressFromConfig = InetAddress.getByName(rpcAddrStr.split(":")[0]);
        if (!this.hostInetAddress.equals(rpcAddressFromConfig)) {
            throw new IOException("OM " + this.decommNodeId + "'s host address in config - " + rpcAddressFromConfig.getHostAddress() + " does not match the provided host address " + this.hostInetAddress);
        }
    }

    private void verifyConfigUpdatedOnAllOMs() throws IOException {
        String decommNodesKey = ConfUtils.addKeySuffixes((String)"ozone.om.decommissioned.nodes", (String[])new String[]{this.omServiceId});
        Collection decommNodes = OmUtils.getDecommissionedNodeIds((ConfigurationSource)this.ozoneConf, (String)decommNodesKey);
        if (!decommNodes.contains(this.decommNodeId)) {
            throw new IOException("Please add the to be decommissioned OM " + this.decommNodeId + " to the " + decommNodesKey + " config in ozone-site.xml of all nodes.");
        }
        List activeOMNodeDetails = OmUtils.getAllOMHAAddresses((OzoneConfiguration)this.ozoneConf, (String)this.omServiceId, (boolean)false);
        if (activeOMNodeDetails.isEmpty()) {
            throw new IOException("Cannot decommission OM " + this.decommNodeId + " as it is the only node in the ring.");
        }
        ArrayList<String> staleOMConfigs = new ArrayList<String>();
        for (OMNodeDetails nodeDetails : activeOMNodeDetails) {
            if (this.checkOMConfig(nodeDetails)) continue;
            staleOMConfigs.add(nodeDetails.getNodeId());
        }
        if (!staleOMConfigs.isEmpty()) {
            throw new IOException("OM(s) " + StringUtils.join(staleOMConfigs, (char)',') + " have not been updated with decommissioned nodes list or their address for the decommissioning node does not match");
        }
    }

    private boolean checkOMConfig(OMNodeDetails omNodeDetails) throws IOException {
        try (OMAdminProtocolClientSideImpl omAdminProtocolClient = OMAdminProtocolClientSideImpl.createProxyForSingleOM((OzoneConfiguration)this.ozoneConf, (UserGroupInformation)this.user, (OMNodeDetails)omNodeDetails);){
            OMConfiguration omConfig = omAdminProtocolClient.getOMConfiguration();
            OMNodeDetails decommNodeDetails = (OMNodeDetails)omConfig.getDecommissionedNodesInNewConf().get(this.decommNodeId);
            if (decommNodeDetails == null) {
                boolean bl = false;
                return bl;
            }
            if (!decommNodeDetails.getRpcAddress().getAddress().equals(this.hostInetAddress)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

