/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.util.DurationUtil;
import org.apache.hadoop.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Check if ContainerBalancer is running or not"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ContainerBalancerStatusSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Verbose output. Show current iteration info."})
    private boolean verbose;
    @CommandLine.Option(names={"-H", "--history"}, description={"Verbose output with history. Show current iteration info and history of iterations. Works only with -v."})
    private boolean verboseWithHistory;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto response = scmClient.getContainerBalancerStatusInfo();
        boolean isRunning = response.getIsRunning();
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoProto balancerStatusInfo = response.getContainerBalancerStatusInfo();
        if (isRunning) {
            Instant startedAtInstant = Instant.ofEpochSecond(balancerStatusInfo.getStartedAt());
            LocalDateTime dateTime = LocalDateTime.ofInstant(startedAtInstant, ZoneId.systemDefault());
            System.out.println("ContainerBalancer is Running.");
            if (this.verbose) {
                System.out.printf("Started at: %s %s%n", dateTime.toLocalDate().format(DateTimeFormatter.ISO_LOCAL_DATE), dateTime.toLocalTime().format(DateTimeFormatter.ISO_LOCAL_TIME));
                Duration balancingDuration = Duration.between(startedAtInstant, OffsetDateTime.now());
                System.out.printf("Balancing duration: %s%n%n", DurationUtil.getPrettyDuration(balancingDuration));
                System.out.println(this.getConfigurationPrettyString(balancerStatusInfo.getConfiguration()));
                List iterationsStatusInfoList = balancerStatusInfo.getIterationsStatusInfoList();
                System.out.println("Current iteration info:");
                StorageContainerLocationProtocolProtos.ContainerBalancerTaskIterationStatusInfoProto currentIterationStatistic = iterationsStatusInfoList.stream().filter(it -> it.getIterationResult().isEmpty()).findFirst().orElse(null);
                if (currentIterationStatistic == null) {
                    System.out.println("-\n");
                } else {
                    System.out.println(this.getPrettyIterationStatusInfo(currentIterationStatistic));
                }
                if (this.verboseWithHistory) {
                    System.out.println("Iteration history list:");
                    System.out.println(iterationsStatusInfoList.stream().filter(it -> !it.getIterationResult().isEmpty()).map(this::getPrettyIterationStatusInfo).collect(Collectors.joining("\n")));
                }
            }
        } else {
            System.out.println("ContainerBalancer is Not Running.");
        }
    }

    String getConfigurationPrettyString(HddsProtos.ContainerBalancerConfigurationProto configuration) {
        return String.format("Container Balancer Configuration values:%n%-50s %s%n%-50s %s%n%-50s %d%n%-50s %dGB%n%-50s %dGB%n%-50s %dGB%n%-50s %d%n%-50s %dmin%n%-50s %dmin%n%-50s %dmin%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n", "Key", "Value", "Threshold", configuration.getUtilizationThreshold(), "Max Datanodes to Involve per Iteration(percent)", configuration.getDatanodesInvolvedMaxPercentagePerIteration(), "Max Size to Move per Iteration", (long)configuration.getDatanodesInvolvedMaxPercentagePerIteration() / 0x40000000L, "Max Size Entering Target per Iteration", configuration.getSizeEnteringTargetMax() / 0x40000000L, "Max Size Leaving Source per Iteration", configuration.getSizeLeavingSourceMax() / 0x40000000L, "Number of Iterations", configuration.getIterations(), "Time Limit for Single Container's Movement", Duration.ofMillis(configuration.getMoveTimeout()).toMinutes(), "Time Limit for Single Container's Replication", Duration.ofMillis(configuration.getMoveReplicationTimeout()).toMinutes(), "Interval between each Iteration", Duration.ofMillis(configuration.getBalancingIterationInterval()).toMinutes(), "Whether to Enable Network Topology", configuration.getMoveNetworkTopologyEnable(), "Whether to Trigger Refresh Datanode Usage Info", configuration.getTriggerDuBeforeMoveEnable(), "Container IDs to Exclude from Balancing", configuration.getExcludeContainers().isEmpty() ? "None" : configuration.getExcludeContainers(), "Datanodes Specified to be Balanced", configuration.getIncludeDatanodes().isEmpty() ? "None" : configuration.getIncludeDatanodes(), "Datanodes Excluded from Balancing", configuration.getExcludeDatanodes().isEmpty() ? "None" : configuration.getExcludeDatanodes());
    }

    private String getPrettyIterationStatusInfo(StorageContainerLocationProtocolProtos.ContainerBalancerTaskIterationStatusInfoProto iterationStatusInfo) {
        String leavingDataNodeList;
        int iterationNumber = iterationStatusInfo.getIterationNumber();
        String iterationResult = iterationStatusInfo.getIterationResult();
        long iterationDuration = iterationStatusInfo.getIterationDuration();
        long sizeScheduledForMove = iterationStatusInfo.getSizeScheduledForMove();
        long dataSizeMoved = iterationStatusInfo.getDataSizeMoved();
        long containerMovesScheduled = iterationStatusInfo.getContainerMovesScheduled();
        long containerMovesCompleted = iterationStatusInfo.getContainerMovesCompleted();
        long containerMovesFailed = iterationStatusInfo.getContainerMovesFailed();
        long containerMovesTimeout = iterationStatusInfo.getContainerMovesTimeout();
        String enteringDataNodeList = iterationStatusInfo.getSizeEnteringNodesList().stream().map(nodeInfo -> nodeInfo.getUuid() + " <- " + StringUtils.byteDesc((long)nodeInfo.getDataVolume()) + "\n").collect(Collectors.joining());
        if (enteringDataNodeList.isEmpty()) {
            enteringDataNodeList = " -\n";
        }
        if ((leavingDataNodeList = iterationStatusInfo.getSizeLeavingNodesList().stream().map(nodeInfo -> nodeInfo.getUuid() + " -> " + StringUtils.byteDesc((long)nodeInfo.getDataVolume()) + "\n").collect(Collectors.joining())).isEmpty()) {
            leavingDataNodeList = " -\n";
        }
        return String.format("%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %s%n%-50s %n%s%-50s %n%s", "Key", "Value", "Iteration number", iterationNumber == 0 ? "-" : Integer.valueOf(iterationNumber), "Iteration duration", DurationUtil.getPrettyDuration(Duration.ofSeconds(iterationDuration)), "Iteration result", iterationResult.isEmpty() ? "-" : iterationResult, "Size scheduled to move", StringUtils.byteDesc((long)sizeScheduledForMove), "Moved data size", StringUtils.byteDesc((long)dataSizeMoved), "Scheduled to move containers", containerMovesScheduled, "Already moved containers", containerMovesCompleted, "Failed to move containers", containerMovesFailed, "Failed to move containers by timeout", containerMovesTimeout, "Entered data to nodes", enteringDataNodeList, "Exited data from nodes", leavingDataNodeList);
    }
}

