/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OmUpgradeAction;
import org.apache.hadoop.ozone.om.upgrade.UpgradeActionOm;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.LayoutVersionInstanceFactory;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.VersionFactoryKey;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMLayoutVersionManager
extends AbstractLayoutVersionManager<OMLayoutFeature> {
    private static final Logger LOG = LoggerFactory.getLogger(OMLayoutVersionManager.class);
    public static final String OM_CLASS_PACKAGE = "org.apache.hadoop.ozone.om";
    public static final String OM_REQUEST_CLASS_PACKAGE = "org.apache.hadoop.ozone.om.request";
    public static final String OM_UPGRADE_CLASS_PACKAGE = "org.apache.hadoop.ozone.om.upgrade";
    private LayoutVersionInstanceFactory<Class<? extends OMClientRequest>> requestFactory = new LayoutVersionInstanceFactory();

    public OMLayoutVersionManager(int layoutVersion) throws OMException {
        this.init(layoutVersion);
    }

    public OMLayoutVersionManager() throws IOException {
        LayoutFeature[] features = OMLayoutFeature.values();
        this.init(features[features.length - 1].layoutVersion(), features);
    }

    private void init(int layoutVersion) throws OMException {
        try {
            this.init(layoutVersion, OMLayoutFeature.values());
        }
        catch (IOException e) {
            throw new OMException(String.format("Cannot initialize VersionManager. Metadata layout version (%d) > software layout version (%d)", this.getMetadataLayoutVersion(), this.getSoftwareLayoutVersion()), (Throwable)e, OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
        }
        this.registerUpgradeActions(OM_UPGRADE_CLASS_PACKAGE);
    }

    @VisibleForTesting
    protected void registerUpgradeActions(String packageName) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(new String[]{packageName}).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()}).setExpandSuperTypes(false).setParallel(true));
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(UpgradeActionOm.class);
        typesAnnotatedWith.forEach(actionClass -> {
            block5: {
                if (OmUpgradeAction.class.isAssignableFrom((Class<?>)actionClass)) {
                    try {
                        OmUpgradeAction action = (OmUpgradeAction)actionClass.newInstance();
                        UpgradeActionOm annotation = actionClass.getAnnotation(UpgradeActionOm.class);
                        OMLayoutFeature feature = annotation.feature();
                        if (feature.layoutVersion() > this.getMetadataLayoutVersion()) {
                            LOG.info("Registering Upgrade Action : {}", (Object)action.name());
                            feature.addAction(annotation.type(), action);
                            break block5;
                        }
                        LOG.info("Skipping Upgrade Action {} since it has been finalized.", (Object)action.name());
                    }
                    catch (Exception e) {
                        LOG.error("Cannot instantiate Upgrade Action class {}", (Object)actionClass.getSimpleName(), (Object)e);
                    }
                } else {
                    LOG.warn("Found upgrade action class not of type org.apache.hadoop.ozone.om.upgrade.OmUpgradeAction : {}", (Object)actionClass.getName());
                }
            }
        });
    }

    @VisibleForTesting
    public static Set<Class<? extends OMClientRequest>> getRequestClasses(String packageName) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner()}).setExpandSuperTypes(false).setParallel(true));
        HashSet<Class<? extends OMClientRequest>> validRequests = new HashSet<Class<? extends OMClientRequest>>();
        Set subTypes = reflections.getSubTypesOf(OMClientRequest.class);
        for (Class requestClass : subTypes) {
            if (Modifier.isAbstract(requestClass.getModifiers())) continue;
            validRequests.add(requestClass);
        }
        return validRequests;
    }

    public Class<? extends OMClientRequest> getHandler(String type) {
        VersionFactoryKey versionFactoryKey = new VersionFactoryKey.Builder().key(type).build();
        return (Class)this.requestFactory.get((LayoutVersionManager)this, versionFactoryKey);
    }

    public void finalized(OMLayoutFeature layoutFeature) {
        super.finalized((LayoutFeature)layoutFeature);
        this.requestFactory.finalizeFeature((LayoutFeature)layoutFeature);
    }

    public static int maxLayoutVersion() {
        OMLayoutFeature[] features = OMLayoutFeature.values();
        return features[features.length - 1].layoutVersion();
    }
}

