/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotUtils.class);

    private SnapshotUtils() {
        throw new IllegalStateException("SnapshotUtils should not be initialized.");
    }

    public static SnapshotInfo getSnapshotInfo(OzoneManager ozoneManager, String volumeName, String bucketName, String snapshotName) throws IOException {
        return SnapshotUtils.getSnapshotInfo(ozoneManager, SnapshotInfo.getTableKey((String)volumeName, (String)bucketName, (String)snapshotName));
    }

    public static SnapshotInfo getSnapshotInfo(OzoneManager ozoneManager, String snapshotKey) throws IOException {
        SnapshotInfo snapshotInfo;
        try {
            snapshotInfo = (SnapshotInfo)ozoneManager.getMetadataManager().getSnapshotInfoTable().get((Object)snapshotKey);
        }
        catch (IOException e) {
            LOG.error("Snapshot '{}' is not found.", (Object)snapshotKey, (Object)e);
            throw e;
        }
        if (snapshotInfo == null) {
            throw new OMException("Snapshot '" + snapshotKey + "' is not found.", OMException.ResultCodes.FILE_NOT_FOUND);
        }
        return snapshotInfo;
    }

    public static SnapshotInfo getSnapshotInfo(OzoneManager ozoneManager, SnapshotChainManager chainManager, UUID snapshotId) throws IOException {
        String tableKey = chainManager.getTableKey(snapshotId);
        return SnapshotUtils.getSnapshotInfo(ozoneManager, tableKey);
    }

    public static void dropColumnFamilyHandle(ManagedRocksDB rocksDB, ColumnFamilyHandle columnFamilyHandle) {
        if (columnFamilyHandle == null) {
            return;
        }
        try {
            ((RocksDB)rocksDB.get()).dropColumnFamily(columnFamilyHandle);
        }
        catch (RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void checkSnapshotDirExist(File checkpoint) throws IOException {
        if (!checkpoint.exists()) {
            throw new OMException("Unable to load snapshot. Snapshot checkpoint directory '" + checkpoint.getAbsolutePath() + "' does not exist yet. Please wait a few more seconds before " + "retrying", OMException.ResultCodes.TIMEOUT);
        }
    }

    public static void checkSnapshotActive(OzoneManager ozoneManager, String snapshotTableKey) throws IOException {
        SnapshotUtils.checkSnapshotActive(SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotTableKey), false);
    }

    public static void checkSnapshotActive(SnapshotInfo snapInfo, boolean skipCheck) throws OMException {
        if (!skipCheck && snapInfo.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) {
            throw new OMException("Unable to load snapshot. Snapshot with table key '" + snapInfo.getTableKey() + "' is no longer active", OMException.ResultCodes.FILE_NOT_FOUND);
        }
    }

    public static SnapshotInfo getNextSnapshot(OzoneManager ozoneManager, SnapshotChainManager chainManager, SnapshotInfo snapInfo) throws IOException {
        if (snapInfo == null) {
            throw new OMException("Provided Snapshot Info argument is null. Cannot get the next snapshot for a null value", OMException.ResultCodes.FILE_NOT_FOUND);
        }
        try {
            if (chainManager.hasNextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId())) {
                UUID nextPathSnapshot = chainManager.nextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
                return SnapshotUtils.getSnapshotInfo(ozoneManager, chainManager, nextPathSnapshot);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            LOG.error("The snapshot {} is not longer in snapshot chain, It maybe removed in the previous Snapshot purge request.", (Object)snapInfo.getTableKey());
        }
        return null;
    }

    public static SnapshotInfo getPreviousSnapshot(OzoneManager ozoneManager, SnapshotChainManager chainManager, SnapshotInfo snapInfo) throws IOException {
        UUID previousSnapshotId = SnapshotUtils.getPreviousSnapshotId(snapInfo, chainManager);
        return previousSnapshotId == null ? null : SnapshotUtils.getSnapshotInfo(ozoneManager, chainManager, previousSnapshotId);
    }

    private static UUID getPreviousSnapshotId(SnapshotInfo snapInfo, SnapshotChainManager chainManager) throws IOException {
        if (snapInfo == null) {
            throw new OMException("Provided Snapshot Info argument is null. Cannot get the previous snapshot for a null value", OMException.ResultCodes.FILE_NOT_FOUND);
        }
        try {
            if (chainManager.hasPreviousPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId())) {
                return chainManager.previousPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return null;
    }

    public static Map<String, String> getColumnFamilyToKeyPrefixMap(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String keyPrefix = omMetadataManager.getBucketKeyPrefix(volumeName, bucketName);
        String keyPrefixFso = omMetadataManager.getBucketKeyPrefixFSO(volumeName, bucketName);
        HashMap<String, String> columnFamilyToPrefixMap = new HashMap<String, String>();
        columnFamilyToPrefixMap.put("keyTable", keyPrefix);
        columnFamilyToPrefixMap.put("directoryTable", keyPrefixFso);
        columnFamilyToPrefixMap.put("fileTable", keyPrefixFso);
        return columnFamilyToPrefixMap;
    }

    public static RepeatedOmKeyInfo createMergedRepeatedOmKeyInfoFromDeletedTableEntry(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos snapshotMoveKeyInfos, OMMetadataManager metadataManager) throws IOException {
        String dbKey = snapshotMoveKeyInfos.getKey();
        ArrayList<OmKeyInfo> keyInfoList = new ArrayList<OmKeyInfo>();
        for (OzoneManagerProtocolProtos.KeyInfo info : snapshotMoveKeyInfos.getKeyInfosList()) {
            OmKeyInfo fromProtobuf = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)info);
            keyInfoList.add(fromProtobuf);
        }
        RepeatedOmKeyInfo result = (RepeatedOmKeyInfo)metadataManager.getDeletedTable().get((Object)dbKey);
        if (result == null) {
            result = new RepeatedOmKeyInfo(keyInfoList);
        } else if (!SnapshotUtils.isSameAsLatestOmKeyInfo(keyInfoList, result)) {
            keyInfoList.forEach(arg_0 -> ((RepeatedOmKeyInfo)result).addOmKeyInfo(arg_0));
        }
        return result;
    }

    private static boolean isSameAsLatestOmKeyInfo(List<OmKeyInfo> omKeyInfos, RepeatedOmKeyInfo result) {
        int size = result.getOmKeyInfoList().size();
        if (size >= omKeyInfos.size()) {
            return omKeyInfos.equals(result.getOmKeyInfoList().subList(size - omKeyInfos.size(), size));
        }
        return false;
    }

    public static SnapshotInfo getLatestSnapshotInfo(String volumeName, String bucketName, OzoneManager ozoneManager, SnapshotChainManager snapshotChainManager) throws IOException {
        Optional<UUID> latestPathSnapshot = Optional.ofNullable(SnapshotUtils.getLatestPathSnapshotId(volumeName, bucketName, snapshotChainManager));
        return latestPathSnapshot.isPresent() ? SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotChainManager, latestPathSnapshot.get()) : null;
    }

    public static UUID getLatestPathSnapshotId(String volumeName, String bucketName, SnapshotChainManager snapshotChainManager) throws IOException {
        String snapshotPath = String.valueOf(volumeName) + "/" + bucketName;
        return snapshotChainManager.getLatestPathSnapshotId(snapshotPath);
    }

    public static void validatePreviousSnapshotId(SnapshotInfo snapshotInfo, SnapshotChainManager snapshotChainManager, UUID expectedPreviousSnapshotId) throws IOException {
        UUID previousSnapshotId;
        UUID uUID = previousSnapshotId = snapshotInfo == null ? snapshotChainManager.getLatestGlobalSnapshotId() : SnapshotUtils.getPreviousSnapshotId(snapshotInfo, snapshotChainManager);
        if (!Objects.equals(expectedPreviousSnapshotId, previousSnapshotId)) {
            throw new OMException("Snapshot validation failed. Expected previous snapshotId : " + expectedPreviousSnapshotId + " but was " + previousSnapshotId, OMException.ResultCodes.INVALID_REQUEST);
        }
    }
}

