/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tagging;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.s3.tagging.S3PutObjectTaggingResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"fileTable"})
public class S3PutObjectTaggingResponseWithFSO
extends S3PutObjectTaggingResponse {
    private long volumeId;
    private long bucketId;

    public S3PutObjectTaggingResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, @Nonnull long volumeId, @Nonnull long bucketId) {
        super(omResponse, omKeyInfo);
        this.volumeId = volumeId;
        this.bucketId = bucketId;
    }

    public S3PutObjectTaggingResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneDbKey = omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, this.getOmKeyInfo().getParentObjectID(), this.getOmKeyInfo().getFileName());
        omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)this.getOmKeyInfo());
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

