/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotSetPropertyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotSetPropertyRequest.class);

    public OMSnapshotSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMSnapshotSetPropertyResponse omClientResponse;
        OMMetrics omMetrics = ozoneManager.getMetrics();
        OMMetadataManager metadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = this.getOmRequest().getSetSnapshotPropertyRequest();
        String snapshotKey = setSnapshotPropertyRequest.getSnapshotKey();
        try {
            SnapshotInfo updatedSnapInfo = (SnapshotInfo)metadataManager.getSnapshotInfoTable().get((Object)snapshotKey);
            if (updatedSnapInfo == null) {
                LOG.error("Snapshot: '{}' doesn't not exist in snapshot table.", (Object)snapshotKey);
                throw new OMException("Snapshot: '{" + snapshotKey + "}' doesn't not exist in snapshot table.", OMException.ResultCodes.FILE_NOT_FOUND);
            }
            if (setSnapshotPropertyRequest.hasDeepCleanedDeletedDir()) {
                updatedSnapInfo.setDeepCleanedDeletedDir(setSnapshotPropertyRequest.getDeepCleanedDeletedDir());
            }
            if (setSnapshotPropertyRequest.hasDeepCleanedDeletedKey()) {
                updatedSnapInfo.setDeepClean(setSnapshotPropertyRequest.getDeepCleanedDeletedKey());
            }
            if (setSnapshotPropertyRequest.hasSnapshotSize()) {
                OzoneManagerProtocolProtos.SnapshotSize snapshotSize = setSnapshotPropertyRequest.getSnapshotSize();
                long exclusiveSize = updatedSnapInfo.getExclusiveSize() + snapshotSize.getExclusiveSize();
                long exclusiveReplicatedSize = updatedSnapInfo.getExclusiveReplicatedSize() + snapshotSize.getExclusiveReplicatedSize();
                updatedSnapInfo.setExclusiveSize(exclusiveSize);
                updatedSnapInfo.setExclusiveReplicatedSize(exclusiveReplicatedSize);
            }
            metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapshotKey), CacheValue.get((long)context.getIndex(), (Object)updatedSnapInfo));
            omClientResponse = new OMSnapshotSetPropertyResponse(omResponse.build(), updatedSnapInfo);
            omMetrics.incNumSnapshotSetProperties();
            LOG.info("Successfully executed snapshotSetPropertyRequest: {{}}.", (Object)setSnapshotPropertyRequest);
        }
        catch (IOException ex) {
            omClientResponse = new OMSnapshotSetPropertyResponse(this.createErrorOMResponse(omResponse, ex));
            omMetrics.incNumSnapshotSetPropertyFails();
            LOG.error("Failed to execute snapshotSetPropertyRequest: {{}}.", (Object)setSnapshotPropertyRequest, (Object)ex);
        }
        return omClientResponse;
    }
}

