/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.multitenant.OzoneTenant;
import org.apache.hadoop.ozone.om.multitenant.Tenant;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMTenantDeleteResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTenantDeleteRequest
extends OMVolumeRequest {
    public static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTenantDeleteRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTenantDeleteRequest.class);
    }

    public OMTenantDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
        multiTenantManager.checkAdmin();
        String tenantId = omRequest.getDeleteTenantRequest().getTenantId();
        Preconditions.checkNotNull((Object)tenantId);
        Tenant tenantObj = multiTenantManager.getTenantFromDBById(tenantId);
        multiTenantManager.getAuthorizerLock().tryWriteLockInOMRequest();
        try {
            multiTenantManager.getAuthorizerOp().deleteTenant(tenantObj);
        }
        catch (Exception e) {
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            throw e;
        }
        return omRequest;
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        String volumeName;
        String tenantId;
        HashMap<String, String> auditMap;
        OMTenantDeleteResponse omClientResponse;
        OMMetrics omMetrics;
        block17: {
            long transactionLogIndex = context.getIndex();
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumTenantDeletes();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            boolean acquiredVolumeLock = false;
            auditMap = new HashMap<String, String>();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.DeleteTenantRequest request = this.getOmRequest().getDeleteTenantRequest();
            tenantId = request.getTenantId();
            volumeName = null;
            boolean decVolumeRefCount = true;
            exception = null;
            OmVolumeArgs omVolumeArgs = null;
            try {
                try {
                    if (!omMetadataManager.getTenantStateTable().isExist((Object)tenantId)) {
                        LOG.debug("tenant: {} does not exist", (Object)tenantId);
                        throw new OMException("Tenant '" + tenantId + "' does not exist", OMException.ResultCodes.TENANT_NOT_FOUND);
                    }
                    OmDBTenantState dbTenantState = (OmDBTenantState)omMetadataManager.getTenantStateTable().get((Object)tenantId);
                    volumeName = dbTenantState.getBucketNamespaceName();
                    Preconditions.checkNotNull((Object)volumeName);
                    LOG.debug("Tenant '{}' has volume '{}'", (Object)tenantId, (Object)volumeName);
                    decVolumeRefCount = !volumeName.isEmpty();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    if (!ozoneManager.getMultiTenantManager().isTenantEmpty(tenantId)) {
                        LOG.warn("tenant: '{}' is not empty. Unable to delete the tenant", (Object)tenantId);
                        throw new OMException("Tenant '" + tenantId + "' is not empty. " + "All accessIds associated to this tenant must be revoked before " + "the tenant can be deleted. See `ozone tenant user revoke`", OMException.ResultCodes.TENANT_NOT_EMPTY);
                    }
                    omMetadataManager.getTenantStateTable().addCacheEntry(new CacheKey((Object)tenantId), CacheValue.get((long)transactionLogIndex));
                    if (decVolumeRefCount) {
                        if (ozoneManager.getAclsEnabled()) {
                            this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volumeName, null, null);
                        }
                        omVolumeArgs = this.getVolumeInfo(omMetadataManager, volumeName);
                        omVolumeArgs.decRefCount();
                        String dbVolumeKey = omMetadataManager.getVolumeKey(volumeName);
                        omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                    }
                    multiTenantManager.getCacheOp().deleteTenant((Tenant)new OzoneTenant(tenantId));
                    OzoneManagerProtocolProtos.DeleteTenantResponse.Builder deleteTenantResponse = OzoneManagerProtocolProtos.DeleteTenantResponse.newBuilder().setVolumeName(volumeName).setVolRefCount(omVolumeArgs == null ? -1L : omVolumeArgs.getRefCount());
                    omClientResponse = new OMTenantDeleteResponse(omResponse.setDeleteTenantResponse(deleteTenantResponse).build(), volumeName, omVolumeArgs, tenantId);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMTenantDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredVolumeLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (acquiredVolumeLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                }
                multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
            }
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        auditMap.put("tenant", tenantId);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.DELETE_TENANT, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("Deleted tenant '{}' and volume '{}'", (Object)tenantId, (Object)volumeName);
            omMetrics.decNumTenants();
        } else {
            LOG.error("Failed to delete tenant '{}'", (Object)tenantId, (Object)exception);
            omMetrics.incNumTenantDeleteFails();
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTenantDeleteRequest.java", OMTenantDeleteRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantDeleteRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 71);
    }
}

