/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl.prefix;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMPrefixAclRequest
extends OMClientRequest {
    public OMPrefixAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OzoneObj obj;
        OMClientRequest.Result result;
        boolean opResult;
        OzoneObj resolvedPrefixObj;
        Exception exception;
        OMClientResponse omClientResponse;
        long trxnLogIndex;
        block19: {
            trxnLogIndex = context.getIndex();
            OmPrefixInfo omPrefixInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String prefixPath = null;
            resolvedPrefixObj = null;
            PrefixManagerImpl.OMPrefixAclOpResult operationResult = null;
            opResult = false;
            result = null;
            PrefixManagerImpl prefixManager = (PrefixManagerImpl)ozoneManager.getPrefixManager();
            try {
                try {
                    resolvedPrefixObj = prefixManager.getResolvedPrefixObj(this.getOzoneObj());
                    prefixManager.validateOzoneObj(this.getOzoneObj());
                    this.validatePrefixPath(resolvedPrefixObj.getPath());
                    prefixPath = resolvedPrefixObj.getPath();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.PREFIX, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, resolvedPrefixObj.getVolumeName(), resolvedPrefixObj.getBucketName(), resolvedPrefixObj.getPrefixName());
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    omPrefixInfo = (OmPrefixInfo)omMetadataManager.getPrefixTable().get((Object)prefixPath);
                    if (omPrefixInfo != null) {
                        omPrefixInfo.setUpdateID(trxnLogIndex);
                    }
                    try {
                        operationResult = this.apply(resolvedPrefixObj, prefixManager, omPrefixInfo, trxnLogIndex);
                    }
                    catch (IOException iOException) {
                        operationResult = new PrefixManagerImpl.OMPrefixAclOpResult(null, false);
                    }
                    omPrefixInfo = operationResult.getOmPrefixInfo();
                    if (omPrefixInfo == null) {
                        throw new OMException("No prefix info for the prefix path: " + prefixPath, OMException.ResultCodes.PREFIX_NOT_FOUND);
                    }
                    if (this.getOmRequest().hasRemoveAclRequest() && omPrefixInfo.getAcls().isEmpty()) {
                        omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), CacheValue.get((long)trxnLogIndex));
                    } else {
                        omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), CacheValue.get((long)trxnLogIndex, (Object)omPrefixInfo));
                    }
                    opResult = operationResult.isSuccess();
                    omClientResponse = this.onSuccess(omResponse, omPrefixInfo, opResult);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        if ((obj = resolvedPrefixObj) == null) {
            obj = this.getOzoneObj();
        }
        Map auditMap = obj.toAuditMap();
        this.onComplete(obj, opResult, exception, ozoneManager.getMetrics(), result, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    private void validatePrefixPath(String prefixPath) throws OMException {
        if (!OzoneFSUtils.isValidName((String)prefixPath)) {
            throw new OMException("Invalid prefix path name: " + prefixPath, OMException.ResultCodes.INVALID_PATH_IN_ACL_REQUEST);
        }
    }

    abstract OzoneObj getOzoneObj();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmPrefixInfo var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, Exception var2);

    abstract void onComplete(OzoneObj var1, boolean var2, Exception var3, OMMetrics var4, OMClientRequest.Result var5, long var6, AuditLogger var8, Map<String, String> var9);

    abstract PrefixManagerImpl.OMPrefixAclOpResult apply(OzoneObj var1, PrefixManagerImpl var2, OmPrefixInfo var3, long var4) throws IOException;
}

