/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketSetOwnerResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetOwnerRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMBucketSetOwnerRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMBucketSetOwnerRequest.class);
    }

    public OMBucketSetOwnerRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder setBucketPropertyRequestBuilder = this.getOmRequest().getSetBucketPropertyRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetBucketPropertyRequest(setBucketPropertyRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        block15: {
            block16: {
                transactionLogIndex = context.getIndex();
                setBucketPropertyRequest = this.getOmRequest().getSetBucketPropertyRequest();
                Preconditions.checkNotNull((Object)setBucketPropertyRequest);
                omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                if (!setBucketPropertyRequest.getBucketArgs().hasOwnerName()) {
                    omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                    return new OMBucketSetOwnerResponse(omResponse.build());
                }
                omMetadataManager = ozoneManager.getMetadataManager();
                omMetrics = ozoneManager.getMetrics();
                omMetrics.incNumBucketUpdates();
                bucketArgs = setBucketPropertyRequest.getBucketArgs();
                omBucketArgs = OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)bucketArgs);
                volumeName = bucketArgs.getVolumeName();
                bucketName = bucketArgs.getBucketName();
                newOwner = bucketArgs.getOwnerName();
                oldOwner = null;
                auditLogger = ozoneManager.getAuditLogger();
                userInfo = this.getOmRequest().getUserInfo();
                exception = null;
                acquiredBucketLock = false;
                success = true;
                omClientResponse = null;
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volumeName, bucketName, null);
                }
                this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
                if (omBucketInfo == null) {
                    OMBucketSetOwnerRequest.LOG.debug("Bucket: {} not found ", (Object)bucketName);
                    throw new OMException("Bucket doesnt exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
                }
                oldOwner = omBucketInfo.getOwner();
                if (!newOwner.equals(oldOwner)) break block15;
                OMBucketSetOwnerRequest.LOG.warn("Bucket '{}/{}' owner is already user '{}'.", new Object[]{volumeName, bucketName, oldOwner});
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.OK).setMessage("Bucket '" + volumeName + "/" + bucketName + "' owner is already '" + newOwner + "'.").setSuccess(false);
                omResponse.setSetBucketPropertyResponse(OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder().setResponse(false).build());
                var24_23 = omClientResponse = new OMBucketSetOwnerResponse(omResponse.build());
                if (!acquiredBucketLock) break block16;
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
            return var24_23;
        }
        try {
            try {
                omBucketInfo.setOwner(newOwner);
                OMBucketSetOwnerRequest.LOG.debug("Updating bucket owner to {} for bucket: {} in volume: {}", new Object[]{newOwner, bucketName, volumeName});
                omBucketInfo.setModificationTime(setBucketPropertyRequest.getModificationTime());
                omBucketInfo.setUpdateID(transactionLogIndex);
                omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)transactionLogIndex, (Object)omBucketInfo));
                omResponse.setSetBucketPropertyResponse(OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder().setResponse(true).build());
                omClientResponse = new OMBucketSetOwnerResponse(omResponse.build(), omBucketInfo);
            }
            catch (IOException | InvalidPathException ex) {
                success = false;
                exception = ex;
                omClientResponse = new OMBucketSetOwnerResponse(this.createErrorOMResponse(omResponse, exception));
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse == null) ** GOTO lbl81
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        catch (Throwable var23_24) {
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
            throw var23_24;
        }
        if (acquiredBucketLock) {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
        }
        if (omClientResponse != null) {
            omClientResponse.setOmLockDetails(this.getOmLockDetails());
        }
lbl81:
        // 5 sources

        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.SET_OWNER, omBucketArgs.toAuditMap(), exception, userInfo));
        if (success) {
            OMBucketSetOwnerRequest.LOG.debug("Successfully changed Owner of Bucket {}/{} from {} -> {}", new Object[]{volumeName, bucketName, oldOwner, newOwner});
            return omClientResponse;
        }
        OMBucketSetOwnerRequest.LOG.error("Setting Owner failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        omMetrics.incNumBucketUpdateFails();
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMBucketSetOwnerRequest.java", OMBucketSetOwnerRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.bucket.OMBucketSetOwnerRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 64);
    }
}

