/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.om.helpers.OMAuditLogger;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public interface RequestAuditor {
    public OMAuditLogger.Builder buildAuditMessage(AuditAction var1, Map<String, String> var2, Throwable var3, OzoneManagerProtocolProtos.UserInfo var4);

    public Map<String, String> buildVolumeAuditMap(String var1);

    default public Map<String, String> buildLightKeyArgsAuditMap(OzoneManagerProtocolProtos.KeyArgs keyArgs) {
        if (keyArgs == null) {
            return new HashMap<String, String>(0);
        }
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", keyArgs.getVolumeName());
        auditMap.put("bucket", keyArgs.getBucketName());
        auditMap.put("key", keyArgs.getKeyName());
        return auditMap;
    }

    default public Map<String, String> buildKeyArgsAuditMap(OzoneManagerProtocolProtos.KeyArgs keyArgs) {
        if (keyArgs == null) {
            return new HashMap<String, String>(0);
        }
        Map<String, String> auditMap = this.buildLightKeyArgsAuditMap(keyArgs);
        auditMap.put("dataSize", String.valueOf(keyArgs.getDataSize()));
        if (keyArgs.hasType()) {
            auditMap.put("replicationType", keyArgs.getType().name());
        }
        if (keyArgs.hasFactor() && keyArgs.getFactor() != HddsProtos.ReplicationFactor.ZERO) {
            auditMap.put("replicationFactor", keyArgs.getFactor().name());
        }
        if (keyArgs.hasEcReplicationConfig()) {
            auditMap.put("replicationConfig", ECReplicationConfig.toString((HddsProtos.ECReplicationConfig)keyArgs.getEcReplicationConfig()));
        }
        if (keyArgs.hasExpectedDataGeneration()) {
            auditMap.put("rewriteGeneration", String.valueOf(keyArgs.getExpectedDataGeneration()));
        }
        for (HddsProtos.KeyValue item : keyArgs.getMetadataList()) {
            if (!"ETag".equals(item.getKey())) continue;
            auditMap.put("ETag", item.getValue());
        }
        return auditMap;
    }
}

