/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OmMetadataReader;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;

public final class OzoneAclUtils {
    private static OMMultiTenantManager multiTenantManager;

    private OzoneAclUtils() {
    }

    public static void setOMMultiTenantManager(OMMultiTenantManager tenantManager) {
        multiTenantManager = tenantManager;
    }

    public static String accessIdToUserPrincipal(String accessID) {
        if (multiTenantManager == null) {
            return accessID;
        }
        String principal = multiTenantManager.getUserNameGivenAccessId(accessID);
        if (principal == null) {
            principal = accessID;
        }
        return principal;
    }

    public static void checkAllAcls(OmMetadataReader omMetadataReader, OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key, String volOwner, String bucketOwner, UserGroupInformation user, InetAddress remoteAddress, String hostName) throws IOException {
        switch (resType) {
            case VOLUME: {
                omMetadataReader.checkAcls(resType, storeType, aclType, vol, bucket, key, user, remoteAddress, hostName, true, volOwner);
                break;
            }
            case BUCKET: 
            case KEY: 
            case PREFIX: {
                if (OzoneAclUtils.isOwner(user, volOwner)) {
                    omMetadataReader.checkAcls(resType, storeType, aclType, vol, bucket, key, user, remoteAddress, hostName, true, volOwner);
                    break;
                }
                IAccessAuthorizer.ACLType parentAclRight = IAccessAuthorizer.ACLType.READ;
                if (omMetadataReader.isNativeAuthorizerEnabled() && resType == OzoneObj.ResourceType.BUCKET) {
                    parentAclRight = OzoneAclUtils.getParentNativeAcl(aclType, resType);
                }
                omMetadataReader.checkAcls(OzoneObj.ResourceType.VOLUME, storeType, parentAclRight, vol, bucket, key, user, remoteAddress, hostName, true, volOwner);
                omMetadataReader.checkAcls(resType, storeType, aclType, vol, bucket, key, user, remoteAddress, hostName, true, bucketOwner);
                break;
            }
            default: {
                throw new OMException("Unexpected object type:" + resType, OMException.ResultCodes.INVALID_REQUEST);
            }
        }
    }

    public static IAccessAuthorizer.ACLType getParentNativeAcl(IAccessAuthorizer.ACLType aclRight, OzoneObj.ResourceType resType) {
        if (resType == OzoneObj.ResourceType.VOLUME) {
            return IAccessAuthorizer.ACLType.NONE;
        }
        if (resType == OzoneObj.ResourceType.BUCKET) {
            if (aclRight == IAccessAuthorizer.ACLType.CREATE) {
                return IAccessAuthorizer.ACLType.WRITE;
            }
            return IAccessAuthorizer.ACLType.READ;
        }
        IAccessAuthorizer.ACLType parentAclRight = aclRight;
        if (aclRight == IAccessAuthorizer.ACLType.CREATE) {
            parentAclRight = IAccessAuthorizer.ACLType.WRITE;
        } else if (aclRight == IAccessAuthorizer.ACLType.READ_ACL || aclRight == IAccessAuthorizer.ACLType.LIST || aclRight == IAccessAuthorizer.ACLType.WRITE_ACL || aclRight == IAccessAuthorizer.ACLType.DELETE) {
            parentAclRight = IAccessAuthorizer.ACLType.READ;
        }
        return parentAclRight;
    }

    private static boolean isOwner(UserGroupInformation callerUgi, String ownerName) {
        return ownerName != null && ownerName.equals(callerUgi.getShortUserName());
    }
}

