/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

public class OMPerformanceMetrics {
    private static final String SOURCE_NAME = OMPerformanceMetrics.class.getSimpleName();
    @Metric(about="Overall lookupKey in nanoseconds")
    private MutableRate lookupLatencyNs;
    @Metric(about="Read key info from meta in nanoseconds")
    private MutableRate lookupReadKeyInfoLatencyNs;
    @Metric(about="Block token generation latency in nanoseconds")
    private MutableRate lookupGenerateBlockTokenLatencyNs;
    @Metric(about="Refresh location nanoseconds")
    private MutableRate lookupRefreshLocationLatencyNs;
    @Metric(about="ACLs check nanoseconds")
    private MutableRate lookupAclCheckLatencyNs;
    @Metric(about="resolveBucketLink latency nanoseconds")
    private MutableRate lookupResolveBucketLatencyNs;
    @Metric(about="Overall getKeyInfo in nanoseconds")
    private MutableRate getKeyInfoLatencyNs;
    @Metric(about="Read key info from db in getKeyInfo")
    private MutableRate getKeyInfoReadKeyInfoLatencyNs;
    @Metric(about="Block token generation latency in getKeyInfo")
    private MutableRate getKeyInfoGenerateBlockTokenLatencyNs;
    @Metric(about="Refresh location latency in getKeyInfo")
    private MutableRate getKeyInfoRefreshLocationLatencyNs;
    @Metric(about="ACLs check in getKeyInfo")
    private MutableRate getKeyInfoAclCheckLatencyNs;
    @Metric(about="Sort datanodes latency in getKeyInfo")
    private MutableRate getKeyInfoSortDatanodesLatencyNs;
    @Metric(about="resolveBucketLink latency in getKeyInfo")
    private MutableRate getKeyInfoResolveBucketLatencyNs;
    @Metric(about="s3VolumeInfo latency nanoseconds")
    private MutableRate s3VolumeContextLatencyNs;
    @Metric(about="Client requests forcing container info cache refresh")
    private MutableRate forceContainerCacheRefresh;
    @Metric(about="checkAccess latency in nanoseconds")
    private MutableRate checkAccessLatencyNs;
    @Metric(about="listKeys latency in nanoseconds")
    private MutableRate listKeysLatencyNs;
    @Metric(about="Validate request latency in nano seconds")
    private MutableRate validateRequestLatencyNs;
    @Metric(about="Validate response latency in nano seconds")
    private MutableRate validateResponseLatencyNs;
    @Metric(about="PreExecute latency in nano seconds")
    private MutableRate preExecuteLatencyNs;
    @Metric(about="Ratis latency in nano seconds")
    private MutableRate submitToRatisLatencyNs;
    @Metric(about="Convert om request to ratis request nano seconds")
    private MutableRate createRatisRequestLatencyNs;
    @Metric(about="Convert ratis response to om response nano seconds")
    private MutableRate createOmResponseLatencyNs;
    @Metric(about="Ratis local command execution latency in nano seconds")
    private MutableRate validateAndUpdateCacheLatencyNs;
    @Metric(about="average pagination for listKeys")
    private MutableRate listKeysAveragePagination;
    @Metric(about="ops per second for listKeys")
    private MutableGaugeFloat listKeysOpsPerSec;
    @Metric(about="ACLs check latency in listKeys")
    private MutableRate listKeysAclCheckLatencyNs;
    @Metric(about="resolveBucketLink latency in listKeys")
    private MutableRate listKeysResolveBucketLatencyNs;
    @Metric(about="deleteKeyFailure latency in nano seconds")
    private MutableRate deleteKeyFailureLatencyNs;
    @Metric(about="deleteKeySuccess latency in nano seconds")
    private MutableRate deleteKeySuccessLatencyNs;
    @Metric(about="resolveBucketLink latency in deleteKeys")
    private MutableRate deleteKeysResolveBucketLatencyNs;
    @Metric(about="ACLs check latency in deleteKeys")
    private MutableRate deleteKeysAclCheckLatencyNs;
    @Metric(about="resolveBucketLink and ACLs check latency in deleteKey")
    private MutableRate deleteKeyResolveBucketAndAclCheckLatencyNs;
    @Metric(about="readFromRockDb latency in listKeys")
    private MutableRate listKeysReadFromRocksDbLatencyNs;
    @Metric(about="resolveBucketLink latency in getObjectTagging")
    private MutableRate getObjectTaggingResolveBucketLatencyNs;
    @Metric(about="ACLs check in getObjectTagging")
    private MutableRate getObjectTaggingAclCheckLatencyNs;
    @Metric(about="Latency of each iteration of DirectoryDeletingService in ms")
    private MutableGaugeLong directoryDeletingServiceLatencyMs;
    @Metric(about="Latency of each iteration of KeyDeletingService in ms")
    private MutableGaugeLong keyDeletingServiceLatencyMs;
    @Metric(about="Latency of each iteration of OpenKeyCleanupService in ms")
    private MutableGaugeLong openKeyCleanupServiceLatencyMs;

    public static OMPerformanceMetrics register() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OMPerformanceMetrics)ms.register(SOURCE_NAME, "OzoneManager Request Performance", (Object)new OMPerformanceMetrics());
    }

    public static void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void addLookupLatency(long latencyInNs) {
        this.lookupLatencyNs.add(latencyInNs);
    }

    MutableRate getLookupRefreshLocationLatencyNs() {
        return this.lookupRefreshLocationLatencyNs;
    }

    MutableRate getLookupGenerateBlockTokenLatencyNs() {
        return this.lookupGenerateBlockTokenLatencyNs;
    }

    MutableRate getLookupReadKeyInfoLatencyNs() {
        return this.lookupReadKeyInfoLatencyNs;
    }

    MutableRate getLookupAclCheckLatencyNs() {
        return this.lookupAclCheckLatencyNs;
    }

    public void addS3VolumeContextLatencyNs(long latencyInNs) {
        this.s3VolumeContextLatencyNs.add(latencyInNs);
    }

    MutableRate getLookupResolveBucketLatencyNs() {
        return this.lookupResolveBucketLatencyNs;
    }

    public void addGetKeyInfoLatencyNs(long value) {
        this.getKeyInfoLatencyNs.add(value);
    }

    MutableRate getGetKeyInfoAclCheckLatencyNs() {
        return this.getKeyInfoAclCheckLatencyNs;
    }

    MutableRate getGetKeyInfoGenerateBlockTokenLatencyNs() {
        return this.getKeyInfoGenerateBlockTokenLatencyNs;
    }

    MutableRate getGetKeyInfoReadKeyInfoLatencyNs() {
        return this.getKeyInfoReadKeyInfoLatencyNs;
    }

    MutableRate getGetKeyInfoRefreshLocationLatencyNs() {
        return this.getKeyInfoRefreshLocationLatencyNs;
    }

    MutableRate getGetKeyInfoResolveBucketLatencyNs() {
        return this.getKeyInfoResolveBucketLatencyNs;
    }

    MutableRate getGetKeyInfoSortDatanodesLatencyNs() {
        return this.getKeyInfoSortDatanodesLatencyNs;
    }

    public void setForceContainerCacheRefresh(boolean value) {
        this.forceContainerCacheRefresh.add(value ? 1L : 0L);
    }

    public void setCheckAccessLatencyNs(long latencyInNs) {
        this.checkAccessLatencyNs.add(latencyInNs);
    }

    public void addListKeysLatencyNs(long latencyInNs) {
        this.listKeysLatencyNs.add(latencyInNs);
    }

    public MutableRate getValidateRequestLatencyNs() {
        return this.validateRequestLatencyNs;
    }

    public MutableRate getValidateResponseLatencyNs() {
        return this.validateResponseLatencyNs;
    }

    public MutableRate getPreExecuteLatencyNs() {
        return this.preExecuteLatencyNs;
    }

    public MutableRate getSubmitToRatisLatencyNs() {
        return this.submitToRatisLatencyNs;
    }

    public MutableRate getCreateRatisRequestLatencyNs() {
        return this.createRatisRequestLatencyNs;
    }

    public MutableRate getCreateOmResponseLatencyNs() {
        return this.createOmResponseLatencyNs;
    }

    public MutableRate getValidateAndUpdateCacheLatencyNs() {
        return this.validateAndUpdateCacheLatencyNs;
    }

    public void setListKeysAveragePagination(long keyCount) {
        this.listKeysAveragePagination.add(keyCount);
    }

    public void setListKeysOpsPerSec(float opsPerSec) {
        this.listKeysOpsPerSec.set(opsPerSec);
    }

    MutableRate getListKeysAclCheckLatencyNs() {
        return this.listKeysAclCheckLatencyNs;
    }

    MutableRate getListKeysResolveBucketLatencyNs() {
        return this.listKeysResolveBucketLatencyNs;
    }

    public void setDeleteKeyFailureLatencyNs(long latencyInNs) {
        this.deleteKeyFailureLatencyNs.add(latencyInNs);
    }

    public void setDeleteKeySuccessLatencyNs(long latencyInNs) {
        this.deleteKeySuccessLatencyNs.add(latencyInNs);
    }

    public void setDeleteKeysResolveBucketLatencyNs(long latencyInNs) {
        this.deleteKeysResolveBucketLatencyNs.add(latencyInNs);
    }

    public void setDeleteKeysAclCheckLatencyNs(long latencyInNs) {
        this.deleteKeysAclCheckLatencyNs.add(latencyInNs);
    }

    public MutableRate getDeleteKeyResolveBucketAndAclCheckLatencyNs() {
        return this.deleteKeyResolveBucketAndAclCheckLatencyNs;
    }

    public void addListKeysReadFromRocksDbLatencyNs(long latencyInNs) {
        this.listKeysReadFromRocksDbLatencyNs.add(latencyInNs);
    }

    public MutableRate getGetObjectTaggingResolveBucketLatencyNs() {
        return this.getObjectTaggingResolveBucketLatencyNs;
    }

    public MutableRate getGetObjectTaggingAclCheckLatencyNs() {
        return this.getObjectTaggingAclCheckLatencyNs;
    }

    public void addGetObjectTaggingLatencyNs(long latencyInNs) {
        this.getObjectTaggingAclCheckLatencyNs.add(latencyInNs);
    }

    public void setDirectoryDeletingServiceLatencyMs(long latencyInMs) {
        this.directoryDeletingServiceLatencyMs.set(latencyInMs);
    }

    public void setKeyDeletingServiceLatencyMs(long latencyInMs) {
        this.keyDeletingServiceLatencyMs.set(latencyInMs);
    }

    public void setOpenKeyCleanupServiceLatencyMs(long latencyInMs) {
        this.openKeyCleanupServiceLatencyMs.set(latencyInMs);
    }
}

