/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="assign-admin", aliases={"assignadmin"}, description={"Assign admin role to accessIds in a tenant"})
public class TenantAssignAdminHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Access ID"}, arity="1..1")
    private String accessId;
    @CommandLine.Option(names={"-t", "--tenant"}, description={"Tenant name"})
    private String tenantId;
    @CommandLine.Option(names={"-d", "--delegated"}, defaultValue="false", description={"Assign delegated admin. If unspecified, assign non-delegated admin (the default)"})
    private boolean delegated;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        client.getObjectStore().tenantAssignAdmin(this.accessId, this.tenantId, this.delegated);
        if (this.isVerbose()) {
            ObjectNode obj = JsonUtils.createObjectNode(null);
            obj.put("accessId", this.accessId);
            obj.put("tenantId", this.tenantId);
            obj.put("isAdmin", true);
            obj.put("isDelegatedAdmin", this.delegated);
            String jsonString = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)obj);
            this.out().println(jsonString);
        }
    }
}

