/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneSnapshot;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Returns information about an existing snapshot"})
public class InfoSnapshotHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Parameters(description={"Snapshot name"}, index="1", arity="1")
    private String snapshotName;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        OzoneSnapshot ozoneSnapshot = client.getObjectStore().getSnapshotInfo(volumeName, bucketName, this.snapshotName);
        if (this.isVerbose()) {
            this.err().printf("Snapshot info for snapshot: %s under o3://%s/%s %n ", this.snapshotName, volumeName, bucketName);
        }
        this.printObjectAsJson(ozoneSnapshot);
    }
}

