/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a snapshot"})
public class CreateSnapshotHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Parameters(description={"Snapshot name (Optional)"}, index="1", arity="0..1")
    private String snapshotName;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        OmUtils.validateSnapshotName((String)this.snapshotName);
        String newName = client.getObjectStore().createSnapshot(volumeName, bucketName, this.snapshotName);
        if (this.isVerbose()) {
            this.out().format("Created snapshot '%s' under '%s/%s'.%n", newName, volumeName, bucketName);
        }
    }
}

