/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import com.google.common.primitives.Longs;
import com.google.protobuf.MessageLite;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.FixedLengthStringCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.utils.db.DatanodeDBProfile;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeDBDefinition;

public class DatanodeSchemaThreeDBDefinition
extends AbstractDatanodeDBDefinition
implements DBDefinition.WithMapInterface {
    public static final DBColumnFamilyDefinition<String, BlockData> BLOCK_DATA = new DBColumnFamilyDefinition("block_data", (Codec)FixedLengthStringCodec.get(), BlockData.getCodec());
    public static final DBColumnFamilyDefinition<String, Long> METADATA = new DBColumnFamilyDefinition("metadata", (Codec)FixedLengthStringCodec.get(), (Codec)LongCodec.get());
    public static final DBColumnFamilyDefinition<String, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> DELETE_TRANSACTION = new DBColumnFamilyDefinition("delete_txns", (Codec)FixedLengthStringCodec.get(), Proto2Codec.get((MessageLite)StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.getDefaultInstance()));
    public static final DBColumnFamilyDefinition<String, Long> FINALIZE_BLOCKS = new DBColumnFamilyDefinition("finalize_blocks", (Codec)FixedLengthStringCodec.get(), (Codec)LongCodec.get());
    public static final DBColumnFamilyDefinition<String, BlockData> LAST_CHUNK_INFO = new DBColumnFamilyDefinition("last_chunk_info", (Codec)FixedLengthStringCodec.get(), BlockData.getCodec());
    private static String separator = "";
    private static final Map<String, DBColumnFamilyDefinition<?, ?>> COLUMN_FAMILIES = DBColumnFamilyDefinition.newUnmodifiableMap((DBColumnFamilyDefinition[])new DBColumnFamilyDefinition[]{BLOCK_DATA, METADATA, DELETE_TRANSACTION, FINALIZE_BLOCKS, LAST_CHUNK_INFO});

    public DatanodeSchemaThreeDBDefinition(String dbPath, ConfigurationSource config) {
        super(dbPath, config);
        DatanodeConfiguration dc = (DatanodeConfiguration)((Object)config.getObject(DatanodeConfiguration.class));
        this.setSeparator(dc.getContainerSchemaV3KeySeparator());
        DatanodeDBProfile dbProfile = DatanodeDBProfile.getProfile((DBProfile)config.getEnum("hdds.db.profile", (Enum)DBStoreBuilder.HDDS_DEFAULT_DB_PROFILE));
        ManagedColumnFamilyOptions cfOptions = dbProfile.getColumnFamilyOptions(config);
        cfOptions.useFixedLengthPrefixExtractor(DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixLength());
        BLOCK_DATA.setCfOptions(cfOptions);
        METADATA.setCfOptions(cfOptions);
        DELETE_TRANSACTION.setCfOptions(cfOptions);
        FINALIZE_BLOCKS.setCfOptions(cfOptions);
        LAST_CHUNK_INFO.setCfOptions(cfOptions);
    }

    public Map<String, DBColumnFamilyDefinition<?, ?>> getMap() {
        return COLUMN_FAMILIES;
    }

    @Override
    public DBColumnFamilyDefinition<String, BlockData> getBlockDataColumnFamily() {
        return BLOCK_DATA;
    }

    @Override
    public DBColumnFamilyDefinition<String, Long> getMetadataColumnFamily() {
        return METADATA;
    }

    @Override
    public DBColumnFamilyDefinition<String, BlockData> getLastChunkInfoColumnFamily() {
        return LAST_CHUNK_INFO;
    }

    public DBColumnFamilyDefinition<String, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeleteTransactionsColumnFamily() {
        return DELETE_TRANSACTION;
    }

    @Override
    public DBColumnFamilyDefinition<String, Long> getFinalizeBlocksColumnFamily() {
        return FINALIZE_BLOCKS;
    }

    public static int getContainerKeyPrefixLength() {
        return FixedLengthStringCodec.string2Bytes((String)DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(0L)).length;
    }

    public static String getContainerKeyPrefix(long containerID) {
        return FixedLengthStringCodec.bytes2String((byte[])Longs.toByteArray((long)containerID)) + separator;
    }

    public static byte[] getContainerKeyPrefixBytes(long containerID) {
        return FixedLengthStringCodec.string2Bytes((String)DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID));
    }

    public static String getKeyWithoutPrefix(String keyWithPrefix) {
        return keyWithPrefix.substring(keyWithPrefix.indexOf(separator) + 1);
    }

    public static long getContainerId(String key) {
        int index = DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixLength();
        String cid = key.substring(0, index);
        return Longs.fromByteArray((byte[])FixedLengthStringCodec.string2Bytes((String)cid));
    }

    private void setSeparator(String keySeparator) {
        separator = keySeparator;
    }
}

