/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.util.concurrent.Striped;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedBufferManager {
    private static ConcurrentHashMap<String, WeakReference<ByteBuffer>> mappedBuffers = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(MappedBufferManager.class);
    private final Semaphore semaphore;
    private final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);
    private final Striped<Lock> lock;

    public MappedBufferManager(int capacity) {
        this.semaphore = new Semaphore(capacity);
        this.lock = Striped.lazyWeakLock((int)1024);
    }

    public boolean getQuota(int permits) {
        boolean ret = this.semaphore.tryAcquire(permits);
        if (ret) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("quota is decreased by {} to total {}", (Object)permits, (Object)this.semaphore.availablePermits());
            }
        } else if (this.cleanupInProgress.compareAndSet(false, true)) {
            CompletableFuture.runAsync(() -> {
                int p = 0;
                try {
                    for (String key : mappedBuffers.keySet()) {
                        ByteBuffer buf = (ByteBuffer)mappedBuffers.get(key).get();
                        if (buf != null) continue;
                        mappedBuffers.remove(key);
                        ++p;
                    }
                    if (p > 0) {
                        this.releaseQuota(p);
                    }
                }
                finally {
                    this.cleanupInProgress.set(false);
                }
            });
        }
        return ret;
    }

    public void releaseQuota(int permits) {
        this.semaphore.release(permits);
        if (LOG.isDebugEnabled()) {
            LOG.debug("quota is increased by {} to total {}", (Object)permits, (Object)this.semaphore.availablePermits());
        }
    }

    public int availableQuota() {
        return this.semaphore.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer computeIfAbsent(String file, long position, long size, Supplier<ByteBuffer> supplier) {
        String key = file + "-" + position + "-" + size;
        Lock fileLock = (Lock)this.lock.get((Object)key);
        fileLock.lock();
        try {
            WeakReference<ByteBuffer> refer = mappedBuffers.get(key);
            if (refer != null && refer.get() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("find buffer for key {}", (Object)key);
                }
                this.releaseQuota(1);
                ByteBuffer byteBuffer = (ByteBuffer)refer.get();
                return byteBuffer;
            }
            ByteBuffer buffer = supplier.get();
            if (buffer != null) {
                mappedBuffers.put(key, new WeakReference<ByteBuffer>(buffer));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("add buffer for key {}", (Object)key);
                }
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            fileLock.unlock();
        }
    }
}

