/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.ToLongFunction;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferToByteString;
import org.apache.hadoop.ozone.common.utils.BufferUtils;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.keyvalue.impl.MappedBufferManager;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.handler.stream.ChunkedNioFile;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkUtils.class);
    private static final Set<? extends OpenOption> WRITE_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.SPARSE));
    public static final Set<? extends OpenOption> READ_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ));
    public static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    public static final int DEFAULT_FILE_LOCK_STRIPED_SIZE = 2048;
    private static Striped<ReadWriteLock> fileStripedLock = Striped.readWriteLock((int)2048);

    private ChunkUtils() {
    }

    @VisibleForTesting
    public static void setStripedLock(Striped<ReadWriteLock> stripedLock) {
        fileStripedLock = stripedLock;
    }

    private static ReadWriteLock getFileLock(Path filePath) {
        return (ReadWriteLock)fileStripedLock.get((Object)filePath);
    }

    private static AutoCloseableLock getFileReadLock(Path filePath) {
        return AutoCloseableLock.acquire((Lock)ChunkUtils.getFileLock(filePath).readLock());
    }

    private static AutoCloseableLock getFileWriteLock(Path filePath) {
        return AutoCloseableLock.acquire((Lock)ChunkUtils.getFileLock(filePath).writeLock());
    }

    public static void writeData(File file, ChunkBuffer data, long offset, long len, HddsVolume volume, boolean sync) throws StorageContainerException {
        ChunkUtils.writeData(data, file.getName(), offset, len, volume, (ChunkBuffer d) -> ChunkUtils.writeDataToFile(file, d, offset, sync));
    }

    public static void writeData(FileChannel file, String filename, ChunkBuffer data, long offset, long len, HddsVolume volume) throws StorageContainerException {
        ChunkUtils.writeData(data, filename, offset, len, volume, (ChunkBuffer d) -> ChunkUtils.writeDataToChannel(file, d, offset));
    }

    private static void writeData(ChunkBuffer data, String filename, long offset, long len, HddsVolume volume, ToLongFunction<ChunkBuffer> writer) throws StorageContainerException {
        long bytesWritten;
        ChunkUtils.validateBufferSize(len, data.remaining());
        long startTime = Time.monotonicNow();
        try {
            bytesWritten = writer.applyAsLong(data);
        }
        catch (UncheckedIOException e) {
            if (!(e.getCause() instanceof InterruptedIOException)) {
                StorageVolumeUtil.onFailure(volume);
            }
            throw ChunkUtils.wrapInStorageContainerException(e.getCause());
        }
        long endTime = Time.monotonicNow();
        long elapsed = endTime - startTime;
        if (volume != null) {
            volume.getVolumeIOStats().incWriteTime(elapsed);
            volume.getVolumeIOStats().incWriteOpCount();
            volume.getVolumeIOStats().incWriteBytes(bytesWritten);
        }
        LOG.debug("Written {} bytes at offset {} to {} in {} ms", new Object[]{bytesWritten, offset, filename, elapsed});
        ChunkUtils.validateWriteSize(len, bytesWritten);
    }

    /*
     * Exception decompiling
     */
    private static long writeDataToFile(File file, ChunkBuffer data, long offset, boolean sync) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long writeDataToChannel(FileChannel channel, ChunkBuffer data, long offset) {
        try {
            channel.position(offset);
            return data.writeTo((GatheringByteChannel)channel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static ChunkBuffer readData(long len, int bufferCapacity, File file, long off, HddsVolume volume, int readMappedBufferThreshold, boolean mmapEnabled, MappedBufferManager mappedBufferManager) throws StorageContainerException {
        if (mmapEnabled && len > (long)readMappedBufferThreshold && bufferCapacity > readMappedBufferThreshold) {
            return ChunkUtils.readData(file, bufferCapacity, off, len, volume, mappedBufferManager);
        }
        if (len == 0L) {
            return ChunkBuffer.wrap(Collections.emptyList());
        }
        ByteBuffer[] buffers = BufferUtils.assignByteBuffers((long)len, (int)bufferCapacity);
        ChunkUtils.readData(file, off, len, (CheckedFunction<FileChannel, Long, Exception>)((CheckedFunction)c -> c.position(off).read(buffers)), volume);
        Arrays.stream(buffers).forEach(Buffer::flip);
        return ChunkBuffer.wrap(Arrays.asList(buffers));
    }

    private static void readData(File file, long offset, long len, CheckedFunction<FileChannel, Long, Exception> readMethod, HddsVolume volume) throws StorageContainerException {
        long bytesRead;
        Path path = file.toPath();
        long startTime = Time.monotonicNow();
        try (AutoCloseableLock ignoredLock = ChunkUtils.getFileReadLock(path);
             FileChannel channel = FileChannel.open(path, READ_OPTIONS, NO_ATTRIBUTES);){
            bytesRead = (Long)readMethod.apply((Object)channel);
        }
        catch (Exception e) {
            StorageVolumeUtil.onFailure(volume);
            throw ChunkUtils.wrapInStorageContainerException(e);
        }
        long endTime = Time.monotonicNow();
        if (volume != null) {
            volume.getVolumeIOStats().incReadTime(endTime - startTime);
            volume.getVolumeIOStats().incReadOpCount();
            volume.getVolumeIOStats().incReadBytes(bytesRead);
        }
        LOG.debug("Read {} bytes starting at offset {} from {}", new Object[]{bytesRead, offset, file});
        ChunkUtils.validateReadSize(len, bytesRead);
    }

    private static ChunkBuffer readData(File file, int chunkSize, long offset, long length, HddsVolume volume, MappedBufferManager mappedBufferManager) throws StorageContainerException {
        int bufferNum = Math.toIntExact((length - 1L) / (long)chunkSize) + 1;
        if (!mappedBufferManager.getQuota(bufferNum)) {
            ByteBuffer[] buffers = BufferUtils.assignByteBuffers((long)length, (int)chunkSize);
            ChunkUtils.readData(file, offset, length, (CheckedFunction<FileChannel, Long, Exception>)((CheckedFunction)c -> c.position(offset).read(buffers)), volume);
            Arrays.stream(buffers).forEach(Buffer::flip);
            return ChunkBuffer.wrap(Arrays.asList(buffers));
        }
        try {
            ArrayList buffers = new ArrayList(bufferNum);
            ChunkUtils.readData(file, offset, length, (CheckedFunction<FileChannel, Long, Exception>)((CheckedFunction)channel -> {
                long readLen;
                ByteBuffer mapped;
                for (readLen = 0L; readLen < length; readLen += (long)mapped.remaining()) {
                    int n = Math.toIntExact(Math.min(length - readLen, (long)chunkSize));
                    long finalOffset = offset + readLen;
                    AtomicReference exception = new AtomicReference();
                    mapped = mappedBufferManager.computeIfAbsent(file.getAbsolutePath(), finalOffset, n, () -> {
                        try {
                            return channel.map(FileChannel.MapMode.READ_ONLY, finalOffset, n);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to map file {} with offset {} and length {}", new Object[]{file, finalOffset, n});
                            exception.set(e);
                            return null;
                        }
                    });
                    if (mapped == null) {
                        throw (IOException)exception.get();
                    }
                    LOG.debug("mapped: offset={}, readLen={}, n={}, {}", new Object[]{finalOffset, readLen, n, mapped.getClass()});
                    buffers.add(mapped);
                }
                return readLen;
            }), volume);
            return ChunkBuffer.wrap(buffers);
        }
        catch (Throwable e) {
            mappedBufferManager.releaseQuota(bufferNum);
            throw e;
        }
    }

    public static ChunkBufferToByteString readData(File file, long chunkSize, long offset, long length, HddsVolume volume, DispatcherContext context) throws StorageContainerException {
        List<ByteBuf> buffers = ChunkUtils.readDataNettyChunkedNioFile(file, Math.toIntExact(chunkSize), offset, length, volume);
        ChunkBufferToByteString b = ChunkBufferToByteString.wrap(buffers);
        context.setReleaseMethod(() -> ((ChunkBufferToByteString)b).release());
        return b;
    }

    private static List<ByteBuf> readDataNettyChunkedNioFile(File file, int chunkSize, long offset, long length, HddsVolume volume) throws StorageContainerException {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(Math.toIntExact((length - 1L) / (long)chunkSize) + 1);
        ChunkUtils.readData(file, offset, length, (CheckedFunction<FileChannel, Long, Exception>)((CheckedFunction)channel -> {
            long readLen;
            ByteBuf buf;
            ChunkedNioFile f = new ChunkedNioFile(channel, offset, length, chunkSize);
            for (readLen = 0L; readLen < length; readLen += (long)buf.readableBytes()) {
                buf = f.readChunk((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
                buffers.add(buf);
            }
            return readLen;
        }), volume);
        return buffers;
    }

    public static boolean validateChunkForOverwrite(File chunkFile, ChunkInfo info) {
        if (ChunkUtils.isOverWriteRequested(chunkFile, info)) {
            if (!ChunkUtils.isOverWritePermitted(info)) {
                LOG.warn("Duplicate write chunk request. Chunk overwrite without explicit request. {}", (Object)info);
            }
            return true;
        }
        return false;
    }

    public static boolean validateChunkForOverwrite(FileChannel chunkFile, ChunkInfo info) {
        if (ChunkUtils.isOverWriteRequested(chunkFile, info)) {
            if (!ChunkUtils.isOverWritePermitted(info)) {
                LOG.warn("Duplicate write chunk request. Chunk overwrite without explicit request. {}", (Object)info);
            }
            return true;
        }
        return false;
    }

    public static boolean isOverWriteRequested(File chunkFile, ChunkInfo chunkInfo) {
        if (!chunkFile.exists()) {
            return false;
        }
        long offset = chunkInfo.getOffset();
        return offset < chunkFile.length();
    }

    public static boolean isOverWriteRequested(FileChannel channel, ChunkInfo chunkInfo) {
        long fileLen;
        try {
            fileLen = channel.size();
        }
        catch (IOException e) {
            String msg = "IO error encountered while getting the file size";
            LOG.error(msg, (Object)e.getMessage());
            throw new UncheckedIOException("IO error encountered while getting the file size for ", e);
        }
        long offset = chunkInfo.getOffset();
        return offset < fileLen;
    }

    private static boolean isOverWritePermitted(ChunkInfo chunkInfo) {
        String overWrite = chunkInfo.getMetadata("OverWriteRequested");
        return Boolean.parseBoolean(overWrite);
    }

    public static void verifyChunkFileExists(File file) throws StorageContainerException {
        if (!file.exists()) {
            throw new StorageContainerException("Chunk file not found: " + file.getPath(), ContainerProtos.Result.UNABLE_TO_FIND_CHUNK);
        }
    }

    private static void closeFile(FileChannel file, boolean sync) {
        if (file != null) {
            try {
                if (sync) {
                    file.force(true);
                }
                file.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static void validateReadSize(long expected, long actual) throws StorageContainerException {
        ChunkUtils.checkSize("read", expected, actual, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
    }

    private static void validateWriteSize(long expected, long actual) throws StorageContainerException {
        ChunkUtils.checkSize("write", expected, actual, ContainerProtos.Result.INVALID_WRITE_SIZE);
    }

    public static void validateBufferSize(long expected, long actual) throws StorageContainerException {
        ChunkUtils.checkSize("buffer", expected, actual, ContainerProtos.Result.INVALID_WRITE_SIZE);
    }

    private static void checkSize(String of, long expected, long actual, ContainerProtos.Result code) throws StorageContainerException {
        if (actual != expected) {
            String err = String.format("Unexpected %s size. expected: %d, actual: %d", of, expected, actual);
            LOG.error(err);
            throw new StorageContainerException(err, code);
        }
    }

    public static void limitReadSize(long len) throws StorageContainerException {
        if (len > 0x2000000L) {
            String err = String.format("Oversize read. max: %d, actual: %d", 0x2000000, len);
            LOG.error(err);
            throw new StorageContainerException(err, ContainerProtos.Result.UNSUPPORTED_REQUEST);
        }
    }

    public static StorageContainerException wrapInStorageContainerException(Exception e) {
        ContainerProtos.Result result = ChunkUtils.translate(e);
        return new StorageContainerException((Throwable)e, result);
    }

    private static ContainerProtos.Result translate(Exception cause) {
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            return ContainerProtos.Result.UNABLE_TO_FIND_CHUNK;
        }
        if (cause instanceof IOException) {
            return ContainerProtos.Result.IO_EXCEPTION;
        }
        if (cause instanceof NoSuchAlgorithmException) {
            return ContainerProtos.Result.NO_SUCH_ALGORITHM;
        }
        return ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
    }

    public static void validateChunkSize(FileChannel fileChannel, ChunkInfo chunkInfo, String fileName) throws StorageContainerException {
        long fileLen;
        long offset = chunkInfo.getOffset();
        try {
            fileLen = fileChannel.size();
        }
        catch (IOException e) {
            throw new StorageContainerException("IO error encountered while getting the file size for " + fileName + " at offset " + offset, ContainerProtos.Result.CHUNK_FILE_INCONSISTENCY);
        }
        if (fileLen != offset) {
            throw new StorageContainerException("Chunk offset " + offset + " does not match length " + fileLen + " of blockFile " + fileName, ContainerProtos.Result.CHUNK_FILE_INCONSISTENCY);
        }
    }
}

