/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaThreeDBDefinition;
import org.yaml.snakeyaml.nodes.Tag;

public class KeyValueContainerData
extends ContainerData {
    public static final Tag KEYVALUE_YAML_TAG = new Tag("KeyValueContainerData");
    private static final List<String> KV_YAML_FIELDS = Lists.newArrayList();
    private String metadataPath;
    private String containerDBType = "RocksDB";
    private File dbFile = null;
    private String schemaVersion;
    private final AtomicLong numPendingDeletionBlocks;
    private long deleteTransactionId;
    private long blockCommitSequenceId;
    private final Set<Long> finalizedBlockSet;

    public KeyValueContainerData(long id, ContainerLayoutVersion layoutVersion, long size, String originPipelineId, String originNodeId) {
        super(ContainerProtos.ContainerType.KeyValueContainer, id, layoutVersion, size, originPipelineId, originNodeId);
        this.numPendingDeletionBlocks = new AtomicLong(0L);
        this.deleteTransactionId = 0L;
        this.finalizedBlockSet = ConcurrentHashMap.newKeySet();
    }

    public KeyValueContainerData(KeyValueContainerData source) {
        super(source);
        Preconditions.checkArgument((source.getContainerType() == ContainerProtos.ContainerType.KeyValueContainer ? 1 : 0) != 0);
        this.numPendingDeletionBlocks = new AtomicLong(0L);
        this.deleteTransactionId = 0L;
        this.schemaVersion = source.getSchemaVersion();
        this.finalizedBlockSet = ConcurrentHashMap.newKeySet();
    }

    public void setSchemaVersion(String version) {
        this.schemaVersion = version;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getSupportedSchemaVersionOrDefault() {
        String[] versions;
        for (String version : versions = new String[]{"1", "2", "3"}) {
            if (!this.hasSchema(version)) continue;
            return version;
        }
        throw new UnsupportedOperationException("No valid schema version found.");
    }

    public void setDbFile(File containerDbFile) {
        this.dbFile = containerDbFile;
    }

    public File getDbFile() {
        return this.dbFile;
    }

    public String getMetadataPath() {
        return this.metadataPath;
    }

    public void setMetadataPath(String path) {
        this.metadataPath = path;
    }

    @Override
    public String getContainerPath() {
        return new File(this.metadataPath).getParent();
    }

    @Override
    public long getBlockCommitSequenceId() {
        return this.blockCommitSequenceId;
    }

    public void updateBlockCommitSequenceId(long id) {
        this.blockCommitSequenceId = id;
    }

    public String getContainerDBType() {
        return this.containerDBType;
    }

    public void setContainerDBType(String containerDBType) {
        this.containerDBType = containerDBType;
    }

    public void incrPendingDeletionBlocks(long numBlocks) {
        this.numPendingDeletionBlocks.addAndGet(numBlocks);
    }

    public void decrPendingDeletionBlocks(long numBlocks) {
        this.numPendingDeletionBlocks.addAndGet(-1L * numBlocks);
    }

    public long getNumPendingDeletionBlocks() {
        return this.numPendingDeletionBlocks.get();
    }

    public void updateDeleteTransactionId(long transactionId) {
        this.deleteTransactionId = Math.max(transactionId, this.deleteTransactionId);
    }

    public long getDeleteTransactionId() {
        return this.deleteTransactionId;
    }

    public void addToFinalizedBlockSet(long localID) {
        this.finalizedBlockSet.add(localID);
    }

    public Set<Long> getFinalizedBlockSet() {
        return this.finalizedBlockSet;
    }

    public boolean isFinalizedBlockExist(long localID) {
        return this.finalizedBlockSet.contains(localID);
    }

    public void clearFinalizedBlock(DBHandle db) throws IOException {
        if (!this.finalizedBlockSet.isEmpty()) {
            Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
            try (BatchOperation batch = db.getStore().getBatchHandler().initBatchOperation();){
                db.getStore().getFinalizeBlocksTable().deleteBatchWithPrefix(batch, (Object)this.containerPrefix());
                db.getStore().getBatchHandler().commitBatchOperation(batch);
            }
            this.finalizedBlockSet.clear();
        }
    }

    @Override
    @JsonIgnore
    public ContainerProtos.ContainerDataProto getProtoBufMessage() {
        ContainerProtos.ContainerDataProto.Builder builder = ContainerProtos.ContainerDataProto.newBuilder();
        builder.setContainerID(this.getContainerID());
        builder.setContainerPath(this.getContainerPath());
        builder.setState(this.getState());
        builder.setBlockCount(this.getBlockCount());
        for (Map.Entry<String, String> entry : this.getMetadata().entrySet()) {
            ContainerProtos.KeyValue.Builder keyValBuilder = ContainerProtos.KeyValue.newBuilder();
            builder.addMetadata(keyValBuilder.setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        if (this.getBytesUsed() >= 0L) {
            builder.setBytesUsed(this.getBytesUsed());
        }
        if (this.getContainerType() != null) {
            builder.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        }
        return builder.build();
    }

    public static List<String> getYamlFields() {
        return Collections.unmodifiableList(KV_YAML_FIELDS);
    }

    public void updateAndCommitDBCounters(DBHandle db, BatchOperation batchOperation, int deletedBlockCount, long releasedBytes) throws IOException {
        Table<String, Long> metadataTable = db.getStore().getMetadataTable();
        metadataTable.putWithBatch(batchOperation, (Object)this.getBytesUsedKey(), (Object)(this.getBytesUsed() - releasedBytes));
        metadataTable.putWithBatch(batchOperation, (Object)this.getBlockCountKey(), (Object)(this.getBlockCount() - (long)deletedBlockCount));
        metadataTable.putWithBatch(batchOperation, (Object)this.getPendingDeleteBlockCountKey(), (Object)(this.getNumPendingDeletionBlocks() - (long)deletedBlockCount));
        db.getStore().getBatchHandler().commitBatchOperation(batchOperation);
    }

    public void resetPendingDeleteBlockCount(DBHandle db) throws IOException {
        this.numPendingDeletionBlocks.set(0L);
        Table<String, Long> metadataTable = db.getStore().getMetadataTable();
        metadataTable.put((Object)this.getPendingDeleteBlockCountKey(), (Object)0L);
    }

    public String getBlockKey(long localID) {
        return this.formatKey(Long.toString(localID));
    }

    public String getDeletingBlockKey(long localID) {
        return this.formatKey("#deleting#" + localID);
    }

    public String getDeleteTxnKey(long txnID) {
        return this.formatKey(Long.toString(txnID));
    }

    public String getLatestDeleteTxnKey() {
        return this.formatKey("#delTX");
    }

    public String getBcsIdKey() {
        return this.formatKey("#BCSID");
    }

    public String getBlockCountKey() {
        return this.formatKey("#BLOCKCOUNT");
    }

    public String getBytesUsedKey() {
        return this.formatKey("#BYTESUSED");
    }

    public String getPendingDeleteBlockCountKey() {
        return this.formatKey("#PENDINGDELETEBLOCKCOUNT");
    }

    public String getDeletingBlockKeyPrefix() {
        return this.formatKey("#deleting#");
    }

    public MetadataKeyFilters.KeyPrefixFilter getUnprefixedKeyFilter() {
        String schemaPrefix = this.containerPrefix();
        return new MetadataKeyFilters.KeyPrefixFilter().addFilter(schemaPrefix + "#", true);
    }

    public MetadataKeyFilters.KeyPrefixFilter getDeletingBlockKeyFilter() {
        return new MetadataKeyFilters.KeyPrefixFilter().addFilter(this.getDeletingBlockKeyPrefix());
    }

    public String startKeyEmpty() {
        if (this.hasSchema("3")) {
            return DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(this.getContainerID());
        }
        return null;
    }

    public String containerPrefix() {
        if (this.hasSchema("3")) {
            return DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(this.getContainerID());
        }
        return "";
    }

    private String formatKey(String key) {
        if (this.hasSchema("3")) {
            key = DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(this.getContainerID()) + key;
        }
        return key;
    }

    public boolean hasSchema(String version) {
        return KeyValueContainerUtil.isSameSchemaVersion(this.schemaVersion, version);
    }

    static {
        KV_YAML_FIELDS.addAll(YAML_FIELDS);
        KV_YAML_FIELDS.add("metadataPath");
        KV_YAML_FIELDS.add("chunksPath");
        KV_YAML_FIELDS.add("containerDBType");
        KV_YAML_FIELDS.add("schemaVersion");
    }
}

