/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ec.reconstruction;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.ReconstructECContainersCommand;

public class ECReconstructionCommandInfo {
    private final SortedMap<Integer, DatanodeDetails> sourceNodeMap;
    private final SortedMap<Integer, DatanodeDetails> targetNodeMap;
    private final long containerID;
    private final ECReplicationConfig ecReplicationConfig;
    private final ByteString missingContainerIndexes;
    private final long deadlineMsSinceEpoch;
    private final long term;

    public ECReconstructionCommandInfo(ReconstructECContainersCommand cmd) {
        this.containerID = cmd.getContainerID();
        this.ecReplicationConfig = cmd.getEcReplicationConfig();
        this.missingContainerIndexes = cmd.getMissingContainerIndexes();
        this.deadlineMsSinceEpoch = cmd.getDeadline();
        this.term = cmd.getTerm();
        this.sourceNodeMap = cmd.getSources().stream().collect(Collectors.toMap(ReconstructECContainersCommand.DatanodeDetailsAndReplicaIndex::getReplicaIndex, ReconstructECContainersCommand.DatanodeDetailsAndReplicaIndex::getDnDetails, (v1, v2) -> v1, TreeMap::new));
        this.targetNodeMap = IntStream.range(0, cmd.getTargetDatanodes().size()).boxed().collect(Collectors.toMap(i -> this.missingContainerIndexes.byteAt(i.intValue()), i -> cmd.getTargetDatanodes().get((int)i), (v1, v2) -> v1, TreeMap::new));
    }

    public long getDeadline() {
        return this.deadlineMsSinceEpoch;
    }

    public long getContainerID() {
        return this.containerID;
    }

    public ECReplicationConfig getEcReplicationConfig() {
        return this.ecReplicationConfig;
    }

    SortedMap<Integer, DatanodeDetails> getSourceNodeMap() {
        return Collections.unmodifiableSortedMap(this.sourceNodeMap);
    }

    SortedMap<Integer, DatanodeDetails> getTargetNodeMap() {
        return Collections.unmodifiableSortedMap(this.targetNodeMap);
    }

    public String toString() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reconstructECContainersCommand + ": containerID=" + this.containerID + ", replication=" + this.ecReplicationConfig.getReplication() + ", missingIndexes=" + StringUtils.bytes2String((ByteBuffer)this.missingContainerIndexes.asReadOnlyByteBuffer()) + ", sources=" + this.sourceNodeMap + ", targets=" + this.targetNodeMap;
    }

    public long getTerm() {
        return this.term;
    }
}

