/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.StorageVolumeChecker;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;

public final class ImmutableVolumeSet
implements VolumeSet {
    private final List<StorageVolume> volumes;

    public ImmutableVolumeSet(StorageVolume ... volumes) {
        this.volumes = ImmutableList.copyOf((Object[])volumes);
    }

    public ImmutableVolumeSet(Collection<? extends StorageVolume> volumes) {
        this.volumes = ImmutableList.copyOf(volumes);
    }

    @Override
    public List<StorageVolume> getVolumesList() {
        return this.volumes;
    }

    @Override
    public void checkAllVolumes(StorageVolumeChecker checker) throws IOException {
        try {
            checker.checkAllVolumes(this.volumes);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while running disk check", e);
        }
    }

    public void readLock() {
    }

    public void readUnlock() {
    }

    public void writeLock() {
    }

    public void writeUnlock() {
    }
}

