/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCommandInfo;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCoordinator;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCoordinatorTask;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.protocol.commands.ReconstructECContainersCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ReconstructECContainersCommandHandler
implements CommandHandler {
    private final ReplicationSupervisor supervisor;
    private final ECReconstructionCoordinator coordinator;
    private final ConfigurationSource conf;
    private String metricsName;

    public ReconstructECContainersCommandHandler(ConfigurationSource conf, ReplicationSupervisor supervisor, ECReconstructionCoordinator coordinator) {
        this.conf = conf;
        this.supervisor = supervisor;
        this.coordinator = coordinator;
    }

    @Override
    public void handle(SCMCommand<?> command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        ReconstructECContainersCommand ecContainersCommand = (ReconstructECContainersCommand)command;
        ECReconstructionCommandInfo reconstructionCommandInfo = new ECReconstructionCommandInfo(ecContainersCommand);
        ECReconstructionCoordinatorTask task = new ECReconstructionCoordinatorTask(this.coordinator, reconstructionCommandInfo);
        if (this.metricsName == null) {
            this.metricsName = task.getMetricName();
        }
        this.supervisor.addTask(task);
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reconstructECContainersCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.metricsName == null ? 0 : (int)this.supervisor.getReplicationRequestCount(this.metricsName);
    }

    @Override
    public long getAverageRunTime() {
        return this.metricsName == null ? 0L : (long)((int)this.supervisor.getReplicationRequestAvgTime(this.metricsName));
    }

    @Override
    public long getTotalRunTime() {
        return this.metricsName == null ? 0L : this.supervisor.getReplicationRequestTotalTime(this.metricsName);
    }

    @Override
    public int getQueuedCount() {
        return this.metricsName == null ? 0 : (int)this.supervisor.getReplicationQueuedCount(this.metricsName);
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }
}

