/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptConditionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerScriptConditionEvaluator.class);

    public static ScriptEngine createScriptEngine(String engineName, String serviceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ScriptEngineUtil.createScriptEngine(engineName=" + engineName + ", serviceType=" + serviceType + ")");
        }
        ScriptEngine ret = null;
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            if (LOG.isDebugEnabled()) {
                List<ScriptEngineFactory> factories = manager.getEngineFactories();
                if (CollectionUtils.isEmpty(factories)) {
                    LOG.debug("List of scriptEngineFactories is empty!!");
                } else {
                    for (ScriptEngineFactory factory : factories) {
                        LOG.debug("engineName=" + factory.getEngineName() + ", language=" + factory.getLanguageName());
                    }
                }
            }
            ret = manager.getEngineByName(engineName);
        }
        catch (Throwable exp) {
            LOG.error("RangerScriptConditionEvaluator.init() failed", exp);
        }
        LOG.debug((ret == null ? " Failed to create " : " Created ") + "Script Engine '" + engineName + "' in a default manner.");
        if (ret == null) {
            LOG.warn("Will try to get script-engine from plugin-class-loader for service-type:[" + serviceType + "]");
            try {
                RangerPluginClassLoader pluginClassLoader = RangerPluginClassLoader.getInstance((String)serviceType, null);
                if (pluginClassLoader != null) {
                    ret = pluginClassLoader.getScriptEngine(engineName);
                } else {
                    LOG.error("Cannot get script-engine from null pluginClassLoader");
                }
            }
            catch (Throwable exp) {
                LOG.error("RangerScriptConditionEvaluator.init() failed", exp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ScriptEngineUtil.createScriptEngine(engineName=" + engineName + ", serviceType=" + serviceType + ") : ret=" + ret);
        }
        return ret;
    }
}

