/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;

public class DataNodeSafeModeRule
extends SafeModeExitRule<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> {
    private static final String NAME = "DataNodeSafeModeRule";
    private int requiredDns;
    private int registeredDns = 0;
    private HashSet<UUID> registeredDnSet;

    public DataNodeSafeModeRule(EventQueue eventQueue, ConfigurationSource conf, SCMSafeModeManager manager) {
        super(manager, NAME, eventQueue);
        this.requiredDns = conf.getInt("hdds.scm.safemode.min.datanode", 1);
        this.registeredDnSet = new HashSet(this.requiredDns * 2);
    }

    @Override
    protected TypedEvent<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> getEventType() {
        return SCMEvents.NODE_REGISTRATION_CONT_REPORT;
    }

    @Override
    protected boolean validate() {
        return this.registeredDns >= this.requiredDns;
    }

    @Override
    protected void process(SCMDatanodeProtocolServer.NodeRegistrationContainerReport reportsProto) {
        this.registeredDnSet.add(reportsProto.getDatanodeDetails().getUuid());
        this.registeredDns = this.registeredDnSet.size();
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. {} DataNodes registered, {} required.", (Object)this.registeredDns, (Object)this.requiredDns);
        }
    }

    @Override
    protected void cleanup() {
        this.registeredDnSet.clear();
    }

    @Override
    public String getStatusText() {
        return String.format("registered datanodes (=%d) >= required datanodes (=%d)", this.registeredDns, this.requiredDns);
    }

    @Override
    public void refresh(boolean forceRefresh) {
    }
}

