/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableECContainerProvider
implements WritableContainerProvider<ECReplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(WritableECContainerProvider.class);
    private final NodeManager nodeManager;
    private final PipelineManager pipelineManager;
    private final PipelineChoosePolicy pipelineChoosePolicy;
    private final ContainerManager containerManager;
    private final long containerSize;
    private final WritableECContainerProviderConfig providerConfig;

    public WritableECContainerProvider(WritableECContainerProviderConfig config, long containerSize, NodeManager nodeManager, PipelineManager pipelineManager, ContainerManager containerManager, PipelineChoosePolicy pipelineChoosePolicy) {
        this.providerConfig = config;
        this.nodeManager = nodeManager;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.pipelineChoosePolicy = pipelineChoosePolicy;
        this.containerSize = containerSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerInfo getContainer(long size, ECReplicationConfig repConfig, String owner, ExcludeList excludeList) throws IOException {
        int openPipelineCount;
        int maximumPipelines = this.getMaximumPipelines(repConfig);
        WritableECContainerProvider writableECContainerProvider = this;
        synchronized (writableECContainerProvider) {
            openPipelineCount = this.pipelineManager.getPipelineCount((ReplicationConfig)repConfig, Pipeline.PipelineState.OPEN);
            if (openPipelineCount < maximumPipelines) {
                try {
                    return this.allocateContainer((ReplicationConfig)repConfig, size, owner, excludeList);
                }
                catch (IOException e) {
                    LOG.warn("Unable to allocate a container with {} existing ones; requested size={}, replication={}, owner={}, {}", new Object[]{openPipelineCount, size, repConfig, owner, excludeList, e});
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Pipeline count {} reached limit {}, checking existing ones; requested size={}, replication={}, owner={}, {}", new Object[]{openPipelineCount, maximumPipelines, size, repConfig, owner, excludeList});
            }
        }
        List<Pipeline> existingPipelines = this.pipelineManager.getPipelines((ReplicationConfig)repConfig, Pipeline.PipelineState.OPEN);
        int pipelineCount = existingPipelines.size();
        LOG.debug("Checking existing pipelines: {}", existingPipelines);
        PipelineRequestInformation pri = PipelineRequestInformation.Builder.getBuilder().setSize(size).build();
        while (!existingPipelines.isEmpty()) {
            int pipelineIndex = this.pipelineChoosePolicy.choosePipelineIndex(existingPipelines, pri);
            if (pipelineIndex < 0) {
                LOG.warn("Unable to select a pipeline from {} in the list", (Object)existingPipelines.size());
                break;
            }
            Pipeline pipeline = existingPipelines.get(pipelineIndex);
            PipelineID pipelineID = pipeline.getId();
            synchronized (pipelineID) {
                block24: {
                    try {
                        ContainerInfo containerInfo = this.getContainerFromPipeline(pipeline);
                        if (containerInfo == null || !this.containerHasSpace(containerInfo, size)) {
                            existingPipelines.remove(pipelineIndex);
                            this.pipelineManager.closePipeline(pipeline, true);
                            --openPipelineCount;
                            break block24;
                        }
                        if (this.pipelineIsExcluded(pipeline, containerInfo, excludeList)) {
                            existingPipelines.remove(pipelineIndex);
                            break block24;
                        }
                        containerInfo.updateLastUsedTime();
                        return containerInfo;
                    }
                    catch (ContainerNotFoundException | PipelineNotFoundException e) {
                        LOG.warn("Pipeline or container not found when selecting a writable container", e);
                        existingPipelines.remove(pipelineIndex);
                        this.pipelineManager.closePipeline(pipeline, true);
                        --openPipelineCount;
                    }
                }
            }
        }
        try {
            int nodeCount2;
            if (openPipelineCount >= maximumPipelines && (nodeCount2 = this.nodeManager.getNodeCount(NodeStatus.inServiceHealthy())) > maximumPipelines) {
                LOG.debug("Increasing pipeline limit {} -> {} for final attempt", (Object)maximumPipelines, (Object)nodeCount2);
                maximumPipelines = nodeCount2;
            }
            if (openPipelineCount < maximumPipelines) {
                WritableECContainerProvider nodeCount2 = this;
                synchronized (nodeCount2) {
                    return this.allocateContainer((ReplicationConfig)repConfig, size, owner, excludeList);
                }
            }
            throw new IOException("Pipeline limit (" + maximumPipelines + ") reached (" + openPipelineCount + "), none closed");
        }
        catch (IOException e) {
            LOG.warn("Unable to allocate a container after trying {} existing ones; requested size={}, replication={}, owner={}, {}", new Object[]{pipelineCount, size, repConfig, owner, excludeList, e});
            throw e;
        }
    }

    private int getMaximumPipelines(ECReplicationConfig repConfig) {
        double factor = this.providerConfig.getPipelinePerVolumeFactor();
        int volumeBasedCount = 0;
        if (factor > 0.0) {
            int volumes = this.nodeManager.totalHealthyVolumeCount();
            volumeBasedCount = (int)factor * volumes / repConfig.getRequiredNodes();
        }
        return Math.max(volumeBasedCount, this.providerConfig.getMinimumPipelines());
    }

    private ContainerInfo allocateContainer(ReplicationConfig repConfig, long size, String owner, ExcludeList excludeList) throws IOException {
        List<DatanodeDetails> excludedNodes = Collections.emptyList();
        if (!excludeList.getDatanodes().isEmpty()) {
            excludedNodes = new ArrayList(excludeList.getDatanodes());
        }
        Pipeline newPipeline = this.pipelineManager.createPipeline(repConfig, excludedNodes, Collections.emptyList());
        ContainerInfo container = this.containerManager.getMatchingContainer(size, owner, newPipeline);
        this.pipelineManager.openPipeline(newPipeline.getId());
        LOG.info("Created and opened new pipeline {}", (Object)newPipeline);
        return container;
    }

    private boolean pipelineIsExcluded(Pipeline pipeline, ContainerInfo container, ExcludeList excludeList) {
        if (excludeList.getContainerIds().contains(container.containerID())) {
            return true;
        }
        if (excludeList.getPipelineIds().contains(pipeline.getId())) {
            return true;
        }
        for (DatanodeDetails dn : pipeline.getNodes()) {
            if (!excludeList.getDatanodes().contains(dn)) continue;
            return true;
        }
        return false;
    }

    private ContainerInfo getContainerFromPipeline(Pipeline pipeline) throws IOException {
        NavigableSet<ContainerID> containers = this.pipelineManager.getContainersInPipeline(pipeline.getId());
        if (containers.isEmpty()) {
            return null;
        }
        ContainerID containerID = (ContainerID)containers.first();
        return this.containerManager.getContainer(containerID);
    }

    private boolean containerHasSpace(ContainerInfo container, long size) {
        return container.getUsedBytes() + size <= this.containerSize;
    }

    @ConfigGroup(prefix="ozone.scm.ec")
    public static class WritableECContainerProviderConfig
    extends ReconfigurableConfig {
        private static final String PREFIX = "ozone.scm.ec";
        @Config(key="pipeline.minimum", defaultValue="5", reconfigurable=true, type=ConfigType.INT, description="The minimum number of pipelines to have open for each Erasure Coding configuration", tags={ConfigTag.STORAGE})
        private int minimumPipelines = 5;
        private static final String PIPELINE_PER_VOLUME_FACTOR_KEY = "pipeline.per.volume.factor";
        private static final double PIPELINE_PER_VOLUME_FACTOR_DEFAULT = 1.0;
        private static final String PIPELINE_PER_VOLUME_FACTOR_DEFAULT_VALUE = "1";
        private static final String EC_PIPELINE_PER_VOLUME_FACTOR_KEY = "ozone.scm.ec.pipeline.per.volume.factor";
        @Config(key="pipeline.per.volume.factor", type=ConfigType.DOUBLE, defaultValue="1", reconfigurable=true, tags={ConfigTag.SCM}, description="TODO")
        private double pipelinePerVolumeFactor = 1.0;

        public int getMinimumPipelines() {
            return this.minimumPipelines;
        }

        public void setMinimumPipelines(int minPipelines) {
            this.minimumPipelines = minPipelines;
        }

        public double getPipelinePerVolumeFactor() {
            return this.pipelinePerVolumeFactor;
        }

        @PostConstruct
        public void validate() {
            if (this.pipelinePerVolumeFactor < 0.0) {
                LOG.warn("{} must be non-negative, but was {}. Defaulting to {}", new Object[]{EC_PIPELINE_PER_VOLUME_FACTOR_KEY, this.pipelinePerVolumeFactor, 1.0});
                this.pipelinePerVolumeFactor = 1.0;
            }
        }

        public void setPipelinePerVolumeFactor(double v) {
            this.pipelinePerVolumeFactor = v;
        }
    }
}

