/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.metadata.Replicate;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.utils.db.Table;

public interface PipelineStateManager {
    @Replicate
    public void addPipeline(HddsProtos.Pipeline var1) throws IOException;

    @Replicate
    public void removePipeline(HddsProtos.PipelineID var1) throws IOException;

    @Replicate
    public void updatePipelineState(HddsProtos.PipelineID var1, HddsProtos.PipelineState var2) throws IOException;

    public void addContainerToPipeline(PipelineID var1, ContainerID var2) throws IOException;

    public void addContainerToPipelineForce(PipelineID var1, ContainerID var2) throws IOException;

    public Pipeline getPipeline(PipelineID var1) throws PipelineNotFoundException;

    public List<Pipeline> getPipelines();

    public List<Pipeline> getPipelines(ReplicationConfig var1);

    public List<Pipeline> getPipelines(ReplicationConfig var1, Pipeline.PipelineState var2);

    public List<Pipeline> getPipelines(ReplicationConfig var1, Pipeline.PipelineState var2, Collection<DatanodeDetails> var3, Collection<PipelineID> var4);

    public int getPipelineCount(ReplicationConfig var1, Pipeline.PipelineState var2);

    public NavigableSet<ContainerID> getContainers(PipelineID var1) throws IOException;

    public int getNumberOfContainers(PipelineID var1) throws IOException;

    public void removeContainerFromPipeline(PipelineID var1, ContainerID var2) throws IOException;

    public void close() throws Exception;

    public void reinitialize(Table<PipelineID, Pipeline> var1) throws IOException;
}

