/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.container.ContainerException;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadNodeHandler
implements EventHandler<DatanodeDetails> {
    private final NodeManager nodeManager;
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    @Nullable
    private final DeletedBlockLog deletedBlockLog;
    private static final Logger LOG = LoggerFactory.getLogger(DeadNodeHandler.class);

    public DeadNodeHandler(NodeManager nodeManager, PipelineManager pipelineManager, ContainerManager containerManager) {
        this(nodeManager, pipelineManager, containerManager, null);
    }

    public DeadNodeHandler(NodeManager nodeManager, PipelineManager pipelineManager, ContainerManager containerManager, @Nullable DeletedBlockLog deletedBlockLog) {
        this.nodeManager = nodeManager;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.deletedBlockLog = deletedBlockLog;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        try {
            NetworkTopology nt;
            LOG.info("A dead datanode is detected. {}", (Object)datanodeDetails);
            this.closeContainers(datanodeDetails, publisher);
            this.destroyPipelines(datanodeDetails);
            if (!this.nodeManager.getNodeStatus(datanodeDetails).isInMaintenance()) {
                this.removeContainerReplicas(datanodeDetails);
            }
            List<SCMCommand<?>> cmdList = this.nodeManager.getCommandQueue(datanodeDetails.getUuid());
            LOG.info("Clearing command queue of size {} for DN {}", (Object)cmdList.size(), (Object)datanodeDetails);
            if (this.deletedBlockLog != null && !this.nodeManager.getNodeStatus(datanodeDetails).isInMaintenance()) {
                this.deletedBlockLog.onDatanodeDead(datanodeDetails.getUuid());
            }
            if ((nt = this.nodeManager.getClusterNetworkTopologyMap()).contains((Node)datanodeDetails)) {
                nt.remove((Node)datanodeDetails);
                Preconditions.checkState((this.nodeManager.getNodeByUuid(datanodeDetails.getUuid()).getParent() == null ? 1 : 0) != 0);
            }
        }
        catch (NodeNotFoundException ex) {
            LOG.error("DeadNode event for a unregistered node: {}!", (Object)datanodeDetails);
        }
    }

    private void destroyPipelines(DatanodeDetails datanodeDetails) {
        Optional.ofNullable(this.nodeManager.getPipelines(datanodeDetails)).ifPresent(pipelines -> pipelines.forEach(id -> {
            try {
                this.pipelineManager.closePipeline((PipelineID)id);
                this.pipelineManager.deletePipeline((PipelineID)id);
            }
            catch (PipelineNotFoundException pipelineNotFoundException) {
            }
            catch (IOException ex) {
                LOG.warn("Exception while finalizing pipeline {}", id, (Object)ex);
            }
        }));
    }

    private void closeContainers(DatanodeDetails datanodeDetails, EventPublisher publisher) throws NodeNotFoundException {
        this.nodeManager.getContainers(datanodeDetails).forEach(id -> {
            try {
                ContainerInfo container = this.containerManager.getContainer((ContainerID)id);
                if (container.getState() == HddsProtos.LifeCycleState.OPEN) {
                    publisher.fireEvent(SCMEvents.CLOSE_CONTAINER, id);
                }
            }
            catch (ContainerNotFoundException cnfe) {
                LOG.warn("Container {} is not managed by ContainerManager.", id, (Object)cnfe);
            }
        });
    }

    private void removeContainerReplicas(DatanodeDetails datanodeDetails) throws NodeNotFoundException {
        this.nodeManager.getContainers(datanodeDetails).forEach(id -> {
            try {
                ContainerInfo container = this.containerManager.getContainer((ContainerID)id);
                this.containerManager.getContainerReplicas((ContainerID)id).stream().filter(r -> r.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                    try {
                        this.containerManager.removeContainerReplica((ContainerID)id, (ContainerReplica)replica);
                    }
                    catch (ContainerException ex) {
                        LOG.warn("Exception while removing container replica #{} of container {}.", new Object[]{replica, container, ex});
                    }
                });
            }
            catch (ContainerNotFoundException cnfe) {
                LOG.warn("Container {} is not managed by ContainerManager.", id, (Object)cnfe);
            }
        });
    }

    protected NodeManager getNodeManager() {
        return this.nodeManager;
    }
}

