/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisUnhealthyReplicationCheckHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(RatisUnhealthyReplicationCheckHandler.class);

    @Override
    public boolean handle(ContainerCheckRequest request) {
        if (request.getContainerInfo().getReplicationType() != HddsProtos.ReplicationType.RATIS) {
            return false;
        }
        ReplicationManagerReport report = request.getReport();
        ContainerInfo container = request.getContainerInfo();
        RatisContainerReplicaCount replicaCount = RatisUnhealthyReplicationCheckHandler.getReplicaCount(request);
        if (replicaCount.getHealthyReplicaCount() > 0 || replicaCount.getUnhealthyReplicaCount() == 0) {
            LOG.debug("Not handling container {} with replicas [{}].", (Object)container, request.getContainerReplicas());
            return false;
        }
        LOG.info("Container {} has unhealthy replicas [{}]. Checking its replication status.", (Object)container, replicaCount.getReplicas());
        report.incrementAndSample(ReplicationManagerReport.HealthState.UNHEALTHY, container.containerID());
        ContainerHealthResult health = this.checkReplication(replicaCount);
        if (health.getHealthState() == ContainerHealthResult.HealthState.UNDER_REPLICATED) {
            ContainerHealthResult.UnderReplicatedHealthResult underHealth = (ContainerHealthResult.UnderReplicatedHealthResult)health;
            report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, container.containerID());
            LOG.debug("Container {} is Under Replicated. isReplicatedOkAfterPending is [{}]. isUnrecoverable is [{}]. hasHealthyReplicas is [{}].", new Object[]{container, underHealth.isReplicatedOkAfterPending(), underHealth.isUnrecoverable(), underHealth.hasHealthyReplicas()});
            if (!underHealth.isReplicatedOkAfterPending()) {
                request.getReplicationQueue().enqueue(underHealth);
            }
            return true;
        }
        if (health.getHealthState() == ContainerHealthResult.HealthState.OVER_REPLICATED) {
            report.incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, container.containerID());
            ContainerHealthResult.OverReplicatedHealthResult overHealth = (ContainerHealthResult.OverReplicatedHealthResult)health;
            LOG.debug("Container {} is Over Replicated. isReplicatedOkAfterPending is [{}]. hasMismatchedReplicas is [{}]", new Object[]{container, overHealth.isReplicatedOkAfterPending(), overHealth.hasMismatchedReplicas()});
            if (!overHealth.isReplicatedOkAfterPending()) {
                request.getReplicationQueue().enqueue(overHealth);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    ContainerHealthResult checkReplication(ContainerCheckRequest request) {
        return this.checkReplication(RatisUnhealthyReplicationCheckHandler.getReplicaCount(request));
    }

    private static RatisContainerReplicaCount getReplicaCount(ContainerCheckRequest request) {
        return new RatisContainerReplicaCount(request.getContainerInfo(), request.getContainerReplicas(), request.getPendingOps(), request.getMaintenanceRedundancy(), true);
    }

    private ContainerHealthResult checkReplication(RatisContainerReplicaCount replicaCount) {
        boolean sufficientlyReplicated = replicaCount.isSufficientlyReplicated(false);
        if (!sufficientlyReplicated) {
            return replicaCount.toUnderHealthResult();
        }
        boolean isOverReplicated = replicaCount.isOverReplicated(false);
        if (isOverReplicated) {
            return replicaCount.toOverHealthResult();
        }
        return new ContainerHealthResult.UnHealthyResult(replicaCount.getContainer());
    }
}

