/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContainerPlacementRandom
extends SCMCommonPlacementPolicy
implements PlacementPolicy {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(SCMContainerPlacementRandom.class);
    private final SCMContainerPlacementMetrics metrics;

    public SCMContainerPlacementRandom(NodeManager nodeManager, ConfigurationSource conf, NetworkTopology networkTopology, boolean fallback, SCMContainerPlacementMetrics metrics) {
        super(nodeManager, conf);
        this.metrics = metrics;
    }

    @Override
    protected List<DatanodeDetails> chooseDatanodesInternal(List<DatanodeDetails> usedNodes, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        this.metrics.incrDatanodeRequestCount(nodesRequired);
        List<DatanodeDetails> healthyNodes = super.chooseDatanodesInternal(usedNodes, excludedNodes, favoredNodes, nodesRequired, metadataSizeRequired, dataSizeRequired);
        if (healthyNodes.size() == nodesRequired) {
            return healthyNodes;
        }
        return this.getResultSet(nodesRequired, healthyNodes);
    }

    @Override
    public DatanodeDetails chooseNode(List<DatanodeDetails> healthyNodes) {
        this.metrics.incrDatanodeChooseAttemptCount();
        DatanodeDetails selectedNode = healthyNodes.get(this.getRand().nextInt(healthyNodes.size()));
        healthyNodes.remove(selectedNode);
        this.metrics.incrDatanodeChooseSuccessCount();
        return selectedNode;
    }
}

