/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContainerPlacementRackScatter
extends SCMCommonPlacementPolicy {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(SCMContainerPlacementRackScatter.class);
    private final NetworkTopology networkTopology;
    private static final int RACK_LEVEL = 1;
    private static final int OUTER_LOOP_MAX_RETRY = 3;
    private static final int INNER_LOOP_MAX_RETRY = 5;
    private final SCMContainerPlacementMetrics metrics;

    public SCMContainerPlacementRackScatter(NodeManager nodeManager, ConfigurationSource conf, NetworkTopology networkTopology, boolean fallback, SCMContainerPlacementMetrics metrics) {
        super(nodeManager, conf);
        this.networkTopology = networkTopology;
        this.metrics = metrics;
    }

    public SCMContainerPlacementRackScatter(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf) {
        super(nodeManager, conf);
        this.networkTopology = nodeManager.getClusterNetworkTopologyMap();
        this.metrics = null;
    }

    private Set<DatanodeDetails> chooseNodesFromRacks(List<Node> racks, List<Node> unavailableNodes, List<DatanodeDetails> mutableFavoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired, int maxOuterLoopIterations, Map<Node, Integer> rackCntMap, int maxReplicasPerRack) {
        if (nodesRequired <= 0) {
            return Collections.emptySet();
        }
        LinkedList<Object> toChooseRacks = new LinkedList<Object>();
        LinkedHashSet<DatanodeDetails> chosenNodes = new LinkedHashSet<DatanodeDetails>();
        HashSet<Node> skippedRacks = new HashSet<Node>();
        int retryCount = 0;
        while (nodesRequired > 0 && maxOuterLoopIterations > 0) {
            if (retryCount > 3) {
                return chosenNodes;
            }
            int chosenListSize = chosenNodes.size();
            for (Node node : racks) {
                if (rackCntMap.getOrDefault(node, 0) >= maxReplicasPerRack) continue;
                toChooseRacks.add(node);
            }
            if (!skippedRacks.isEmpty()) {
                toChooseRacks.removeAll(skippedRacks);
                toChooseRacks.addAll(0, skippedRacks);
                skippedRacks.clear();
            }
            if (!mutableFavoredNodes.isEmpty()) {
                ArrayList<DatanodeDetails> chosenFavoredNodesInForLoop = new ArrayList<DatanodeDetails>();
                for (DatanodeDetails favoredNode : mutableFavoredNodes) {
                    Node curRack = this.getRackOfDatanodeDetails(favoredNode);
                    if (!toChooseRacks.contains(curRack)) continue;
                    chosenNodes.add(favoredNode);
                    rackCntMap.merge(curRack, 1, Math::addExact);
                    toChooseRacks.remove(curRack);
                    chosenFavoredNodesInForLoop.add(favoredNode);
                    unavailableNodes.add((Node)favoredNode);
                    if (--nodesRequired != 0) continue;
                    break;
                }
                mutableFavoredNodes.removeAll(chosenFavoredNodesInForLoop);
            }
            if (nodesRequired == 0) break;
            for (Node node : toChooseRacks) {
                if (node == null) continue;
                Node node2 = this.chooseNode(node.getNetworkFullPath(), unavailableNodes, metadataSizeRequired, dataSizeRequired);
                if (node2 != null) {
                    chosenNodes.add((DatanodeDetails)node2);
                    rackCntMap.merge(node, 1, Math::addExact);
                    mutableFavoredNodes.remove(node2);
                    unavailableNodes.add(node2);
                    if (--nodesRequired != 0) continue;
                    break;
                }
                skippedRacks.add(node);
            }
            toChooseRacks.clear();
            retryCount = chosenListSize == chosenNodes.size() ? ++retryCount : 0;
            --maxOuterLoopIterations;
        }
        return chosenNodes;
    }

    @Override
    protected List<DatanodeDetails> chooseDatanodesInternal(List<DatanodeDetails> usedNodes, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        ContainerPlacementStatus initialPlacementStatus;
        if (nodesRequired <= 0) {
            String errorMsg = "num of nodes required to choose should biggerthan 0, but the given num is " + nodesRequired;
            throw new SCMException(errorMsg, null);
        }
        if (this.metrics != null) {
            this.metrics.incrDatanodeRequestCount(nodesRequired);
        }
        int excludedNodesCount = excludedNodes == null ? 0 : excludedNodes.size();
        int usedNodesCount = usedNodes == null ? 0 : usedNodes.size();
        List availableNodes = this.networkTopology.getNodes(this.networkTopology.getMaxLevel());
        int totalNodesCount = availableNodes.size();
        if (excludedNodes != null) {
            availableNodes.removeAll(excludedNodes);
        }
        if (usedNodes != null) {
            availableNodes.removeAll(usedNodes);
        }
        if (availableNodes.size() < nodesRequired) {
            throw new SCMException("No enough datanodes to choose. TotalNodes = " + totalNodesCount + " AvailableNodes = " + availableNodes.size() + " RequiredNodes = " + nodesRequired + " ExcludedNodes = " + excludedNodesCount + " UsedNodes = " + usedNodesCount, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        ArrayList<DatanodeDetails> mutableFavoredNodes = new ArrayList<DatanodeDetails>();
        if (favoredNodes != null) {
            for (DatanodeDetails datanodeDetails : favoredNodes) {
                if (!this.isValidNode(datanodeDetails, metadataSizeRequired, dataSizeRequired)) continue;
                mutableFavoredNodes.add(datanodeDetails);
            }
            Collections.shuffle(mutableFavoredNodes);
        }
        if (excludedNodes != null) {
            mutableFavoredNodes.removeAll(excludedNodes);
        }
        if (usedNodes == null) {
            usedNodes = Collections.emptyList();
        }
        List<Node> racks = this.getAllRacks();
        HashMap<Node, Integer> usedRacksCntMap = new HashMap<Node, Integer>();
        for (Object node : usedNodes) {
            Node rack = this.networkTopology.getAncestor((Node)node, 1);
            if (rack == null) continue;
            usedRacksCntMap.merge(rack, 1, Math::addExact);
        }
        List<Node> unavailableRacks = this.findRacksWithOnlyExcludedNodes(excludedNodes, usedRacksCntMap);
        for (Node rack : unavailableRacks) {
            racks.remove(rack);
        }
        int requiredReplicationFactor = usedNodes.size() + nodesRequired;
        int numberOfRacksRequired = this.getRequiredRackCount(requiredReplicationFactor, unavailableRacks.size());
        int additionalRacksRequired = Math.min(nodesRequired, numberOfRacksRequired - usedRacksCntMap.size());
        LOG.debug("Additional nodes required: {}. Additional racks required: {}.", (Object)nodesRequired, (Object)additionalRacksRequired);
        int maxReplicasPerRack = this.getMaxReplicasPerRack(requiredReplicationFactor, numberOfRacksRequired);
        LOG.debug("According to required replication factor: {}, and total number of racks required: {}, max replicas per rack is {}.", new Object[]{requiredReplicationFactor, numberOfRacksRequired, maxReplicasPerRack});
        racks = this.sortRackWithExcludedNodes(racks, excludedNodes, usedRacksCntMap);
        ArrayList<Object> unavailableNodes = new ArrayList<Object>(usedNodes);
        if (excludedNodes != null) {
            unavailableNodes.addAll(excludedNodes);
        }
        LOG.debug("Available racks excluding racks with used nodes: {}.", racks);
        if (racks.size() < additionalRacksRequired) {
            String reason = "Number of existing racks: " + racks.size() + "is less than additional required number of racks to choose: " + additionalRacksRequired + " do not match.";
            LOG.warn("Placement policy cannot choose the enough racks. {}Total number of Required Racks: {} Used Racks Count: {}, Required Nodes count: {}", new Object[]{reason, numberOfRacksRequired, usedRacksCntMap.size(), nodesRequired});
            throw new SCMException(reason, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        LinkedHashSet<DatanodeDetails> chosenNodes = new LinkedHashSet<DatanodeDetails>(this.chooseNodesFromRacks(racks, unavailableNodes, mutableFavoredNodes, additionalRacksRequired, metadataSizeRequired, dataSizeRequired, maxReplicasPerRack, usedRacksCntMap, maxReplicasPerRack));
        if (chosenNodes.size() < additionalRacksRequired) {
            String reason = "Chosen nodes size from Unique Racks: " + chosenNodes.size() + ", but required nodes to choose from Unique Racks: " + additionalRacksRequired + " do not match.";
            LOG.warn("Placement policy could not choose the enough nodes from available racks. {} Available racks count: {}, Excluded nodes count: {}, UsedNodes count: {}", new Object[]{reason, racks.size(), excludedNodesCount, usedNodesCount});
            throw new SCMException(reason, SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
        if (chosenNodes.size() < nodesRequired) {
            racks.addAll(usedRacksCntMap.keySet());
            racks = this.sortRackWithExcludedNodes(racks, excludedNodes, usedRacksCntMap);
            racks.addAll(usedRacksCntMap.keySet());
            LOG.debug("Available racks considering racks with used and exclude nodes: {}.", racks);
            chosenNodes.addAll(this.chooseNodesFromRacks(racks, unavailableNodes, mutableFavoredNodes, nodesRequired - chosenNodes.size(), metadataSizeRequired, dataSizeRequired, Integer.MAX_VALUE, usedRacksCntMap, maxReplicasPerRack));
        }
        ArrayList<DatanodeDetails> result = new ArrayList<DatanodeDetails>(chosenNodes);
        if (nodesRequired != chosenNodes.size()) {
            String reason = "Chosen nodes size: " + chosenNodes.size() + ", but required nodes to choose: " + nodesRequired + " do not match.";
            LOG.warn("Placement policy could not choose the enough nodes. {} Available nodes count: {}, Excluded nodes count: {},  Used nodes count: {}", new Object[]{reason, totalNodesCount, excludedNodesCount, usedNodesCount});
            throw new SCMException(reason, SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
        ArrayList<DatanodeDetails> newPlacement = new ArrayList<DatanodeDetails>(usedNodes.size() + result.size());
        newPlacement.addAll(usedNodes);
        newPlacement.addAll(chosenNodes);
        ContainerPlacementStatus placementStatus = this.validateContainerPlacement(newPlacement, requiredReplicationFactor);
        if (!placementStatus.isPolicySatisfied() && (initialPlacementStatus = this.validateContainerPlacement(usedNodes, requiredReplicationFactor)).misReplicationCount() < placementStatus.misReplicationCount()) {
            String errorMsg = "ContainerPlacementPolicy not met. Misreplication Reason: " + placementStatus.misReplicatedReason() + " Initial Used nodes mis-replication Count: " + initialPlacementStatus.misReplicationCount() + " Used nodes + Chosen nodes mis-replication Count: " + placementStatus.misReplicationCount();
            throw new SCMException(errorMsg, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        LOG.info("Chosen nodes: {}. isPolicySatisfied: {}.", result, (Object)placementStatus.isPolicySatisfied());
        return result;
    }

    private List<Node> findRacksWithOnlyExcludedNodes(List<DatanodeDetails> excludedNodes, Map<Node, Integer> usedRacksCntMap) {
        if (excludedNodes == null || excludedNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Node> unavailableRacks = new ArrayList<Node>();
        HashSet<Node> excludedNodeRacks = new HashSet<Node>();
        for (Node node : excludedNodes) {
            Node rack = this.networkTopology.getAncestor(node, 1);
            if (rack == null || usedRacksCntMap.containsKey(rack)) continue;
            excludedNodeRacks.add(rack);
        }
        HashSet<DatanodeDetails> exc = new HashSet<DatanodeDetails>(excludedNodes);
        for (Node rack : excludedNodeRacks) {
            Node node;
            String rackPath = rack.getNetworkFullPath();
            if (this.networkTopology.getNode(rackPath) == null || (node = this.networkTopology.chooseRandom(rack.getNetworkFullPath(), exc)) != null) continue;
            unavailableRacks.add(rack);
        }
        return unavailableRacks;
    }

    @Override
    public DatanodeDetails chooseNode(List<DatanodeDetails> healthyNodes) {
        return null;
    }

    private Node chooseNode(String scope, List<Node> excludedNodes, long metadataSizeRequired, long dataSizeRequired) {
        int maxRetry = 5;
        do {
            Node node;
            block7: {
                if (this.metrics != null) {
                    this.metrics.incrDatanodeChooseAttemptCount();
                }
                node = null;
                try {
                    node = this.networkTopology.chooseRandom(scope, excludedNodes);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("Error while choosing Node: Scope: {}, Excluded Nodes: {}, MetaDataSizeRequired: {}, DataSizeRequired: {}", new Object[]{scope, excludedNodes, metadataSizeRequired, dataSizeRequired, e});
                }
            }
            if (node != null) {
                DatanodeDetails datanodeDetails = (DatanodeDetails)node;
                if (this.isValidNode(datanodeDetails, metadataSizeRequired, dataSizeRequired)) {
                    if (this.metrics != null) {
                        this.metrics.incrDatanodeChooseSuccessCount();
                    }
                    return node;
                }
                excludedNodes.add(node);
                continue;
            }
            LOG.debug("Failed to find the datanode for container. excludedNodes: {}, rack {}", excludedNodes, (Object)scope);
        } while (--maxRetry != 0);
        LOG.info("No satisfied datanode to meet the constraints. Metadatadata size required: {} Data size required: {}, scope {}, excluded nodes {}", new Object[]{metadataSizeRequired, dataSizeRequired, scope, excludedNodes});
        return null;
    }

    @Override
    protected int getRequiredRackCount(int numReplicas, int excludedRackCount) {
        if (this.networkTopology == null) {
            return 1;
        }
        int maxLevel = this.networkTopology.getMaxLevel();
        int numRacks = this.networkTopology.getNumOfNodes(maxLevel - 1) - excludedRackCount;
        return Math.min(numRacks, numReplicas);
    }

    private Node getRackOfDatanodeDetails(DatanodeDetails datanodeDetails) {
        String location = datanodeDetails.getNetworkLocation();
        return this.networkTopology.getNode(location);
    }

    private List<Node> sortRackWithExcludedNodes(List<Node> racks, List<DatanodeDetails> excludedNodes, Map<Node, Integer> usedRacks) {
        if ((excludedNodes == null || excludedNodes.isEmpty()) && usedRacks.isEmpty()) {
            return racks;
        }
        HashSet<Node> lessPreferredRacks = new HashSet<Node>();
        for (Node node : excludedNodes) {
            Node rack = this.networkTopology.getAncestor(node, 1);
            if (rack == null || usedRacks.containsKey(rack)) continue;
            lessPreferredRacks.add(rack);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node rack : racks) {
            if (usedRacks.containsKey(rack) || lessPreferredRacks.contains(rack)) continue;
            result.add(rack);
        }
        result.addAll(lessPreferredRacks);
        return result;
    }

    private List<Node> getAllRacks() {
        int rackLevel = this.networkTopology.getMaxLevel() - 1;
        List racks = this.networkTopology.getNodes(rackLevel);
        Collections.shuffle(racks);
        return racks;
    }
}

